/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips;

import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsConsistencyTestFailedError;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsSelfTestFailedError;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsStatus;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.VariantInternalKatTest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.VariantKatTest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.test.BasicKatTest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.test.ConsistencyTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelfTestExecutor {
    SelfTestExecutor() {
    }

    static <T> T validate(FipsAlgorithm fipsAlgorithm, T t, BasicKatTest<T> basicKatTest) {
        try {
            if (!basicKatTest.hasTestPassed(t)) {
                FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Self test failed", fipsAlgorithm));
            }
            return t;
        }
        catch (Exception exception) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Exception on self test: " + exception.getMessage(), fipsAlgorithm));
            return null;
        }
    }

    static <T> T validate(FipsAlgorithm fipsAlgorithm, T t, VariantKatTest<T> variantKatTest) {
        try {
            variantKatTest.evaluate(t);
            return t;
        }
        catch (TestFailedException testFailedException) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError(testFailedException.getMessage(), fipsAlgorithm));
        }
        catch (Exception exception) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Exception on self test: " + exception.getMessage(), fipsAlgorithm));
        }
        return null;
    }

    static void validate(FipsAlgorithm fipsAlgorithm, VariantInternalKatTest variantInternalKatTest) {
        try {
            if (!fipsAlgorithm.equals(variantInternalKatTest.getAlgorithm())) {
                throw new TestFailedException("Inconsistent algorithm tag for " + fipsAlgorithm);
            }
            variantInternalKatTest.evaluate();
        }
        catch (TestFailedException testFailedException) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError(testFailedException.getMessage(), fipsAlgorithm));
        }
        catch (Exception exception) {
            FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Exception on self test: " + exception.getMessage(), fipsAlgorithm));
        }
    }

    static <T> T validate(FipsAlgorithm fipsAlgorithm, T t, ConsistencyTest<T> consistencyTest) {
        try {
            if (!consistencyTest.hasTestPassed(t)) {
                FipsStatus.moveToErrorStatus(new FipsConsistencyTestFailedError("Consistency test failed", fipsAlgorithm));
            }
            return t;
        }
        catch (Exception exception) {
            FipsStatus.moveToErrorStatus(new FipsConsistencyTestFailedError("Exception on consistency test: " + exception.getMessage(), fipsAlgorithm));
            return null;
        }
    }

    static <T> T fail(FipsAlgorithm fipsAlgorithm, T t, BasicKatTest<T> basicKatTest) {
        FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Self test failed", fipsAlgorithm));
        return null;
    }

    static <T> T fail(FipsAlgorithm fipsAlgorithm, T t, VariantKatTest<T> variantKatTest) {
        FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Kat test failed", fipsAlgorithm));
        return null;
    }

    static void fail(FipsAlgorithm fipsAlgorithm, VariantInternalKatTest variantInternalKatTest) {
        FipsStatus.moveToErrorStatus(new FipsSelfTestFailedError("Internal kat test failed", fipsAlgorithm));
    }

    static <T> T fail(FipsAlgorithm fipsAlgorithm, T t, ConsistencyTest<T> consistencyTest) {
        FipsStatus.moveToErrorStatus(new FipsConsistencyTestFailedError("Consistency test failed", fipsAlgorithm));
        return null;
    }

    static class TestFailedException
    extends RuntimeException {
        public TestFailedException(String string) {
            super(string);
        }
    }
}

