/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.snowflake.client.jdbc.internal.org.bouncycastle.LICENSE;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsAES;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsDH;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsDRBG;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsDSA;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsEC;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsKDF;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsOperationError;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsPBKD;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsRSA;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsSHS;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsTripleDES;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.SHA256Digest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.macs.HMac;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Pack;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Strings;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.encoders.Hex;

public final class FipsStatus {
    public static final String READY = "READY";
    private static final String[] classes = new String[]{FipsAES.class.getName(), FipsTripleDES.class.getName(), FipsDH.class.getName(), FipsDRBG.class.getName(), FipsDSA.class.getName(), FipsEC.class.getName(), FipsKDF.class.getName(), FipsPBKD.class.getName(), FipsRSA.class.getName(), FipsSHS.class.getName()};
    private static volatile Loader loader;
    private static volatile Throwable statusException;

    private FipsStatus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReady() {
        String string = READY;
        synchronized (READY) {
            if (loader == null && statusException == null) {
                try {
                    loader = new Loader();
                }
                catch (Exception exception) {
                    statusException = exception;
                    FipsStatus.moveToErrorStatus(new FipsOperationError("Module startup failed: " + exception.getMessage(), exception));
                }
                FipsStatus.checksumValidate();
            } else if (statusException != null) {
                throw new FipsOperationError("Module in error status: " + statusException.getMessage(), statusException);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return true;
        }
    }

    private static void checksumValidate() {
        JarFile jarFile = AccessController.doPrivileged(new PrivilegedAction<JarFile>(){

            @Override
            public JarFile run() {
                return FipsStatus.getJarFile();
            }
        });
        if (jarFile != null) {
            try {
                int n;
                byte[] byArray = FipsStatus.calculateModuleHMAC(jarFile);
                InputStream inputStream = jarFile.getInputStream(jarFile.getEntry("META-INF/HMAC.SHA256"));
                StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
                while ((n = inputStream.read()) >= 0 && n != 13 && n != 10) {
                    stringBuilder.append((char)n);
                }
                byte[] byArray2 = Hex.decode(stringBuilder.toString().trim());
                if (!Arrays.areEqual(byArray, byArray2)) {
                    FipsStatus.moveToErrorStatus((Object)((Object)new FipsOperationError("Module checksum failed: expected [" + stringBuilder.toString().trim() + "] got [" + Strings.fromByteArray(Hex.encode(byArray)))) + "]");
                }
            }
            catch (Exception exception) {
                statusException = exception;
                FipsStatus.moveToErrorStatus(new FipsOperationError("Module checksum failed: " + exception.getMessage(), exception));
            }
        }
    }

    public static String getStatusMessage() {
        try {
            FipsStatus.isReady();
        }
        catch (FipsOperationError fipsOperationError) {
            // empty catch block
        }
        if (statusException != null) {
            return statusException.getMessage();
        }
        return READY;
    }

    private static void loadClass(String string) {
        try {
            Class.forName(string);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            statusException = exceptionInInitializerError.getCause() != null ? exceptionInInitializerError.getCause() : exceptionInInitializerError;
            throw exceptionInInitializerError;
        }
        catch (ClassNotFoundException classNotFoundException) {
            statusException = classNotFoundException;
            throw new IllegalStateException("Unable to initialize module: " + classNotFoundException.getMessage(), classNotFoundException);
        }
    }

    public static byte[] getModuleHMAC() {
        try {
            return FipsStatus.calculateModuleHMAC(FipsStatus.getJarFile());
        }
        catch (Exception exception) {
            return new byte[32];
        }
    }

    private static byte[] calculateModuleHMAC(JarFile jarFile) {
        try {
            Object object4;
            Object object2;
            HMac hMac = new HMac(new SHA256Digest());
            hMac.init(new KeyParameterImpl(Strings.toByteArray("Legion of the Bouncy Castle Inc.")));
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            Object object3 = jarFile.entries();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                if (((ZipEntry)object2).isDirectory() || ((ZipEntry)object2).getName().startsWith("META-INF/") || (object4 = treeMap.put(((ZipEntry)object2).getName(), object2)) == null) continue;
                IllegalStateException illegalStateException = new IllegalStateException("Unable to initialize module: duplicate entry found in jar file");
                statusException = illegalStateException;
                throw illegalStateException;
            }
            object3 = new byte[8192];
            for (Object object4 : treeMap.keySet()) {
                int n;
                JarEntry jarEntry = (JarEntry)treeMap.get(object4);
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                byte[] byArray = Strings.toUTF8ByteArray(jarEntry.getName());
                hMac.update((byte)91);
                hMac.update(byArray, 0, byArray.length);
                hMac.update(Pack.longToBigEndian(jarEntry.getSize()), 0, 8);
                hMac.update((byte)93);
                while ((n = inputStream.read((byte[])object3, 0, ((Object)object3).length)) != -1) {
                    hMac.update((byte[])object3, 0, n);
                }
                inputStream.close();
            }
            hMac.update((byte)91);
            object2 = Strings.toUTF8ByteArray("END");
            hMac.update((byte[])object2, 0, ((Object)object2).length);
            hMac.update((byte)93);
            object4 = new byte[hMac.getMacSize()];
            hMac.doFinal((byte[])object4, 0);
            return object4;
        }
        catch (Exception exception) {
            return new byte[32];
        }
    }

    private static JarFile getJarFile() {
        JarFile jarFile = null;
        String string = LICENSE.class.getCanonicalName().replace(".", "/").replace("LICENSE", "MARKER");
        String string2 = FipsStatus.getMarker(LICENSE.class, string);
        if (string2 != null && string2.startsWith("jar:file:") && string2.contains("!/")) {
            try {
                String string3 = URLDecoder.decode(string2.substring("jar:file:".length(), string2.lastIndexOf("!/")), "UTF-8");
                jarFile = new JarFile(string3);
            }
            catch (IOException iOException) {
                jarFile = null;
            }
        }
        return jarFile;
    }

    static void moveToErrorStatus(String string) {
        FipsStatus.moveToErrorStatus(new FipsOperationError(string));
    }

    static void moveToErrorStatus(FipsOperationError fipsOperationError) {
        statusException = fipsOperationError;
        throw (FipsOperationError)((Object)statusException);
    }

    public static boolean isErrorStatus() {
        return statusException != null;
    }

    static String getMarker(Class clazz, final String string) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            return classLoader.getResource(string).toString();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return ClassLoader.getSystemResource(string).toString();
            }
        });
    }

    static class Loader {
        Loader() throws Exception {
            for (String string : classes) {
                if (FipsStatus.isErrorStatus()) continue;
                FipsStatus.loadClass(string);
            }
        }
    }
}

