/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips;

import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.ParametersWithIV;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsDRBG;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.Mode;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.Padding;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.Utils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.BlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.BufferedBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.CipherParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.EngineProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.modes.CBCBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.modes.CCMBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.modes.CFBBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.modes.GCMBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.modes.NISTCTSBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.modes.OFBBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.modes.SICBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.paddings.ISO10126d2Padding;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.paddings.ISO7816d4Padding;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.paddings.PKCS7Padding;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.paddings.PaddedBufferedBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.paddings.TBCPadding;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.paddings.X923Padding;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Pack;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlockCipherUtils {
    private static SecureRandom defaultRandomPadder;

    BlockCipherUtils() {
    }

    static BufferedBlockCipher createBlockCipher(EngineProvider<BlockCipher> engineProvider, FipsParameters fipsParameters) {
        BlockCipher blockCipher = engineProvider.createEngine();
        Padding padding = (Padding)fipsParameters.getAlgorithm().additionalVariation();
        switch ((Mode)fipsParameters.getAlgorithm().basicVariation()) {
            case ECB: {
                break;
            }
            case CBC: {
                if (padding == Padding.CS1 || padding == Padding.CS2 || padding == Padding.CS3) break;
                blockCipher = new CBCBlockCipher(blockCipher);
                break;
            }
            case CFB8: {
                blockCipher = new CFBBlockCipher(blockCipher, 8);
                break;
            }
            case CFB64: {
                blockCipher = new CFBBlockCipher(blockCipher, 64);
                break;
            }
            case CFB128: {
                blockCipher = new CFBBlockCipher(blockCipher, 128);
                break;
            }
            case OFB64: {
                blockCipher = new OFBBlockCipher(blockCipher, 64);
                break;
            }
            case OFB128: {
                blockCipher = new OFBBlockCipher(blockCipher, 128);
                break;
            }
            case CTR: {
                blockCipher = new SICBlockCipher(blockCipher);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode passed to createBlockCipher: " + fipsParameters.getAlgorithm());
            }
        }
        if (padding != null) {
            switch (padding) {
                case PKCS7: {
                    return new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding());
                }
                case ISO7816_4: {
                    return new PaddedBufferedBlockCipher(blockCipher, new ISO7816d4Padding());
                }
                case ISO10126_2: {
                    return new PaddedBufferedBlockCipher(blockCipher, new ISO10126d2Padding());
                }
                case TBC: {
                    return new PaddedBufferedBlockCipher(blockCipher, new TBCPadding());
                }
                case X923: {
                    return new PaddedBufferedBlockCipher(blockCipher, new X923Padding());
                }
                case CS1: {
                    return new NISTCTSBlockCipher(1, blockCipher);
                }
                case CS2: {
                    return new NISTCTSBlockCipher(2, blockCipher);
                }
                case CS3: {
                    return new NISTCTSBlockCipher(3, blockCipher);
                }
            }
            throw new IllegalArgumentException("Unknown padding passed to createBlockCipher: " + fipsParameters.getAlgorithm());
        }
        return new BufferedBlockCipher(blockCipher);
    }

    static BufferedBlockCipher createStandardCipher(boolean bl, ValidatedSymmetricKey validatedSymmetricKey, EngineProvider<BlockCipher> engineProvider, ParametersWithIV parametersWithIV, SecureRandom secureRandom) {
        Padding padding;
        BufferedBlockCipher bufferedBlockCipher = BlockCipherUtils.createBlockCipher(engineProvider, (FipsParameters)((Object)parametersWithIV));
        CipherParameters cipherParameters = Utils.getKeyParameter(validatedSymmetricKey);
        if (parametersWithIV.getIV() != null) {
            cipherParameters = new net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.ParametersWithIV(cipherParameters, parametersWithIV.getIV());
        }
        if (((FipsAlgorithm)parametersWithIV.getAlgorithm()).additionalVariation() instanceof Padding && (padding = (Padding)((FipsAlgorithm)parametersWithIV.getAlgorithm()).additionalVariation()).getBasePadding().requiresRandom() && bl) {
            if (secureRandom != null) {
                cipherParameters = new ParametersWithRandom(cipherParameters, secureRandom);
            } else {
                try {
                    cipherParameters = new ParametersWithRandom(cipherParameters, CryptoServicesRegistrar.getSecureRandom());
                }
                catch (IllegalStateException illegalStateException) {
                    cipherParameters = new ParametersWithRandom(cipherParameters, BlockCipherUtils.getDefaultRandomPadder());
                }
            }
        }
        bufferedBlockCipher.init(bl, cipherParameters);
        return bufferedBlockCipher;
    }

    static AEADBlockCipher createAEADCipher(FipsAlgorithm fipsAlgorithm, EngineProvider<BlockCipher> engineProvider) {
        AEADBlockCipher aEADBlockCipher;
        switch ((Mode)fipsAlgorithm.basicVariation()) {
            case CCM: {
                aEADBlockCipher = new CCMBlockCipher(engineProvider.createEngine());
                break;
            }
            case GCM: {
                aEADBlockCipher = new GCMBlockCipher(engineProvider.createEngine());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to createAEADCipher: " + fipsAlgorithm);
            }
        }
        return aEADBlockCipher;
    }

    static synchronized SecureRandom getDefaultRandomPadder() {
        if (defaultRandomPadder == null) {
            defaultRandomPadder = FipsDRBG.SHA512.fromDefaultEntropy().setPersonalizationString(Strings.toByteArray("Bouncy Castle FIPS Default Padder")).build(Pack.longToBigEndian(System.currentTimeMillis()), false);
        }
        return defaultRandomPadder;
    }
}

