/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricRSAKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.KeyUtils;

public final class AsymmetricRSAPublicKey
extends AsymmetricRSAKey
implements AsymmetricPublicKey {
    private final BigInteger publicExponent;

    public AsymmetricRSAPublicKey(Algorithm algorithm, BigInteger bigInteger, BigInteger bigInteger2) {
        super(algorithm, KeyUtils.validated(bigInteger, bigInteger2));
        this.publicExponent = bigInteger2;
    }

    public AsymmetricRSAPublicKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, SubjectPublicKeyInfo.getInstance(byArray));
    }

    public AsymmetricRSAPublicKey(Algorithm algorithm, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this(algorithm, subjectPublicKeyInfo.getAlgorithm(), AsymmetricRSAPublicKey.parsePublicKey(subjectPublicKeyInfo));
    }

    private static RSAPublicKey parsePublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        try {
            return RSAPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to parse public key: " + iOException.getMessage(), iOException);
        }
    }

    private AsymmetricRSAPublicKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier, RSAPublicKey rSAPublicKey) {
        super(algorithm, algorithmIdentifier, KeyUtils.validated(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent()));
        this.publicExponent = rSAPublicKey.getPublicExponent();
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public byte[] getEncoded() {
        return KeyUtils.getEncodedSubjectPublicKeyInfo(this.rsaAlgIdentifier, new RSAPublicKey(this.getModulus(), this.getPublicExponent()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricRSAPublicKey)) {
            return false;
        }
        AsymmetricRSAPublicKey asymmetricRSAPublicKey = (AsymmetricRSAPublicKey)object;
        if (!this.getModulus().equals(asymmetricRSAPublicKey.getModulus())) {
            return false;
        }
        return this.publicExponent.equals(asymmetricRSAPublicKey.publicExponent);
    }

    public int hashCode() {
        int n = this.getModulus().hashCode();
        n = 31 * n + this.publicExponent.hashCode();
        return n;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.zeroize();
    }
}

