/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric;

import java.util.HashSet;
import java.util.Set;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.DSAParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.KeyUtils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;

public abstract class AsymmetricDSAKey
implements AsymmetricKey {
    private static final Set<ASN1ObjectIdentifier> dsaOids = new HashSet<ASN1ObjectIdentifier>(3);
    private final boolean approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
    private final Algorithm algorithm;
    private final DSADomainParameters domainParameters;

    AsymmetricDSAKey(Algorithm algorithm, DSADomainParameters dSADomainParameters) {
        this.algorithm = algorithm;
        this.domainParameters = dSADomainParameters;
    }

    AsymmetricDSAKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier) {
        this.algorithm = algorithm;
        this.domainParameters = AsymmetricDSAKey.decodeDomainParameters(algorithmIdentifier);
    }

    private static DSADomainParameters decodeDomainParameters(AlgorithmIdentifier algorithmIdentifier) {
        if (!dsaOids.contains(algorithmIdentifier.getAlgorithm())) {
            throw new IllegalArgumentException("Unknown algorithm type: " + algorithmIdentifier.getAlgorithm());
        }
        if (KeyUtils.isNotNull(algorithmIdentifier.getParameters())) {
            DSAParameter dSAParameter = DSAParameter.getInstance(algorithmIdentifier.getParameters());
            return new DSADomainParameters(dSAParameter.getP(), dSAParameter.getQ(), dSAParameter.getG());
        }
        return null;
    }

    public final Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public final DSADomainParameters getDomainParameters() {
        return this.domainParameters;
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (this.approvedModeOnly != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }

    static {
        dsaOids.add(X9ObjectIdentifiers.id_dsa);
        dsaOids.add(X9ObjectIdentifiers.id_dsa_with_sha1);
        dsaOids.add(OIWObjectIdentifiers.dsaWithSHA1);
    }
}

