/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.cms;

import java.util.ArrayList;
import java.util.List;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.OriginatorInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cert.X509CertificateHolder;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSUtils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.OriginatorInformation;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Store;

public class OriginatorInfoGenerator {
    private final List origCerts;
    private final List origCRLs;

    public OriginatorInfoGenerator(X509CertificateHolder origCert) {
        this.origCerts = new ArrayList(1);
        this.origCRLs = null;
        this.origCerts.add(origCert.toASN1Structure());
    }

    public OriginatorInfoGenerator(Store origCerts) throws CMSException {
        this(origCerts, null);
    }

    public OriginatorInfoGenerator(Store origCerts, Store origCRLs) throws CMSException {
        this.origCerts = CMSUtils.getCertificatesFromStore(origCerts);
        this.origCRLs = origCRLs != null ? CMSUtils.getCRLsFromStore(origCRLs) : null;
    }

    public OriginatorInformation generate() {
        if (this.origCRLs != null) {
            return new OriginatorInformation(new OriginatorInfo(CMSUtils.createDerSetFromList(this.origCerts), CMSUtils.createDerSetFromList(this.origCRLs)));
        }
        return new OriginatorInformation(new OriginatorInfo(CMSUtils.createDerSetFromList(this.origCerts), null));
    }
}

