/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BitMixer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixing;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.IntByteHashMap;

public class IntByteScatterMap
extends IntByteHashMap {
    public IntByteScatterMap() {
        this(4);
    }

    public IntByteScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntByteScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(int key) {
        return BitMixer.mixPhi(key);
    }

    public static IntByteScatterMap from(int[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntByteScatterMap map = new IntByteScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

