/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractFloatCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractIterator;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BitMixer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BufferAllocationException;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.FloatBufferVisualizer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.FloatContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.FloatLookupContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.FloatSet;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashContainers;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixing;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixingStrategy;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.Preallocable;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.FloatCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.FloatPredicate;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.procedures.FloatProcedure;

public class FloatHashSet
extends AbstractFloatCollection
implements FloatLookupContainer,
FloatSet,
Preallocable,
Cloneable {
    public float[] keys;
    protected int assigned;
    protected int mask;
    protected int keyMixer;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public FloatHashSet() {
        this(4, 0.75);
    }

    public FloatHashSet(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public FloatHashSet(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public FloatHashSet(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public FloatHashSet(FloatContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public boolean add(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            assert (Float.floatToIntBits(this.keys[this.mask + 1]) == 0);
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        float[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(existing) == Float.floatToIntBits(key)) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        ++this.assigned;
        return true;
    }

    public final int addAll(float ... elements) {
        this.ensureCapacity(elements.length);
        int count = 0;
        for (float e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public int addAll(FloatContainer container) {
        this.ensureCapacity(container.size());
        return this.addAll((Iterable<? extends FloatCursor>)container);
    }

    public int addAll(Iterable<? extends FloatCursor> iterable) {
        int count = 0;
        for (FloatCursor floatCursor : iterable) {
            if (!this.add(floatCursor.value)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public float[] toArray() {
        float[] cloned = new float[this.size()];
        int j = 0;
        if (this.hasEmptyKey) {
            cloned[j++] = 0.0f;
        }
        float[] keys = this.keys;
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            float existing = keys[slot];
            if (Float.floatToIntBits(existing) == 0) continue;
            cloned[j++] = existing;
        }
        return cloned;
    }

    public boolean remove(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            boolean hadEmptyKey = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return hadEmptyKey;
        }
        float[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(existing) == Float.floatToIntBits(key)) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int removeAll(float key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public int removeAll(FloatPredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(0.0f)) {
            this.hasEmptyKey = false;
        }
        float[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            float existing = keys[slot];
            if (Float.floatToIntBits(existing) != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public boolean contains(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            return this.hasEmptyKey;
        }
        float[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(existing) == Float.floatToIntBits(key)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0.0f);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            float[] prevKeys = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys);
            }
        }
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        float[] keys = this.keys;
        for (int slot = this.mask; slot >= 0; --slot) {
            float existing = keys[slot];
            if (Float.floatToIntBits(existing) == 0) continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.sameKeys((FloatSet)this.getClass().cast(obj));
    }

    private boolean sameKeys(FloatSet other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (FloatCursor c : other) {
            if (this.contains(c.value)) continue;
            return false;
        }
        return true;
    }

    public FloatHashSet clone() {
        try {
            FloatHashSet cloned = (FloatHashSet)super.clone();
            cloned.keys = (float[])this.keys.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<FloatCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends FloatProcedure> T forEach(T procedure) {
        if (this.hasEmptyKey) {
            procedure.apply(0.0f);
        }
        float[] keys = this.keys;
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            float existing = keys[slot];
            if (Float.floatToIntBits(existing) == 0) continue;
            procedure.apply(existing);
        }
        return procedure;
    }

    @Override
    public <T extends FloatPredicate> T forEach(T predicate) {
        float existing;
        if (this.hasEmptyKey && !predicate.apply(0.0f)) {
            return predicate;
        }
        float[] keys = this.keys;
        int max = this.mask;
        for (int slot = 0; slot <= max && (Float.floatToIntBits(existing = keys[slot]) == 0 || predicate.apply(existing)); ++slot) {
        }
        return predicate;
    }

    public static FloatHashSet from(float ... elements) {
        FloatHashSet set = new FloatHashSet(elements.length);
        set.addAll(elements);
        return set;
    }

    protected int hashKey(float key) {
        assert (Float.floatToIntBits(key) != 0);
        return BitMixer.mix(key, this.keyMixer);
    }

    public int indexOf(float key) {
        float existing;
        int mask = this.mask;
        if (Float.floatToIntBits(key) == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        float[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(existing) == Float.floatToIntBits(key)) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    public float indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.keys[index];
    }

    public float indexReplace(int index, float equivalentKey) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        assert (Float.floatToIntBits(equivalentKey) == Float.floatToIntBits(this.keys[index]));
        float previousValue = this.keys[index];
        this.keys[index] = equivalentKey;
        return previousValue;
    }

    public void indexInsert(int index, float key) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (Float.floatToIntBits(key) == 0) {
            assert (index == this.mask + 1);
            assert (Float.floatToIntBits(this.keys[index]) == 0);
            this.hasEmptyKey = true;
        } else {
            assert (Float.floatToIntBits(this.keys[index]) == 0);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key);
            } else {
                this.keys[index] = key;
            }
            ++this.assigned;
        }
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return FloatBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(float[] fromKeys) {
        assert (HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        float[] keys = this.keys;
        int mask = this.mask;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            float existing = fromKeys[i];
            if (Float.floatToIntBits(existing) == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (Float.floatToIntBits(keys[slot]) != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        float[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new float[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.keys == null ? 0 : this.size(), arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, float pendingKey) {
        assert (this.assigned == this.resizeAt && Float.floatToIntBits(this.keys[slot]) == 0 && Float.floatToIntBits(pendingKey) != 0);
        float[] prevKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        float existing;
        float[] keys = this.keys;
        int mask = this.mask;
        int distance = 0;
        while (Float.floatToIntBits(existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0.0f;
        --this.assigned;
    }

    protected final class EntryIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = FloatHashSet.this.mask + 1;
            this.slot = -1;
            this.cursor = new FloatCursor();
        }

        @Override
        protected FloatCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    float existing = FloatHashSet.this.keys[this.slot];
                    if (Float.floatToIntBits(existing) != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && FloatHashSet.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0.0f;
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }
}

