/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractByteCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractFloatCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractIterator;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BitMixer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BufferAllocationException;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.ByteCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.FloatBufferVisualizer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.FloatByteAssociativeContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.FloatByteMap;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.FloatContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.FloatLookupContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashContainers;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixing;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixingStrategy;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.Preallocable;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.ByteCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.FloatByteCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.FloatCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.BytePredicate;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.FloatBytePredicate;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.FloatPredicate;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.procedures.ByteProcedure;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.procedures.FloatByteProcedure;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.procedures.FloatProcedure;

public class FloatByteHashMap
implements FloatByteMap,
Preallocable,
Cloneable {
    public float[] keys;
    public byte[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public FloatByteHashMap() {
        this(4);
    }

    public FloatByteHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public FloatByteHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public FloatByteHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public FloatByteHashMap(FloatByteAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public byte put(float key, byte value) {
        float existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (Float.floatToIntBits(key) == 0) {
            this.hasEmptyKey = true;
            byte previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        float[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(existing) == Float.floatToIntBits(key)) {
                byte previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(FloatByteAssociativeContainer container) {
        int count = this.size();
        for (FloatByteCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends FloatByteCursor> iterable) {
        int count = this.size();
        for (FloatByteCursor floatByteCursor : iterable) {
            this.put(floatByteCursor.key, floatByteCursor.value);
        }
        return this.size() - count;
    }

    public boolean putIfAbsent(float key, byte value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public byte putOrAdd(float key, byte putValue, byte incrementValue) {
        assert (this.assigned < this.mask + 1);
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue = (byte)(putValue + incrementValue);
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public byte addTo(float key, byte incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    @Override
    public byte remove(float key) {
        float existing;
        int mask = this.mask;
        if (Float.floatToIntBits(key) == 0) {
            this.hasEmptyKey = false;
            byte previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0;
            return previousValue;
        }
        float[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(existing) == Float.floatToIntBits(key)) {
                byte previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public int removeAll(FloatContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof FloatLookupContainer) {
            if (this.hasEmptyKey && other.contains(0.0f)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            float[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                float existing = keys[slot];
                if (Float.floatToIntBits(existing) != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (FloatCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(FloatBytePredicate predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply(0.0f, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0;
        }
        float[] keys = this.keys;
        byte[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            float existing = keys[slot];
            if (Float.floatToIntBits(existing) != 0 && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(FloatPredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(0.0f)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        float[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            float existing = keys[slot];
            if (Float.floatToIntBits(existing) != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public byte get(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : (byte)0;
        }
        float[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(existing) == Float.floatToIntBits(key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public byte getOrDefault(float key, byte defaultValue) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        float[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(existing) == Float.floatToIntBits(key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(float key) {
        float existing;
        if (Float.floatToIntBits(key) == 0) {
            return this.hasEmptyKey;
        }
        float[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(existing) == Float.floatToIntBits(key)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(float key) {
        float existing;
        int mask = this.mask;
        if (Float.floatToIntBits(key) == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        float[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while (Float.floatToIntBits(existing = keys[slot]) != 0) {
            if (Float.floatToIntBits(existing) == Float.floatToIntBits(key)) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public byte indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public byte indexReplace(int index, byte newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        byte previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, float key, byte value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (Float.floatToIntBits(key) == 0) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (Float.floatToIntBits(this.keys[index]) == 0);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0.0f);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (FloatByteCursor c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((FloatByteHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(FloatByteHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (FloatByteCursor c : other) {
            float key = c.key;
            if (this.containsKey(key) && this.get(key) == c.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            float[] prevKeys = this.keys;
            byte[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<FloatByteCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends FloatByteProcedure> T forEach(T procedure) {
        float[] keys = this.keys;
        byte[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply(0.0f, values[this.mask + 1]);
        }
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            if (Float.floatToIntBits(keys[slot]) == 0) continue;
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends FloatBytePredicate> T forEach(T predicate) {
        float[] keys = this.keys;
        byte[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply(0.0f, values[this.mask + 1])) {
            return predicate;
        }
        int max = this.mask;
        for (int slot = 0; slot <= max && (Float.floatToIntBits(keys[slot]) == 0 || predicate.apply(keys[slot], values[slot])); ++slot) {
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ByteCollection values() {
        return new ValuesContainer();
    }

    public FloatByteHashMap clone() {
        try {
            FloatByteHashMap cloned = (FloatByteHashMap)super.clone();
            cloned.keys = (float[])this.keys.clone();
            cloned.values = (byte[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (FloatByteCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return FloatBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static FloatByteHashMap from(float[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        FloatByteHashMap map = new FloatByteHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(float key) {
        assert (Float.floatToIntBits(key) != 0);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(float[] fromKeys, byte[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        float[] keys = this.keys;
        byte[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            float existing = fromKeys[from];
            if (Float.floatToIntBits(existing) == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (Float.floatToIntBits(keys[slot]) != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        float[] prevKeys = this.keys;
        byte[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new float[arraySize + emptyElementSlot];
            this.values = new byte[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, float pendingKey, byte pendingValue) {
        assert (this.assigned == this.resizeAt && Float.floatToIntBits(this.keys[slot]) == 0 && Float.floatToIntBits(pendingKey) != 0);
        float[] prevKeys = this.keys;
        byte[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        float existing;
        float[] keys = this.keys;
        byte[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while (Float.floatToIntBits(existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0.0f;
        values[gapSlot] = 0;
        --this.assigned;
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = FloatByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ByteCursor();
        }

        @Override
        protected ByteCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (Float.floatToIntBits(FloatByteHashMap.this.keys[this.slot]) != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = FloatByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && FloatByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = FloatByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private final FloatByteHashMap owner;

        private ValuesContainer() {
            this.owner = FloatByteHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(byte value) {
            for (FloatByteCursor c : this.owner) {
                if (c.value != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            for (FloatByteCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            for (FloatByteCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final byte e) {
            return this.owner.removeAll(new FloatBytePredicate(){

                @Override
                public boolean apply(float key, byte value) {
                    return value == e;
                }
            });
        }

        @Override
        public int removeAll(final BytePredicate predicate) {
            return this.owner.removeAll(new FloatBytePredicate(){

                @Override
                public boolean apply(float key, byte value) {
                    return predicate.apply(value);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = FloatByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new FloatCursor();
        }

        @Override
        protected FloatCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    float existing = FloatByteHashMap.this.keys[this.slot];
                    if (Float.floatToIntBits(existing) != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && FloatByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0.0f;
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractFloatCollection
    implements FloatLookupContainer {
        private final FloatByteHashMap owner;

        public KeysContainer() {
            this.owner = FloatByteHashMap.this;
        }

        @Override
        public boolean contains(float e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends FloatProcedure> T forEach(final T procedure) {
            this.owner.forEach(new FloatByteProcedure(){

                @Override
                public void apply(float key, byte value) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(final T predicate) {
            this.owner.forEach(new FloatBytePredicate(){

                @Override
                public boolean apply(float key, byte value) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(float e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<FloatByteCursor> {
        private final FloatByteCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = FloatByteHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new FloatByteCursor();
        }

        @Override
        protected FloatByteCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    float existing = FloatByteHashMap.this.keys[this.slot];
                    if (Float.floatToIntBits(existing) != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = FloatByteHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && FloatByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0.0f;
                this.cursor.value = FloatByteHashMap.this.values[this.max];
                return this.cursor;
            }
            return (FloatByteCursor)this.done();
        }
    }
}

