/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractByteCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractIterator;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.AbstractShortCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BitMixer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BufferAllocationException;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.ByteBufferVisualizer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.ByteContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.ByteLookupContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.ByteShortAssociativeContainer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.ByteShortMap;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashContainers;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixing;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixingStrategy;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.Preallocable;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.ShortCollection;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.ByteCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.ByteShortCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.cursors.ShortCursor;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.BytePredicate;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.ByteShortPredicate;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.predicates.ShortPredicate;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.procedures.ByteProcedure;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.procedures.ByteShortProcedure;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.procedures.ShortProcedure;

public class ByteShortHashMap
implements ByteShortMap,
Preallocable,
Cloneable {
    public byte[] keys;
    public short[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public ByteShortHashMap() {
        this(4);
    }

    public ByteShortHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ByteShortHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public ByteShortHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ByteShortHashMap(ByteShortAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public short put(byte key, short value) {
        byte existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == 0) {
            this.hasEmptyKey = true;
            short previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        byte[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                short previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(ByteShortAssociativeContainer container) {
        int count = this.size();
        for (ByteShortCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends ByteShortCursor> iterable) {
        int count = this.size();
        for (ByteShortCursor byteShortCursor : iterable) {
            this.put(byteShortCursor.key, byteShortCursor.value);
        }
        return this.size() - count;
    }

    public boolean putIfAbsent(byte key, short value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public short putOrAdd(byte key, short putValue, short incrementValue) {
        assert (this.assigned < this.mask + 1);
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue = (short)(putValue + incrementValue);
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public short addTo(byte key, short incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    @Override
    public short remove(byte key) {
        byte existing;
        int mask = this.mask;
        if (key == 0) {
            this.hasEmptyKey = false;
            short previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0;
            return previousValue;
        }
        byte[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                short previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public int removeAll(ByteContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof ByteLookupContainer) {
            if (this.hasEmptyKey && other.contains((byte)0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            byte[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                byte existing = keys[slot];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (ByteCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ByteShortPredicate predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply((byte)0, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0;
        }
        byte[] keys = this.keys;
        short[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            byte existing = keys[slot];
            if (existing != 0 && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(BytePredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply((byte)0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        byte[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            byte existing = keys[slot];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public short get(byte key) {
        byte existing;
        if (key == 0) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : (short)0;
        }
        byte[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public short getOrDefault(byte key, short defaultValue) {
        byte existing;
        if (key == 0) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        byte[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(byte key) {
        byte existing;
        if (key == 0) {
            return this.hasEmptyKey;
        }
        byte[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(byte key) {
        byte existing;
        int mask = this.mask;
        if (key == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        byte[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public short indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public short indexReplace(int index, short newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        short previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, byte key, short value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == 0) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == 0);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (byte)0);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (ByteShortCursor c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((ByteShortHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(ByteShortHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (ByteShortCursor c : other) {
            byte key = c.key;
            if (this.containsKey(key) && this.get(key) == c.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            byte[] prevKeys = this.keys;
            short[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<ByteShortCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ByteShortProcedure> T forEach(T procedure) {
        byte[] keys = this.keys;
        short[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply((byte)0, values[this.mask + 1]);
        }
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            if (keys[slot] == 0) continue;
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ByteShortPredicate> T forEach(T predicate) {
        byte[] keys = this.keys;
        short[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply((byte)0, values[this.mask + 1])) {
            return predicate;
        }
        int max = this.mask;
        for (int slot = 0; slot <= max && (keys[slot] == 0 || predicate.apply(keys[slot], values[slot])); ++slot) {
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ShortCollection values() {
        return new ValuesContainer();
    }

    public ByteShortHashMap clone() {
        try {
            ByteShortHashMap cloned = (ByteShortHashMap)super.clone();
            cloned.keys = (byte[])this.keys.clone();
            cloned.values = (short[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ByteShortCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return ByteBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static ByteShortHashMap from(byte[] keys, short[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ByteShortHashMap map = new ByteShortHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(byte key) {
        assert (key != 0);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(byte[] fromKeys, short[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        byte[] keys = this.keys;
        short[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            byte existing = fromKeys[from];
            if (existing == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        byte[] prevKeys = this.keys;
        short[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new byte[arraySize + emptyElementSlot];
            this.values = new short[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, byte pendingKey, short pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0 && pendingKey != 0);
        byte[] prevKeys = this.keys;
        short[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        byte existing;
        byte[] keys = this.keys;
        short[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        values[gapSlot] = 0;
        --this.assigned;
    }

    private final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ByteShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (ByteShortHashMap.this.keys[this.slot] != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = ByteShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ByteShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ByteShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractShortCollection {
        private final ByteShortHashMap owner;

        private ValuesContainer() {
            this.owner = ByteShortHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(short value) {
            for (ByteShortCursor c : this.owner) {
                if (c.value != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            for (ByteShortCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            for (ByteShortCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final short e) {
            return this.owner.removeAll(new ByteShortPredicate(){

                @Override
                public boolean apply(byte key, short value) {
                    return value == e;
                }
            });
        }

        @Override
        public int removeAll(final ShortPredicate predicate) {
            return this.owner.removeAll(new ByteShortPredicate(){

                @Override
                public boolean apply(byte key, short value) {
                    return predicate.apply(value);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ByteShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ByteCursor();
        }

        @Override
        protected ByteCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    byte existing = ByteShortHashMap.this.keys[this.slot];
                    if (existing != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ByteShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractByteCollection
    implements ByteLookupContainer {
        private final ByteShortHashMap owner;

        public KeysContainer() {
            this.owner = ByteShortHashMap.this;
        }

        @Override
        public boolean contains(byte e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ByteProcedure> T forEach(final T procedure) {
            this.owner.forEach(new ByteShortProcedure(){

                @Override
                public void apply(byte key, short value) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(final T predicate) {
            this.owner.forEach(new ByteShortPredicate(){

                @Override
                public boolean apply(byte key, short value) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(byte e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<ByteShortCursor> {
        private final ByteShortCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ByteShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ByteShortCursor();
        }

        @Override
        protected ByteShortCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    byte existing = ByteShortHashMap.this.keys[this.slot];
                    if (existing != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = ByteShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ByteShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0;
                this.cursor.value = ByteShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ByteShortCursor)this.done();
        }
    }
}

