/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BitMixer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.ByteCharHashMap;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixing;

public class ByteCharScatterMap
extends ByteCharHashMap {
    public ByteCharScatterMap() {
        this(4);
    }

    public ByteCharScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ByteCharScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(byte key) {
        return BitMixer.mixPhi(key);
    }

    public static ByteCharScatterMap from(byte[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ByteCharScatterMap map = new ByteCharScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

