/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.util;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BoundsChecking;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;
import net.snowflake.client.jdbc.internal.io.netty.util.internal.PlatformDependent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteFunctionHelpers {
    static final Logger logger = LoggerFactory.getLogger(ByteFunctionHelpers.class);

    public static final int equal(ArrowBuf left, int lStart, int lEnd, ArrowBuf right, int rStart, int rEnd) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            left.checkBytes(lStart, lEnd);
            right.checkBytes(rStart, rEnd);
        }
        return ByteFunctionHelpers.memEqual(left.memoryAddress(), lStart, lEnd, right.memoryAddress(), rStart, rEnd);
    }

    private static final int memEqual(long laddr, int lStart, int lEnd, long raddr, int rStart, int rEnd) {
        int n = lEnd - lStart;
        if (n == rEnd - rStart) {
            long lPos = laddr + (long)lStart;
            long rPos = raddr + (long)rStart;
            while (n > 7) {
                long rightLong;
                long leftLong = PlatformDependent.getLong(lPos);
                if (leftLong != (rightLong = PlatformDependent.getLong(rPos))) {
                    return 0;
                }
                lPos += 8L;
                rPos += 8L;
                n -= 8;
            }
            while (n-- != 0) {
                byte rightByte;
                byte leftByte = PlatformDependent.getByte(lPos);
                if (leftByte != (rightByte = PlatformDependent.getByte(rPos))) {
                    return 0;
                }
                ++lPos;
                ++rPos;
            }
            return 1;
        }
        return 0;
    }

    public static final int compare(ArrowBuf left, int lStart, int lEnd, ArrowBuf right, int rStart, int rEnd) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            left.checkBytes(lStart, lEnd);
            right.checkBytes(rStart, rEnd);
        }
        return ByteFunctionHelpers.memcmp(left.memoryAddress(), lStart, lEnd, right.memoryAddress(), rStart, rEnd);
    }

    private static final int memcmp(long laddr, int lStart, int lEnd, long raddr, int rStart, int rEnd) {
        int n;
        int lLen = lEnd - lStart;
        int rLen = rEnd - rStart;
        long lPos = laddr + (long)lStart;
        long rPos = raddr + (long)rStart;
        for (n = Math.min(rLen, lLen); n > 7; n -= 8) {
            long rightLong;
            long leftLong = PlatformDependent.getLong(lPos);
            if (leftLong != (rightLong = PlatformDependent.getLong(rPos))) {
                return ByteFunctionHelpers.unsignedLongCompare(Long.reverseBytes(leftLong), Long.reverseBytes(rightLong));
            }
            lPos += 8L;
            rPos += 8L;
        }
        while (n-- != 0) {
            byte rightByte;
            byte leftByte = PlatformDependent.getByte(lPos);
            if (leftByte != (rightByte = PlatformDependent.getByte(rPos))) {
                return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
            }
            ++lPos;
            ++rPos;
        }
        if (lLen == rLen) {
            return 0;
        }
        return lLen > rLen ? 1 : -1;
    }

    public static final int compare(ArrowBuf left, int lStart, int lEnd, byte[] right, int rStart, int rEnd) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            left.checkBytes(lStart, lEnd);
        }
        return ByteFunctionHelpers.memcmp(left.memoryAddress(), lStart, lEnd, right, rStart, rEnd);
    }

    public static int unsignedLongCompare(long a, long b) {
        return Long.compare(a ^ Long.MIN_VALUE, b ^ Long.MIN_VALUE);
    }

    private static final int memcmp(long laddr, int lStart, int lEnd, byte[] right, int rStart, int rEnd) {
        int lLen = lEnd - lStart;
        int rLen = rEnd - rStart;
        int n = Math.min(rLen, lLen);
        long lPos = laddr + (long)lStart;
        int rPos = rStart;
        while (n-- != 0) {
            byte rightByte;
            byte leftByte = PlatformDependent.getByte(lPos);
            if (leftByte != (rightByte = right[rPos])) {
                return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
            }
            ++lPos;
            ++rPos;
        }
        if (lLen == rLen) {
            return 0;
        }
        return lLen > rLen ? 1 : -1;
    }
}

