/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.KeyValue;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Collections2;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.JsonCreator;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.JsonInclude;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.annotation.JsonProperty;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectReader;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectWriter;
import net.snowflake.client.jdbc.internal.google.flatbuffers.FlatBufferBuilder;

public class Schema {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
    private static final ObjectReader reader = mapper.readerFor(Schema.class);
    private final List<Field> fields;
    private final Map<String, String> metadata;

    public static Field findField(List<Field> fields, String name) {
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw new IllegalArgumentException(String.format("field %s not found in %s", name, fields));
    }

    public static Schema fromJSON(String json) throws IOException {
        return (Schema)reader.readValue(Preconditions.checkNotNull(json));
    }

    public static Schema deserialize(ByteBuffer buffer) {
        return Schema.convertSchema(net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Schema.getRootAsSchema(buffer));
    }

    public static Schema convertSchema(net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Schema schema) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (int i = 0; i < schema.fieldsLength(); ++i) {
            fields.add(Field.convertField(schema.fields(i)));
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (int i = 0; i < schema.customMetadataLength(); ++i) {
            KeyValue kv = schema.customMetadata(i);
            String key = kv.key();
            String value = kv.value();
            metadata.put(key == null ? "" : key, value == null ? "" : value);
        }
        return new Schema(Collections2.immutableListCopy(fields), Collections2.immutableMapCopy(metadata));
    }

    public Schema(Iterable<Field> fields) {
        this(fields, null);
    }

    @JsonCreator
    public Schema(@JsonProperty(value="fields") Iterable<Field> fields, @JsonProperty(value="metadata") Map<String, String> metadata) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Field field : fields) {
            fieldList.add(field);
        }
        this.fields = Collections2.immutableListCopy(fieldList);
        this.metadata = metadata == null ? Collections.emptyMap() : Collections2.immutableMapCopy(metadata);
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getCustomMetadata() {
        return this.metadata;
    }

    public Field findField(String name) {
        return Schema.findField(this.getFields(), name);
    }

    public String toJson() {
        try {
            return writer.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public int getSchema(FlatBufferBuilder builder) {
        int[] fieldOffsets = new int[this.fields.size()];
        for (int i = 0; i < this.fields.size(); ++i) {
            fieldOffsets[i] = this.fields.get(i).getField(builder);
        }
        int fieldsOffset = net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Schema.createFieldsVector(builder, fieldOffsets);
        int[] metadataOffsets = new int[this.metadata.size()];
        Iterator<Map.Entry<String, String>> metadataIterator = this.metadata.entrySet().iterator();
        for (int i = 0; i < metadataOffsets.length; ++i) {
            Map.Entry<String, String> kv = metadataIterator.next();
            int keyOffset = builder.createString(kv.getKey());
            int valueOffset = builder.createString(kv.getValue());
            KeyValue.startKeyValue(builder);
            KeyValue.addKey(builder, keyOffset);
            KeyValue.addValue(builder, valueOffset);
            metadataOffsets[i] = KeyValue.endKeyValue(builder);
        }
        int metadataOffset = net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Field.createCustomMetadataVector(builder, metadataOffsets);
        net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Schema.startSchema(builder);
        net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Schema.addFields(builder, fieldsOffset);
        net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Schema.addCustomMetadata(builder, metadataOffset);
        return net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.Schema.endSchema(builder);
    }

    public byte[] toByteArray() {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        int schemaOffset = this.getSchema(builder);
        builder.finish(schemaOffset);
        ByteBuffer bb = builder.dataBuffer();
        byte[] bytes = new byte[bb.remaining()];
        bb.get(bytes);
        return bytes;
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.metadata);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Schema)) {
            return false;
        }
        return Objects.equals(this.fields, ((Schema)obj).fields) && Objects.equals(this.metadata, ((Schema)obj).metadata);
    }

    public String toString() {
        String meta = this.metadata.isEmpty() ? "" : "(metadata: " + this.metadata.toString() + ")";
        return "Schema<" + this.fields.stream().map(t -> t.toString()).collect(Collectors.joining(", ")) + ">" + meta;
    }
}

