/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message;

import net.snowflake.client.jdbc.internal.apache.arrow.flatbuf.DictionaryBatch;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowMessage;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import net.snowflake.client.jdbc.internal.google.flatbuffers.FlatBufferBuilder;

public class ArrowDictionaryBatch
implements ArrowMessage {
    private final long dictionaryId;
    private final ArrowRecordBatch dictionary;

    public ArrowDictionaryBatch(long dictionaryId, ArrowRecordBatch dictionary) {
        this.dictionaryId = dictionaryId;
        this.dictionary = dictionary;
    }

    public long getDictionaryId() {
        return this.dictionaryId;
    }

    public ArrowRecordBatch getDictionary() {
        return this.dictionary;
    }

    @Override
    public int writeTo(FlatBufferBuilder builder) {
        int dataOffset = this.dictionary.writeTo(builder);
        DictionaryBatch.startDictionaryBatch(builder);
        DictionaryBatch.addId(builder, this.dictionaryId);
        DictionaryBatch.addData(builder, dataOffset);
        return DictionaryBatch.endDictionaryBatch(builder);
    }

    @Override
    public int computeBodyLength() {
        return this.dictionary.computeBodyLength();
    }

    @Override
    public <T> T accepts(ArrowMessage.ArrowMessageVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        return "ArrowDictionaryBatch [dictionaryId=" + this.dictionaryId + ", dictionary=" + this.dictionary + "]";
    }

    @Override
    public void close() {
        this.dictionary.close();
    }
}

