/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.ArrowReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.ReadChannel;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowDictionaryBatch;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.MessageChannelReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.MessageResult;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.MessageSerializer;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Schema;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class ArrowStreamReader
extends ArrowReader {
    private MessageChannelReader messageReader;

    public ArrowStreamReader(MessageChannelReader messageReader, BufferAllocator allocator) {
        super(allocator);
        this.messageReader = messageReader;
    }

    public ArrowStreamReader(ReadableByteChannel in, BufferAllocator allocator) {
        this(new MessageChannelReader(new ReadChannel(in), allocator), allocator);
    }

    public ArrowStreamReader(InputStream in, BufferAllocator allocator) {
        this(Channels.newChannel(in), allocator);
    }

    @Override
    public long bytesRead() {
        return this.messageReader.bytesRead();
    }

    @Override
    protected void closeReadSource() throws IOException {
        this.messageReader.close();
    }

    @Override
    public boolean loadNextBatch() throws IOException {
        this.prepareLoadNextBatch();
        MessageResult result = this.messageReader.readNext();
        if (result == null) {
            return false;
        }
        if (result.getMessage().headerType() != 3) {
            throw new IOException("Expected RecordBatch but header was " + result.getMessage().headerType());
        }
        ArrowBuf bodyBuffer = result.getBodyBuffer();
        if (bodyBuffer == null) {
            bodyBuffer = this.allocator.getEmpty();
        }
        ArrowRecordBatch batch = MessageSerializer.deserializeRecordBatch(result.getMessage(), bodyBuffer);
        this.loadRecordBatch(batch);
        return true;
    }

    @Override
    protected Schema readSchema() throws IOException {
        MessageResult result = this.messageReader.readNext();
        if (result == null) {
            throw new IOException("Unexpected end of input. Missing schema.");
        }
        if (result.getMessage().headerType() != 1) {
            throw new IOException("Expected schema but header was " + result.getMessage().headerType());
        }
        return MessageSerializer.deserializeSchema(result.getMessage());
    }

    @Override
    protected ArrowDictionaryBatch readDictionary() throws IOException {
        MessageResult result = this.messageReader.readNext();
        if (result == null) {
            throw new IOException("Unexpected end of input. Expected DictionaryBatch");
        }
        if (result.getMessage().headerType() != 2) {
            throw new IOException("Expected DictionaryBatch but header was " + result.getMessage().headerType());
        }
        ArrowBuf bodyBuffer = result.getBodyBuffer();
        if (bodyBuffer == null) {
            bodyBuffer = this.allocator.getEmpty();
        }
        return MessageSerializer.deserializeDictionaryBatch(result.getMessage(), bodyBuffer);
    }
}

