/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BaseAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.OutOfMemoryException;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.AddOrGetResult;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BufferBacked;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ZeroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.PromotableVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.UnionVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UnionFixedSizeListReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowFieldNode;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.DictionaryEncoding;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.CallBack;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.JsonStringArrayList;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.OversizedAllocationException;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.SchemaChangeRuntimeException;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class FixedSizeListVector
extends BaseValueVector
implements FieldVector,
PromotableVector {
    private FieldVector vector;
    private ArrowBuf validityBuffer;
    private final int listSize;
    private final FieldType fieldType;
    private UnionFixedSizeListReader reader;
    private int valueCount;
    private int validityAllocationSizeInBytes;

    public static FixedSizeListVector empty(String name, int size, BufferAllocator allocator) {
        FieldType fieldType = FieldType.nullable(new ArrowType.FixedSizeList(size));
        return new FixedSizeListVector(name, allocator, fieldType, null);
    }

    @Deprecated
    public FixedSizeListVector(String name, BufferAllocator allocator, int listSize, DictionaryEncoding dictionary, CallBack schemaChangeCallback) {
        this(name, allocator, new FieldType(true, new ArrowType.FixedSizeList(listSize), dictionary), schemaChangeCallback);
    }

    public FixedSizeListVector(String name, BufferAllocator allocator, FieldType fieldType, CallBack schemaChangeCallback) {
        super(name, allocator);
        this.validityBuffer = allocator.getEmpty();
        this.vector = ZeroVector.INSTANCE;
        this.fieldType = fieldType;
        this.listSize = ((ArrowType.FixedSizeList)fieldType.getType()).getListSize();
        Preconditions.checkArgument(this.listSize > 0, "list size must be positive");
        this.reader = new UnionFixedSizeListReader(this);
        this.valueCount = 0;
        this.validityAllocationSizeInBytes = FixedSizeListVector.getValidityBufferSizeFromCount(3970);
    }

    @Override
    public Field getField() {
        List<Field> children = Collections.singletonList(this.getDataVector().getField());
        return new Field(this.name, this.fieldType, children);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.FIXED_SIZE_LIST;
    }

    public int getListSize() {
        return this.listSize;
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        if (children.size() != 1) {
            throw new IllegalArgumentException("Lists have only one child. Found: " + children);
        }
        Field field = children.get(0);
        AddOrGetResult addOrGetVector = this.addOrGetVector(field.getFieldType());
        if (!addOrGetVector.isCreated()) {
            throw new IllegalArgumentException("Child vector already existed: " + addOrGetVector.getVector());
        }
        ((FieldVector)addOrGetVector.getVector()).initializeChildrenFromFields(field.getChildren());
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return Collections.singletonList(this.vector);
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        if (ownBuffers.size() != 1) {
            throw new IllegalArgumentException("Illegal buffer count, expected 1, got: " + ownBuffers.size());
        }
        ArrowBuf bitBuffer = ownBuffers.get(0);
        this.validityBuffer.release();
        this.validityBuffer = BitVectorHelper.loadValidityBuffer(fieldNode, bitBuffer, this.allocator);
        this.valueCount = fieldNode.getLength();
        this.validityAllocationSizeInBytes = this.validityBuffer.capacity();
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        ArrayList<ArrowBuf> result = new ArrayList<ArrowBuf>(1);
        this.setReaderAndWriterIndex();
        result.add(this.validityBuffer);
        return result;
    }

    private void setReaderAndWriterIndex() {
        this.validityBuffer.readerIndex(0);
        this.validityBuffer.writerIndex(FixedSizeListVector.getValidityBufferSizeFromCount(this.valueCount));
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use getFieldBuffers");
    }

    @Override
    public UnionFixedSizeListReader getReader() {
        return this.reader;
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating memory");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            this.clear();
            this.allocateValidityBuffer(this.validityAllocationSizeInBytes);
            success = this.vector.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
                return false;
            }
        }
        return true;
    }

    private void allocateValidityBuffer(long size) {
        int curSize = (int)size;
        this.validityBuffer = this.allocator.buffer(curSize);
        this.validityBuffer.readerIndex(0);
        this.validityAllocationSizeInBytes = curSize;
        this.validityBuffer.setZero(0, this.validityBuffer.capacity());
    }

    @Override
    public void reAlloc() {
        this.reallocValidityBuffer();
        this.vector.reAlloc();
    }

    private void reallocValidityBuffer() {
        long baseSize = this.validityAllocationSizeInBytes;
        int currentBufferCapacity = this.validityBuffer.capacity();
        if (baseSize < (long)currentBufferCapacity) {
            baseSize = currentBufferCapacity;
        }
        long newAllocationSize = baseSize * 2L;
        newAllocationSize = BaseAllocator.nextPowerOfTwo(newAllocationSize);
        assert (newAllocationSize >= 1L);
        if (newAllocationSize > (long)MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Unable to expand the buffer");
        }
        ArrowBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, this.validityBuffer, 0, currentBufferCapacity);
        newBuf.setZero(currentBufferCapacity, newBuf.capacity() - currentBufferCapacity);
        this.validityBuffer.release(1);
        this.validityBuffer = newBuf;
        this.validityAllocationSizeInBytes = (int)newAllocationSize;
    }

    public FieldVector getDataVector() {
        return this.vector;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.validityAllocationSizeInBytes = FixedSizeListVector.getValidityBufferSizeFromCount(numRecords);
        this.vector.setInitialCapacity(numRecords * this.listSize);
    }

    @Override
    public int getValueCapacity() {
        if (this.vector == ZeroVector.INSTANCE) {
            return 0;
        }
        return Math.min(this.vector.getValueCapacity() / this.listSize, this.getValidityBufferValueCapacity());
    }

    @Override
    public int getBufferSize() {
        if (this.getValueCount() == 0) {
            return 0;
        }
        return FixedSizeListVector.getValidityBufferSizeFromCount(this.valueCount) + this.vector.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return FixedSizeListVector.getValidityBufferSizeFromCount(valueCount) + this.vector.getBufferSizeFor(valueCount * this.listSize);
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.singleton(this.vector).iterator();
    }

    @Override
    public void clear() {
        this.validityBuffer = this.releaseBuffer(this.validityBuffer);
        this.vector.clear();
        this.valueCount = 0;
        super.clear();
    }

    @Override
    public void reset() {
        this.validityBuffer.setZero(0, this.validityBuffer.capacity());
        this.vector.reset();
        this.valueCount = 0;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        ArrowBuf[] buffers;
        this.setReaderAndWriterIndex();
        if (this.getBufferSize() == 0) {
            buffers = new ArrowBuf[]{};
        } else {
            ArrayList<ArrowBuf> list = new ArrayList<ArrowBuf>();
            list.add(this.validityBuffer);
            list.addAll(Arrays.asList(this.vector.getBuffers(false)));
            buffers = list.toArray(new ArrowBuf[list.size()]);
        }
        if (clear) {
            for (ArrowBuf buffer : buffers) {
                buffer.retain();
            }
            this.clear();
        }
        return buffers;
    }

    public int size() {
        return this.vector == ZeroVector.INSTANCE ? 0 : 1;
    }

    @Override
    public <T extends ValueVector> AddOrGetResult<T> addOrGetVector(FieldType type) {
        boolean created = false;
        if (this.vector == ZeroVector.INSTANCE) {
            this.vector = type.createNewSingleVector("$data$", this.allocator, null);
            this.reader = new UnionFixedSizeListReader(this);
            created = true;
        }
        if (!Objects.equals(this.vector.getField().getType(), type.getType())) {
            String msg = String.format("Inner vector type mismatch. Requested type: [%s], actual type: [%s]", type.getType(), this.vector.getField().getType());
            throw new SchemaChangeRuntimeException(msg);
        }
        return new AddOrGetResult<FieldVector>(this.vector, created);
    }

    public void copyFromSafe(int inIndex, int outIndex, FixedSizeListVector from) {
        this.copyFrom(inIndex, outIndex, from);
    }

    public void copyFrom(int fromIndex, int thisIndex, FixedSizeListVector from) {
        TransferPair pair = from.makeTransferPair(this);
        pair.copyValueSafe(fromIndex, thisIndex);
    }

    @Override
    public UnionVector promoteToUnion() {
        UnionVector vector = new UnionVector(this.name, this.allocator, null);
        this.vector.clear();
        this.vector = vector;
        this.reader = new UnionFixedSizeListReader(this);
        return vector;
    }

    @Override
    public long getValidityBufferAddress() {
        return this.validityBuffer.memoryAddress();
    }

    @Override
    public long getDataBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getOffsetBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        return this.validityBuffer;
    }

    @Override
    public ArrowBuf getDataBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        JsonStringArrayList<Object> vals = new JsonStringArrayList<Object>(this.listSize);
        for (int i = 0; i < this.listSize; ++i) {
            vals.add(this.vector.getObject(index * this.listSize + i));
        }
        return vals;
    }

    @Override
    public boolean isNull(int index) {
        return this.isSet(index) == 0;
    }

    public int isSet(int index) {
        int byteIndex = index >> 3;
        byte b = this.validityBuffer.getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    @Override
    public int getNullCount() {
        return BitVectorHelper.getNullCount(this.validityBuffer, this.valueCount);
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    private int getValidityBufferValueCapacity() {
        return (int)((long)this.validityBuffer.capacity() * 8L);
    }

    public void setNull(int index) {
        while (index >= this.getValidityBufferValueCapacity()) {
            this.reallocValidityBuffer();
        }
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public void setNotNull(int index) {
        while (index >= this.getValidityBufferValueCapacity()) {
            this.reallocValidityBuffer();
        }
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
        while (valueCount > this.getValidityBufferValueCapacity()) {
            this.reallocValidityBuffer();
        }
        this.vector.setValueCount(valueCount * this.listSize);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return this.getTransferPair(ref, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return new TransferImpl(ref, allocator, callBack);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return new TransferImpl((FixedSizeListVector)target);
    }

    private class TransferImpl
    implements TransferPair {
        FixedSizeListVector to;
        TransferPair dataPair;

        public TransferImpl(String name, BufferAllocator allocator, CallBack callBack) {
            this(new FixedSizeListVector(name, allocator, fixedSizeListVector.fieldType, callBack));
        }

        public TransferImpl(FixedSizeListVector to) {
            this.to = to;
            to.addOrGetVector(FixedSizeListVector.this.vector.getField().getFieldType());
            this.dataPair = FixedSizeListVector.this.vector.makeTransferPair(to.vector);
        }

        @Override
        public void transfer() {
            this.to.clear();
            this.dataPair.transfer();
            this.to.validityBuffer = ((FixedSizeListVector)FixedSizeListVector.this).validityBuffer.transferOwnership((BufferAllocator)((FixedSizeListVector)this.to).allocator).buffer;
            this.to.setValueCount(FixedSizeListVector.this.valueCount);
            FixedSizeListVector.this.clear();
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            this.to.clear();
            this.to.allocateNew();
            for (int i = 0; i < length; ++i) {
                this.copyValueSafe(startIndex + i, i);
            }
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            while (toIndex >= this.to.getValueCapacity()) {
                this.to.reAlloc();
            }
            BitVectorHelper.setValidityBit(this.to.validityBuffer, toIndex, FixedSizeListVector.this.isSet(fromIndex));
            int fromOffset = fromIndex * FixedSizeListVector.this.listSize;
            int toOffset = toIndex * FixedSizeListVector.this.listSize;
            for (int i = 0; i < FixedSizeListVector.this.listSize; ++i) {
                this.dataPair.copyValueSafe(fromOffset + i, toOffset + i);
            }
        }
    }
}

