/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public abstract class TimeStampVector
extends BaseFixedWidthVector {
    protected static final byte TYPE_WIDTH = 8;

    public TimeStampVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, allocator, fieldType, 8);
    }

    public long get(int index) throws IllegalStateException {
        if (this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getLong(index * 8);
    }

    public void copyFrom(int fromIndex, int thisIndex, TimeStampVector from) {
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        long value = from.valueBuffer.getLong(fromIndex * 8);
        this.valueBuffer.setLong(thisIndex * 8, value);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, TimeStampVector from) {
        this.handleSafe(thisIndex);
        this.copyFrom(fromIndex, thisIndex, from);
    }

    protected void setValue(int index, long value) {
        this.valueBuffer.setLong(index * 8, value);
    }

    public void set(int index, long value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void setSafe(int index, long value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setNull(int index) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public void set(int index, int isSet, long value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, int isSet, long value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static long get(ArrowBuf buffer, int index) {
        return buffer.getLong(index * 8);
    }

    public class TransferImpl
    implements TransferPair {
        TimeStampVector to;

        public TransferImpl(TimeStampVector to) {
            this.to = to;
        }

        @Override
        public TimeStampVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            TimeStampVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            TimeStampVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, TimeStampVector.this);
        }
    }
}

