/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import java.time.LocalDateTime;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.TimeStampNanoReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampNanoHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.TimeStampNanoHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.DateUtility;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;

public class TimeStampNanoVector
extends TimeStampVector {
    private final FieldReader reader = new TimeStampNanoReaderImpl(this);

    public TimeStampNanoVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.TIMESTAMPNANO.getType()), allocator);
    }

    public TimeStampNanoVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, fieldType, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESTAMPNANO;
    }

    public void get(int index, NullableTimeStampNanoHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getLong(index * 8);
    }

    @Override
    public LocalDateTime getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        long nanos = this.valueBuffer.getLong(index * 8);
        return DateUtility.getLocalDateTimeFromEpochNano(nanos);
    }

    public void set(int index, NullableTimeStampNanoHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void set(int index, TimeStampNanoHolder holder) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, NullableTimeStampNanoHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, TimeStampNanoHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        TimeStampNanoVector to = new TimeStampNanoVector(ref, this.field.getFieldType(), allocator);
        return new TimeStampVector.TransferImpl(to);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TimeStampVector.TransferImpl((TimeStampNanoVector)to);
    }
}

