/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.SmallIntReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableSmallIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.SmallIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class SmallIntVector
extends BaseFixedWidthVector {
    public static final byte TYPE_WIDTH = 2;
    private final FieldReader reader = new SmallIntReaderImpl(this);

    public SmallIntVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.SMALLINT.getType()), allocator);
    }

    public SmallIntVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, allocator, fieldType, 2);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.SMALLINT;
    }

    public short get(int index) throws IllegalStateException {
        if (this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getShort(index * 2);
    }

    public void get(int index, NullableSmallIntHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getShort(index * 2);
    }

    @Override
    public Short getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getShort(index * 2);
    }

    public void copyFrom(int fromIndex, int thisIndex, SmallIntVector from) {
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        short value = from.valueBuffer.getShort(fromIndex * 2);
        this.valueBuffer.setShort(thisIndex * 2, value);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, SmallIntVector from) {
        this.handleSafe(thisIndex);
        this.copyFrom(fromIndex, thisIndex, from);
    }

    private void setValue(int index, int value) {
        this.valueBuffer.setShort(index * 2, value);
    }

    private void setValue(int index, short value) {
        this.valueBuffer.setShort(index * 2, value);
    }

    public void set(int index, int value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, short value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableSmallIntHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void set(int index, SmallIntHolder holder) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, int value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, short value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableSmallIntHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, SmallIntHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setNull(int index) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public void set(int index, int isSet, short value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, int isSet, short value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static short get(ArrowBuf buffer, int index) {
        return buffer.getShort(index * 2);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((SmallIntVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        SmallIntVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new SmallIntVector(ref, SmallIntVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(SmallIntVector to) {
            this.to = to;
        }

        @Override
        public SmallIntVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            SmallIntVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            SmallIntVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, SmallIntVector.this);
        }
    }
}

