/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.Float4ReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.Float4Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableFloat4Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class Float4Vector
extends BaseFixedWidthVector {
    public static final byte TYPE_WIDTH = 4;
    private final FieldReader reader = new Float4ReaderImpl(this);

    public Float4Vector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.FLOAT4.getType()), allocator);
    }

    public Float4Vector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, allocator, fieldType, 4);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.FLOAT4;
    }

    public float get(int index) throws IllegalStateException {
        if (this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getFloat(index * 4);
    }

    public void get(int index, NullableFloat4Holder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getFloat(index * 4);
    }

    @Override
    public Float getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return Float.valueOf(this.valueBuffer.getFloat(index * 4));
    }

    public void copyFrom(int fromIndex, int thisIndex, Float4Vector from) {
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        float value = from.valueBuffer.getFloat(fromIndex * 4);
        this.valueBuffer.setFloat(thisIndex * 4, value);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, Float4Vector from) {
        this.handleSafe(thisIndex);
        this.copyFrom(fromIndex, thisIndex, from);
    }

    private void setValue(int index, float value) {
        this.valueBuffer.setFloat(index * 4, value);
    }

    public void set(int index, float value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableFloat4Holder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void set(int index, Float4Holder holder) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, float value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableFloat4Holder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, Float4Holder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setNull(int index) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public void set(int index, int isSet, float value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, int isSet, float value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static float get(ArrowBuf buffer, int index) {
        return buffer.getFloat(index * 4);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((Float4Vector)to);
    }

    private class TransferImpl
    implements TransferPair {
        Float4Vector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new Float4Vector(ref, Float4Vector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Float4Vector to) {
            this.to = to;
        }

        @Override
        public Float4Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            Float4Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            Float4Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, Float4Vector.this);
        }
    }
}

