/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.BitReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.BitHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableBitHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.OversizedAllocationException;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class BitVector
extends BaseFixedWidthVector {
    private final FieldReader reader = new BitReaderImpl(this);

    public BitVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.BIT.getType()), allocator);
    }

    public BitVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, allocator, fieldType, 0);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.BIT;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        int size = BitVector.getValidityBufferSizeFromCount(valueCount);
        if (size * 2 > MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed");
        }
        this.lastValueCapacity = valueCount;
    }

    @Override
    public int getValueCapacity() {
        return (int)((long)this.validityBuffer.capacity() * 8L);
    }

    @Override
    public int getBufferSizeFor(int count) {
        if (count == 0) {
            return 0;
        }
        return 2 * BitVector.getValidityBufferSizeFromCount(count);
    }

    @Override
    public int getBufferSize() {
        return this.getBufferSizeFor(this.valueCount);
    }

    @Override
    public void splitAndTransferTo(int startIndex, int length, BaseFixedWidthVector target) {
        this.compareTypes(target, "splitAndTransferTo");
        target.clear();
        target.validityBuffer = this.splitAndTransferBuffer(startIndex, length, target, this.validityBuffer, target.validityBuffer);
        target.valueBuffer = this.splitAndTransferBuffer(startIndex, length, target, this.valueBuffer, target.valueBuffer);
        target.setValueCount(length);
    }

    private ArrowBuf splitAndTransferBuffer(int startIndex, int length, BaseFixedWidthVector target, ArrowBuf sourceBuffer, ArrowBuf destBuffer) {
        assert (startIndex + length <= this.valueCount);
        int firstByteSource = BitVectorHelper.byteIndex(startIndex);
        int lastByteSource = BitVectorHelper.byteIndex(this.valueCount - 1);
        int byteSizeTarget = BitVector.getValidityBufferSizeFromCount(length);
        int offset = startIndex % 8;
        if (length > 0) {
            if (offset == 0) {
                if (destBuffer != null) {
                    destBuffer.release();
                }
                destBuffer = sourceBuffer.slice(firstByteSource, byteSizeTarget);
                destBuffer.retain(1);
            } else {
                byte b1;
                destBuffer = this.allocator.buffer(byteSizeTarget);
                destBuffer.readerIndex(0);
                destBuffer.setZero(0, destBuffer.capacity());
                for (int i = 0; i < byteSizeTarget - 1; ++i) {
                    byte b12 = BitVectorHelper.getBitsFromCurrentByte(sourceBuffer, firstByteSource + i, offset);
                    byte b2 = BitVectorHelper.getBitsFromNextByte(sourceBuffer, firstByteSource + i + 1, offset);
                    destBuffer.setByte(i, b12 + b2);
                }
                if (firstByteSource + byteSizeTarget - 1 < lastByteSource) {
                    b1 = BitVectorHelper.getBitsFromCurrentByte(sourceBuffer, firstByteSource + byteSizeTarget - 1, offset);
                    byte b2 = BitVectorHelper.getBitsFromNextByte(sourceBuffer, firstByteSource + byteSizeTarget, offset);
                    destBuffer.setByte(byteSizeTarget - 1, b1 + b2);
                } else {
                    b1 = BitVectorHelper.getBitsFromCurrentByte(sourceBuffer, firstByteSource + byteSizeTarget - 1, offset);
                    destBuffer.setByte(byteSizeTarget - 1, b1);
                }
            }
        }
        return destBuffer;
    }

    private int getBit(int index) {
        int byteIndex = index >> 3;
        byte b = this.valueBuffer.getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    public int get(int index) throws IllegalStateException {
        if (this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.getBit(index);
    }

    public void get(int index, NullableBitHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.getBit(index);
    }

    @Override
    public Boolean getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return new Boolean(this.getBit(index) != 0);
    }

    public void copyFrom(int fromIndex, int thisIndex, BitVector from) {
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        BitVectorHelper.setValidityBit(this.valueBuffer, thisIndex, from.getBit(fromIndex));
    }

    public void copyFromSafe(int fromIndex, int thisIndex, BitVector from) {
        this.handleSafe(thisIndex);
        this.copyFrom(fromIndex, thisIndex, from);
    }

    public void set(int index, int value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        if (value != 0) {
            BitVectorHelper.setValidityBitToOne(this.valueBuffer, index);
        } else {
            BitVectorHelper.setValidityBit(this.valueBuffer, index, 0);
        }
    }

    public void set(int index, NullableBitHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
            if (holder.value != 0) {
                BitVectorHelper.setValidityBitToOne(this.valueBuffer, index);
            } else {
                BitVectorHelper.setValidityBit(this.valueBuffer, index, 0);
            }
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void set(int index, BitHolder holder) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        if (holder.value != 0) {
            BitVectorHelper.setValidityBitToOne(this.valueBuffer, index);
        } else {
            BitVectorHelper.setValidityBit(this.valueBuffer, index, 0);
        }
    }

    public void setSafe(int index, int value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableBitHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, BitHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setNull(int index) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public void set(int index, int isSet, int value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, int isSet, int value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public void setToOne(int index) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        BitVectorHelper.setValidityBitToOne(this.valueBuffer, index);
    }

    public void setSafeToOne(int index) {
        this.handleSafe(index);
        this.setToOne(index);
    }

    public void setRangeToOne(int firstBitIndex, int count) {
        int startByteIndex = BitVectorHelper.byteIndex(firstBitIndex);
        int lastBitIndex = firstBitIndex + count;
        int endByteIndex = BitVectorHelper.byteIndex(lastBitIndex);
        int startByteBitIndex = BitVectorHelper.bitIndex(firstBitIndex);
        int endBytebitIndex = BitVectorHelper.bitIndex(lastBitIndex);
        if (count < 8 && startByteIndex == endByteIndex) {
            byte bitMask = 0;
            for (int i = startByteBitIndex; i < endBytebitIndex; ++i) {
                bitMask = (byte)(bitMask | (byte)(1L << i));
            }
            BitVectorHelper.setBitMaskedByte(this.validityBuffer, startByteIndex, bitMask);
            BitVectorHelper.setBitMaskedByte(this.valueBuffer, startByteIndex, bitMask);
        } else {
            if (startByteBitIndex != 0) {
                byte bitMask = (byte)(255L << startByteBitIndex);
                BitVectorHelper.setBitMaskedByte(this.validityBuffer, startByteIndex, bitMask);
                BitVectorHelper.setBitMaskedByte(this.valueBuffer, startByteIndex, bitMask);
                ++startByteIndex;
            }
            for (int i = startByteIndex; i < endByteIndex; ++i) {
                this.validityBuffer.setByte(i, 255);
                this.valueBuffer.setByte(i, 255);
            }
            if (endBytebitIndex != 0) {
                int byteIndex = BitVectorHelper.byteIndex(lastBitIndex - endBytebitIndex);
                byte bitMask = (byte)(255L >>> (8 - endBytebitIndex & 7));
                BitVectorHelper.setBitMaskedByte(this.validityBuffer, byteIndex, bitMask);
                BitVectorHelper.setBitMaskedByte(this.valueBuffer, byteIndex, bitMask);
            }
        }
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((BitVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        BitVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new BitVector(ref, BitVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(BitVector to) {
            this.to = to;
        }

        @Override
        public BitVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            BitVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            BitVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, BitVector.this);
        }
    }
}

