/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeResultSetMetaData
implements ResultSetMetaData {
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeResultSetMetaData.class);
    private int columnCount = 0;
    private List<String> columnNames;
    private List<String> columnTypeNames;
    private List<Integer> columnTypes;
    private List<Integer> precisions;
    private List<Integer> scales;
    private Map<String, Integer> columnNamePositionMap = new HashMap<String, Integer>();
    private Map<String, Integer> columnNameUpperCasePositionMap = new HashMap<String, Integer>();
    private SFSession session;

    public SnowflakeResultSetMetaData() {
    }

    public SnowflakeResultSetMetaData(int columnCount, List<String> columnNames, List<String> columnTypeNames, List<Integer> columnTypes, SFSession session) throws SnowflakeSQLException {
        this.columnCount = columnCount;
        this.columnNames = columnNames;
        this.columnTypeNames = columnTypeNames;
        this.columnTypes = columnTypes;
        this.session = session;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public int getColumnIndex(String columnName) {
        Map<String, Integer> nameToIndexMap;
        boolean caseInsensitive = this.session != null && this.session.isResultColumnCaseInsensitive();
        columnName = caseInsensitive ? columnName.toUpperCase() : columnName;
        Map<String, Integer> map = nameToIndexMap = caseInsensitive ? this.columnNameUpperCasePositionMap : this.columnNamePositionMap;
        if (nameToIndexMap.get(columnName) != null) {
            return nameToIndexMap.get(columnName);
        }
        int columnIndex = caseInsensitive ? ResultUtil.listSearchCaseInsensitive(this.columnNames, columnName) : this.columnNames.indexOf(columnName);
        nameToIndexMap.put(columnName, columnIndex);
        return columnIndex;
    }

    @Override
    public int getColumnCount() throws SQLException {
        logger.debug("public int getColumnCount(), columnCount= {}", this.columnCount);
        return this.columnCount;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return SnowflakeType.isJavaTypeSigned(this.columnTypes.get(column - 1));
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 25;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        if (this.columnNames != null) {
            return this.columnNames.get(column - 1);
        }
        return "C" + (column - 1);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (this.columnNames != null) {
            return this.columnNames.get(column - 1);
        }
        return "C" + (column - 1);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        logger.debug("public int getPrecision(int column)");
        if (this.precisions != null && this.precisions.size() >= column) {
            return this.precisions.get(column - 1);
        }
        return 9;
    }

    @Override
    public int getScale(int column) throws SQLException {
        logger.debug("public int getScale(int column)");
        if (this.scales != null && this.scales.size() >= column) {
            return this.scales.get(column - 1);
        }
        return 9;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "T";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        int internalColumnType;
        logger.debug("public int getColumnType(int column)");
        int externalColumnType = internalColumnType = this.getInternalColumnType(column);
        if (internalColumnType == 50000 || internalColumnType == 50001) {
            externalColumnType = 93;
        }
        logger.debug("column type = {}", externalColumnType);
        return externalColumnType;
    }

    public int getInternalColumnType(int column) throws SQLException {
        logger.debug("public int getInternalColumnType(int column)");
        int columnIdx = column - 1;
        if (column > this.columnTypes.size()) {
            throw new SQLException("Invalid column index: " + column);
        }
        if (this.columnTypes.get(columnIdx) == null) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Missing column type for column " + column);
        }
        logger.debug("column type = {}", this.columnTypes.get(column - 1));
        return this.columnTypes.get(columnIdx);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        logger.debug("public String getColumnTypeName(int column)");
        if (column > this.columnTypeNames.size()) {
            throw new SQLException("Invalid column index: " + column);
        }
        if (this.columnTypeNames.get(column - 1) == null) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "Missing column type for column " + column);
        }
        return this.columnTypeNames.get(column - 1);
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        logger.debug("public String getColumnClassName(int column)");
        int type = this.getColumnType(column);
        return SnowflakeType.javaTypeToClassName(type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.debug("public <T> T unwrap(Class<T> iface)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.debug("public boolean isWrapperFor(Class<?> iface)");
        throw new SQLFeatureNotSupportedException();
    }
}

