/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.SmallIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;

public class SmallIntToFixedConverter
extends AbstractArrowVectorConverter {
    protected int sfScale;
    protected SmallIntVector smallIntVector;
    ByteBuffer byteBuf = ByteBuffer.allocate(2);

    public SmallIntToFixedConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(String.format("%s(%s,%s)", new Object[]{SnowflakeType.FIXED, fieldVector.getField().getMetadata().get("precision"), fieldVector.getField().getMetadata().get("scale")}), fieldVector, columnIndex, context);
        this.smallIntVector = (SmallIntVector)fieldVector;
    }

    protected short getShort(int index) throws SFException {
        return this.smallIntVector.getDataBuffer().getShort(index * 2);
    }

    @Override
    public byte[] toBytes(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        this.byteBuf.putShort(0, this.getShort(index));
        return this.byteBuf.array();
    }

    @Override
    public byte toByte(int index) throws SFException {
        short shortVal = this.toShort(index);
        byte byteVal = (byte)shortVal;
        if (byteVal == shortVal) {
            return byteVal;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byte", shortVal);
    }

    @Override
    public short toShort(int index) throws SFException {
        if (this.smallIntVector.isNull(index)) {
            return 0;
        }
        return this.getShort(index);
    }

    @Override
    public int toInt(int index) throws SFException {
        return this.toShort(index);
    }

    @Override
    public long toLong(int index) throws SFException {
        return this.toShort(index);
    }

    @Override
    public BigDecimal toBigDecimal(int index) throws SFException {
        if (this.smallIntVector.isNull(index)) {
            return null;
        }
        return BigDecimal.valueOf(this.getShort(index), this.sfScale);
    }

    @Override
    public float toFloat(int index) throws SFException {
        return this.toShort(index);
    }

    @Override
    public double toDouble(int index) throws SFException {
        return this.toFloat(index);
    }

    @Override
    public Object toObject(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        return (long)this.getShort(index);
    }

    @Override
    public String toString(int index) throws SFException {
        return this.isNull(index) ? null : Short.toString(this.getShort(index));
    }
}

