/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import net.snowflake.client.core.ChunkDownloader;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.MetaDataOfBinds;
import net.snowflake.client.core.QueryResultFormat;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFChildResult;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeChunkDownloader;
import net.snowflake.client.jdbc.SnowflakeColumnMetadata;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinaryFormat;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.jdbc.internal.snowflake.common.util.TimeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class ResultUtil {
    static final SFLogger logger = SFLoggerFactory.getLogger(ResultUtil.class);
    public static final int MILLIS_IN_ONE_DAY = 86400000;
    public static final int DEFAULT_SCALE_OF_SFTIME_FRACTION_SECONDS = 3;
    private static TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");
    private static final Map<String, Object> defaultParameters;

    public static ResultOutput processResult(ResultInput resultData, SFStatement sfStatement) throws SnowflakeSQLException {
        JsonNode arrayBindSupported;
        JsonNode numberOfBindsNode;
        SFSession sfSession = sfStatement.getSession();
        ResultOutput resultOutput = new ResultOutput();
        logger.debug("Entering processResult");
        JsonNode rootNode = resultData.resultJSON;
        SnowflakeUtil.checkErrorAndThrowException(rootNode);
        resultOutput.queryId = rootNode.path("data").path("queryId").asText();
        JsonNode databaseNode = rootNode.path("data").path("finalDatabaseName");
        resultOutput.finalDatabaseName = databaseNode.isNull() ? null : databaseNode.asText();
        JsonNode schemaNode = rootNode.path("data").path("finalSchemaName");
        resultOutput.finalSchemaName = schemaNode.isNull() ? null : schemaNode.asText();
        JsonNode roleNode = rootNode.path("data").path("finalRoleName");
        resultOutput.finalRoleName = roleNode.isNull() ? null : roleNode.asText();
        JsonNode warehouseNode = rootNode.path("data").path("finalWarehouseName");
        resultOutput.finalWarehouseName = warehouseNode.isNull() ? null : warehouseNode.asText();
        resultOutput.statementType = SFStatementType.lookUpTypeById(rootNode.path("data").path("statementTypeId").asLong());
        resultOutput.totalRowCountTruncated = rootNode.path("data").path("totalTruncated").asBoolean();
        logger.debug("query id: {}", resultOutput.queryId);
        Optional<QueryResultFormat> queryResultFormat = QueryResultFormat.lookupByName(rootNode.path("data").path("queryResultFormat").asText());
        resultOutput.queryResultFormat = queryResultFormat.orElse(QueryResultFormat.JSON);
        resultOutput.parameters = SessionUtil.getCommonParams(rootNode.path("data").path("parameters"));
        resultOutput.columnCount = rootNode.path("data").path("rowtype").size();
        for (int i = 0; i < resultOutput.columnCount; ++i) {
            JsonNode colNode = rootNode.path("data").path("rowtype").path(i);
            SnowflakeColumnMetadata columnMetadata = SnowflakeUtil.extractColumnMetadata(colNode, sfSession.isJdbcTreatDecimalAsInt());
            resultOutput.resultColumnMetadata.add(columnMetadata);
            logger.debug("Get column metadata: {}", () -> columnMetadata.toString());
        }
        if (resultOutput.queryResultFormat == QueryResultFormat.ARROW) {
            resultOutput.rowsetBase64 = rootNode.path("data").path("rowsetBase64").asText();
        } else {
            resultOutput.currentChunkRowset = rootNode.path("data").path("rowset");
            resultOutput.currentChunkRowCount = resultOutput.currentChunkRowset == null || resultOutput.currentChunkRowset.isMissingNode() ? 0 : resultOutput.currentChunkRowset.size();
            logger.debug("First chunk row count: {}", resultOutput.currentChunkRowCount);
        }
        JsonNode chunksNode = rootNode.path("data").path("chunks");
        if (!chunksNode.isMissingNode()) {
            resultOutput.chunkCount = chunksNode.size();
            JsonNode qrmkNode = rootNode.path("data").path("qrmk");
            String qrmk = qrmkNode.isMissingNode() ? null : qrmkNode.textValue();
            JsonNode chunkHeaders = rootNode.path("data").path("chunkHeaders");
            if (resultOutput.chunkCount > 0L) {
                long memoryLimit;
                logger.debug("#chunks={}, initialize chunk downloader", resultOutput.chunkCount);
                int resultPrefetchThreads = SessionUtil.DEFAULT_CLIENT_PREFETCH_THREADS;
                if (resultOutput.statementType.isSelect() && resultOutput.parameters.containsKey("CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE") && ((Boolean)resultOutput.parameters.get("CLIENT_ENABLE_CONSERVATIVE_MEMORY_USAGE")).booleanValue()) {
                    resultPrefetchThreads = sfStatement.getConservativePrefetchThreads();
                    memoryLimit = sfStatement.getConservativeMemoryLimit();
                    int chunkSize = (Integer)resultOutput.parameters.get("CLIENT_RESULT_CHUNK_SIZE");
                    logger.debug("enable conservative memory usage with prefetchThreads = {} and memoryLimit = {} and resultChunkSize = {}", resultPrefetchThreads, memoryLimit, chunkSize);
                } else {
                    if (resultOutput.parameters.get("CLIENT_PREFETCH_THREADS") != null) {
                        resultPrefetchThreads = (Integer)resultOutput.parameters.get("CLIENT_PREFETCH_THREADS");
                    }
                    memoryLimit = ResultUtil.initMemoryLimit(resultOutput);
                }
                boolean useJsonParserV2 = false;
                if (resultOutput.parameters.get("JDBC_USE_JSON_PARSER") != null) {
                    useJsonParserV2 = (Boolean)resultOutput.parameters.get("JDBC_USE_JSON_PARSER");
                }
                resultOutput.chunkDownloader = new SnowflakeChunkDownloader(resultOutput.columnCount, chunksNode, resultPrefetchThreads, qrmk, chunkHeaders, resultData.networkTimeoutInMilli, useJsonParserV2, memoryLimit, resultOutput.queryResultFormat);
            }
        }
        String sqlTimestampFormat = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "TIMESTAMP_OUTPUT_FORMAT");
        resultOutput.timestampNTZFormatter = ResultUtil.specializedFormatter(resultOutput.parameters, "timestamp_ntz", "TIMESTAMP_NTZ_OUTPUT_FORMAT", sqlTimestampFormat);
        resultOutput.timestampLTZFormatter = ResultUtil.specializedFormatter(resultOutput.parameters, "timestamp_ltz", "TIMESTAMP_LTZ_OUTPUT_FORMAT", sqlTimestampFormat);
        resultOutput.timestampTZFormatter = ResultUtil.specializedFormatter(resultOutput.parameters, "timestamp_tz", "TIMESTAMP_TZ_OUTPUT_FORMAT", sqlTimestampFormat);
        String sqlDateFormat = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "DATE_OUTPUT_FORMAT");
        resultOutput.dateFormatter = new SnowflakeDateTimeFormat(sqlDateFormat);
        logger.debug("sql date format: {}, java date format: {}", sqlDateFormat, () -> resultOutput.dateFormatter.toSimpleDateTimePattern());
        String sqlTimeFormat = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "TIME_OUTPUT_FORMAT");
        resultOutput.timeFormatter = new SnowflakeDateTimeFormat(sqlTimeFormat);
        logger.debug("sql time format: {}, java time format: {}", sqlTimeFormat, () -> resultOutput.timeFormatter.toSimpleDateTimePattern());
        String timeZoneName = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "TIMEZONE");
        resultOutput.timeZone = TimeZone.getTimeZone(timeZoneName);
        resultOutput.honorClientTZForTimestampNTZ = (Boolean)ResultUtil.effectiveParamValue(resultOutput.parameters, "CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ");
        logger.debug("Honoring client TZ for timestamp_ntz? {}", resultOutput.honorClientTZForTimestampNTZ);
        String binaryFmt = (String)ResultUtil.effectiveParamValue(resultOutput.parameters, "BINARY_OUTPUT_FORMAT");
        resultOutput.binaryFormatter = SFBinaryFormat.getSafeOutputFormat(binaryFmt);
        JsonNode versionNode = rootNode.path("data").path("version");
        if (!versionNode.isMissingNode()) {
            resultOutput.resultVersion = versionNode.longValue();
        }
        if (!(numberOfBindsNode = rootNode.path("data").path("numberOfBinds")).isMissingNode()) {
            resultOutput.numberOfBinds = numberOfBindsNode.intValue();
        }
        resultOutput.arrayBindSupported = !(arrayBindSupported = rootNode.path("data").path("arrayBindSupported")).isMissingNode() && arrayBindSupported.asBoolean();
        JsonNode sendResultTimeNode = rootNode.path("data").path("sendResultTime");
        if (!sendResultTimeNode.isMissingNode()) {
            resultOutput.sendResultTime = sendResultTimeNode.longValue();
        }
        logger.debug("result version={}", resultOutput.resultVersion);
        JsonNode bindData = rootNode.path("data").path("metaDataOfBinds");
        if (!bindData.isMissingNode()) {
            ArrayList<MetaDataOfBinds> returnVal = new ArrayList<MetaDataOfBinds>();
            for (JsonNode child : bindData) {
                int precision = child.path("precision").asInt();
                boolean nullable = child.path("nullable").asBoolean();
                int scale = child.path("scale").asInt();
                int byteLength = child.path("byteLength").asInt();
                int length = child.path("length").asInt();
                String name = child.path("name").asText();
                String type = child.path("type").asText();
                MetaDataOfBinds param = new MetaDataOfBinds(precision, nullable, scale, byteLength, length, name, type);
                returnVal.add(param);
            }
            resultOutput.metaDataOfBinds = returnVal;
        }
        return resultOutput;
    }

    private static long initMemoryLimit(ResultOutput resultOutput) {
        long memoryLimit = SessionUtil.DEFAULT_CLIENT_MEMORY_LIMIT * 1024L * 1024L;
        if (resultOutput.parameters.get("CLIENT_MEMORY_LIMIT") != null) {
            memoryLimit = (long)((Integer)resultOutput.parameters.get("CLIENT_MEMORY_LIMIT")).intValue() * 1024L * 1024L;
        }
        long maxMemoryToUse = Runtime.getRuntime().maxMemory() * 8L / 10L;
        if ((long)((Integer)resultOutput.parameters.get("CLIENT_MEMORY_LIMIT")).intValue() == SessionUtil.DEFAULT_CLIENT_MEMORY_LIMIT) {
            memoryLimit = Math.max(memoryLimit, maxMemoryToUse);
        }
        memoryLimit = Math.min(memoryLimit, maxMemoryToUse);
        logger.debug("Set allowed memory usage to {} bytes", memoryLimit);
        return memoryLimit;
    }

    private static Object effectiveParamValue(Map<String, Object> parameters, String paramName) {
        String upper = paramName.toUpperCase();
        Object value = parameters.get(upper);
        if (value != null) {
            return value;
        }
        value = defaultParameters.get(upper);
        if (value != null) {
            return value;
        }
        logger.debug("Unknown Common Parameter: {}", paramName);
        return null;
    }

    private static SnowflakeDateTimeFormat specializedFormatter(Map<String, Object> parameters, String id, String param, String defaultFormat) {
        String sqlFormat = SnowflakeDateTimeFormat.effectiveSpecializedTimestampFormat((String)ResultUtil.effectiveParamValue(parameters, param), defaultFormat);
        SnowflakeDateTimeFormat formatter = new SnowflakeDateTimeFormat(sqlFormat);
        Object[] objectArray = new Object[4];
        objectArray[0] = id;
        objectArray[1] = sqlFormat;
        objectArray[2] = id;
        objectArray[3] = formatter::toSimpleDateTimePattern;
        logger.debug("sql {} format: {}, java {} format: {}", objectArray);
        return formatter;
    }

    public static Timestamp adjustTimestamp(Timestamp timestamp) {
        long milliToAdjust = ResultUtil.msDiffJulianToGregorian(timestamp);
        if (milliToAdjust != 0L) {
            logger.debug("adjust timestamp by {} days", () -> milliToAdjust / 86400000L);
            Timestamp newTimestamp = new Timestamp(timestamp.getTime() + milliToAdjust);
            newTimestamp.setNanos(timestamp.getNanos());
            return newTimestamp;
        }
        return timestamp;
    }

    public static long msDiffJulianToGregorian(java.util.Date date) {
        if (date.getTime() < -12220156800000L) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int year = cal.get(1);
            int month = cal.get(2);
            int dayOfMonth = cal.get(5);
            if (month == 0 || month == 1 && dayOfMonth <= 28) {
                --year;
            }
            int hundreds = year / 100;
            int differenceInDays = hundreds - hundreds / 4 - 2;
            return differenceInDays * 86400000;
        }
        return 0L;
    }

    public static SFTimestamp getSFTimestamp(String timestampStr, int scale, int internalColumnType, long resultVersion, TimeZone sessionTZ, SFSession session) throws SFException {
        logger.debug("public Timestamp getTimestamp(int columnIndex)");
        try {
            TimeUtil.TimestampType tsType = null;
            switch (internalColumnType) {
                case 93: {
                    tsType = TimeUtil.TimestampType.TIMESTAMP_NTZ;
                    break;
                }
                case 50001: {
                    tsType = TimeUtil.TimestampType.TIMESTAMP_TZ;
                    logger.trace("Handle timestamp with timezone {} encoding: {}", resultVersion > 0L ? "new" : "old", timestampStr);
                    break;
                }
                case 50000: {
                    tsType = TimeUtil.TimestampType.TIMESTAMP_LTZ;
                }
            }
            return TimeUtil.getSFTimestamp(timestampStr, scale, tsType, resultVersion, sessionTZ);
        }
        catch (IllegalArgumentException ex) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(session, new SFException(ErrorCode.IO_ERROR, "Invalid timestamp value: " + timestampStr), null, null);
        }
    }

    public static SFTime getSFTime(String obj, int scale, SFSession session) throws SFException {
        try {
            return TimeUtil.getSFTime(obj, scale);
        }
        catch (IllegalArgumentException ex) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(session, new SFException(ErrorCode.INTERNAL_ERROR, "Invalid time value: " + obj), null, null);
        }
    }

    public static String getSFTimeAsString(SFTime sft, int scale, SnowflakeDateTimeFormat timeFormatter) {
        return timeFormatter.format(sft, scale);
    }

    public static String getBooleanAsString(boolean bool) {
        return bool ? "TRUE" : "FALSE";
    }

    public static String getSFTimestampAsString(SFTimestamp sfTS, int columnType, int scale, SnowflakeDateTimeFormat timestampNTZFormatter, SnowflakeDateTimeFormat timestampLTZFormatter, SnowflakeDateTimeFormat timestampTZFormatter, SFSession session) throws SFException {
        SnowflakeDateTimeFormat formatter = columnType == 93 ? timestampNTZFormatter : (columnType == 50000 ? timestampLTZFormatter : timestampTZFormatter);
        if (formatter == null) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(session, new SFException(ErrorCode.INTERNAL_ERROR, "missing timestamp formatter"), null, null);
        }
        try {
            Timestamp adjustedTimestamp = ResultUtil.adjustTimestamp(sfTS.getTimestamp());
            return formatter.format(adjustedTimestamp, sfTS.getTimeZone(), scale);
        }
        catch (SFTimestamp.TimestampOperationNotAvailableException e) {
            BigDecimal nanosSinceEpoch = sfTS.getNanosSinceEpoch();
            BigDecimal secondsSinceEpoch = nanosSinceEpoch.scaleByPowerOfTen(-9);
            return secondsSinceEpoch.setScale(scale).toPlainString();
        }
    }

    public static String getDateAsString(Date date, SnowflakeDateTimeFormat dateFormatter) {
        return dateFormatter.format((java.util.Date)date, timeZoneUTC);
    }

    public static Date adjustDate(Date date) {
        long milliToAdjust = ResultUtil.msDiffJulianToGregorian(date);
        if (milliToAdjust != 0L) {
            return new Date(date.getTime() + milliToAdjust);
        }
        return date;
    }

    public static Date getDate(String str, TimeZone tz, SFSession session) throws SFException {
        try {
            long milliSecsSinceEpoch = Long.valueOf(str) * 86400000L;
            SFTimestamp tsInUTC = SFTimestamp.fromDate(new Date(milliSecsSinceEpoch), 0, TimeZone.getTimeZone("UTC"));
            SFTimestamp tsInClientTZ = tsInUTC.moveToTimeZone(tz);
            logger.debug("getDate: tz offset={}", () -> tsInClientTZ.getTimeZone().getOffset(tsInClientTZ.getTime()));
            Date preDate = new Date(tsInClientTZ.getTime());
            Date newDate = ResultUtil.adjustDate(preDate);
            Object[] objectArray = new Object[2];
            objectArray[0] = preDate::toString;
            objectArray[1] = newDate::toString;
            logger.debug("Adjust date from {} to {}", objectArray);
            return newDate;
        }
        catch (NumberFormatException ex) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(session, new SFException(ErrorCode.INTERNAL_ERROR, "Invalid date value: " + str), null, null);
        }
    }

    public static boolean getBoolean(String str) {
        return str.equalsIgnoreCase("true") || str.equals("1");
    }

    public static long calculateUpdateCount(SFBaseResultSet resultSet) throws SFException, SQLException {
        long updateCount = 0L;
        SFStatementType statementType = resultSet.getStatementType();
        if (statementType.isDML()) {
            while (resultSet.next()) {
                if (statementType == SFStatementType.COPY) {
                    SFResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int columnIndex = resultSetMetaData.getColumnIndex("rows_loaded");
                    updateCount += columnIndex == -1 ? 0L : (long)resultSet.getInt(columnIndex + 1);
                    continue;
                }
                if (statementType == SFStatementType.INSERT || statementType == SFStatementType.UPDATE || statementType == SFStatementType.DELETE || statementType == SFStatementType.MERGE || statementType == SFStatementType.MULTI_INSERT) {
                    int columnCount = resultSet.getMetaData().getColumnCount();
                    for (int i = 0; i < columnCount; ++i) {
                        updateCount += resultSet.getLong(i + 1);
                    }
                    continue;
                }
                updateCount = 0L;
            }
        } else {
            updateCount = statementType.isGenerateResultSet() ? -1L : 0L;
        }
        return updateCount;
    }

    public static int listSearchCaseInsensitive(List<String> source, String target) {
        for (int i = 0; i < source.size(); ++i) {
            if (!target.equalsIgnoreCase(source.get(i))) continue;
            return i;
        }
        return -1;
    }

    private static List<String> getResultIds(JsonNode result) {
        JsonNode resultIds = result.path("data").path("resultIds");
        if (resultIds.isNull() || resultIds.isMissingNode() || resultIds.asText().isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(resultIds.asText().split(",")));
    }

    private static List<SFStatementType> getResultTypes(JsonNode result) {
        JsonNode resultTypes = result.path("data").path("resultTypes");
        if (resultTypes.isNull() || resultTypes.isMissingNode() || resultTypes.asText().isEmpty()) {
            return Collections.emptyList();
        }
        String[] typeStrs = resultTypes.asText().split(",");
        ArrayList<SFStatementType> res = new ArrayList<SFStatementType>();
        for (String typeStr : typeStrs) {
            long typeId = Long.valueOf(typeStr);
            res.add(SFStatementType.lookUpTypeById(typeId));
        }
        return res;
    }

    public static List<SFChildResult> getChildResults(SFSession session, String requestId, JsonNode result) throws SFException {
        List<String> ids = ResultUtil.getResultIds(result);
        List<SFStatementType> types = ResultUtil.getResultTypes(result);
        if (ids.size() != types.size()) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(session, new SFException(ErrorCode.CHILD_RESULT_IDS_AND_TYPES_DIFFERENT_SIZES, ids.size(), types.size()), null, requestId);
        }
        ArrayList<SFChildResult> res = new ArrayList<SFChildResult>();
        for (int i = 0; i < ids.size(); ++i) {
            res.add(new SFChildResult(ids.get(i), types.get(i)));
        }
        return res;
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TIMEZONE", "America/Los_Angeles");
        map.put("TIMESTAMP_OUTPUT_FORMAT", "DY, DD MON YYYY HH24:MI:SS TZHTZM");
        map.put("TIMESTAMP_NTZ_OUTPUT_FORMAT", "");
        map.put("TIMESTAMP_LTZ_OUTPUT_FORMAT", "");
        map.put("TIMESTAMP_TZ_OUTPUT_FORMAT", "");
        map.put("DATE_OUTPUT_FORMAT", "YYYY-MM-DD");
        map.put("TIME_OUTPUT_FORMAT", "HH24:MI:SS");
        map.put("CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ", Boolean.TRUE);
        map.put("CLIENT_DISABLE_INCIDENTS", Boolean.TRUE);
        map.put("BINARY_OUTPUT_FORMAT", "HEX");
        defaultParameters = map;
    }

    public static class ResultOutput {
        long chunkCount;
        String queryId;
        String finalDatabaseName;
        String finalSchemaName;
        String finalRoleName;
        String finalWarehouseName;
        SFStatementType statementType;
        boolean totalRowCountTruncated;
        Map<String, Object> parameters = new HashMap<String, Object>();
        int columnCount;
        private List<SnowflakeColumnMetadata> resultColumnMetadata = new ArrayList<SnowflakeColumnMetadata>();
        private JsonNode currentChunkRowset = null;
        String rowsetBase64;
        int currentChunkRowCount;
        long resultVersion;
        int numberOfBinds;
        boolean arrayBindSupported;
        ChunkDownloader chunkDownloader;
        SnowflakeDateTimeFormat timestampNTZFormatter;
        SnowflakeDateTimeFormat timestampLTZFormatter;
        SnowflakeDateTimeFormat timestampTZFormatter;
        SnowflakeDateTimeFormat dateFormatter;
        SnowflakeDateTimeFormat timeFormatter;
        TimeZone timeZone;
        boolean honorClientTZForTimestampNTZ;
        SFBinaryFormat binaryFormatter;
        long sendResultTime;
        List<MetaDataOfBinds> metaDataOfBinds = new ArrayList<MetaDataOfBinds>();
        QueryResultFormat queryResultFormat;

        public long getChunkCount() {
            return this.chunkCount;
        }

        public boolean isArrayBindSupported() {
            return this.arrayBindSupported;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public String getFinalDatabaseName() {
            return this.finalDatabaseName;
        }

        public String getFinalSchemaName() {
            return this.finalSchemaName;
        }

        String getFinalRoleName() {
            return this.finalRoleName;
        }

        String getFinalWarehouseName() {
            return this.finalWarehouseName;
        }

        public SFStatementType getStatementType() {
            return this.statementType;
        }

        public boolean isTotalRowCountTruncated() {
            return this.totalRowCountTruncated;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public List<SnowflakeColumnMetadata> getResultColumnMetadata() {
            return this.resultColumnMetadata;
        }

        public JsonNode getAndClearCurrentChunkRowset() {
            JsonNode currentChunkRowset = this.currentChunkRowset;
            this.currentChunkRowset = null;
            return currentChunkRowset;
        }

        public int getCurrentChunkRowCount() {
            return this.currentChunkRowCount;
        }

        public long getResultVersion() {
            return this.resultVersion;
        }

        public int getNumberOfBinds() {
            return this.numberOfBinds;
        }

        public ChunkDownloader getChunkDownloader() {
            return this.chunkDownloader;
        }

        public SnowflakeDateTimeFormat getTimestampNTZFormatter() {
            return this.timestampNTZFormatter;
        }

        public SnowflakeDateTimeFormat getTimestampLTZFormatter() {
            return this.timestampLTZFormatter;
        }

        public SnowflakeDateTimeFormat getTimestampTZFormatter() {
            return this.timestampTZFormatter;
        }

        public SnowflakeDateTimeFormat getDateFormatter() {
            return this.dateFormatter;
        }

        public SnowflakeDateTimeFormat getTimeFormatter() {
            return this.timeFormatter;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public boolean isHonorClientTZForTimestampNTZ() {
            return this.honorClientTZForTimestampNTZ;
        }

        public SFBinaryFormat getBinaryFormatter() {
            return this.binaryFormatter;
        }

        public long getSendResultTime() {
            return this.sendResultTime;
        }

        public List<MetaDataOfBinds> getMetaDataOfBinds() {
            return this.metaDataOfBinds;
        }

        String getRowsetBase64() {
            return this.rowsetBase64;
        }
    }

    public static class ResultInput {
        JsonNode resultJSON;
        int connectionTimeout;
        int socketTimeout;
        int networkTimeoutInMilli;

        public ResultInput setResultJSON(JsonNode resultJSON) {
            this.resultJSON = resultJSON;
            return this;
        }

        public ResultInput setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public ResultInput setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public ResultInput setNetworkTimeoutInMilli(int networkTimeoutInMilli) {
            this.networkTimeoutInMilli = networkTimeoutInMilli;
            return this;
        }
    }
}

