/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.snowflake.common.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.snowflake.client.jdbc.internal.snowflake.common.core.CalendarCache;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFInstant;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;

public class SFDate
extends SFInstant
implements Comparable<SFDate> {
    private final Date date;
    public static final SFDate MIN_VALID_VALUE;
    public static final SFDate MAX_VALID_VALUE;

    public Date getDate() {
        return this.date;
    }

    public int hashCode() {
        return this.date.hashCode();
    }

    public long getTime() {
        return this.date.getTime();
    }

    public String toUTCString() {
        GregorianCalendar calendar = CalendarCache.get("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setCalendar(calendar);
        return df.format(this.date.getTime());
    }

    @Override
    public int compareTo(SFDate other) {
        return this.date.compareTo(other.date);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SFDate)) {
            return false;
        }
        return this.equals((SFDate)o);
    }

    public boolean equals(SFDate other) {
        return this.date.equals(other.date);
    }

    public SFDate(long millis) {
        this.date = SFDate.normalize(millis, null);
    }

    public SFDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Illegal null date parameter.");
        }
        this.date = SFDate.normalize(date.getTime(), null);
    }

    public SFDate(SFDate sfd) {
        this.date = (Date)sfd.date.clone();
    }

    public static SFDate fromTimestamp(SFTimestamp timestamp) {
        long millis = timestamp.getTime();
        TimeZone tz = timestamp.getTimeZone();
        return new SFDate(SFDate.normalize(millis, tz));
    }

    private static Date normalize(long millis, TimeZone tz) {
        if (tz != null) {
            millis += (long)tz.getOffset(millis);
        }
        double MILLIS_IN_DAY = 8.64E7;
        double dblMS = millis;
        dblMS = Math.floor(dblMS / 8.64E7) * 8.64E7;
        millis = (long)dblMS;
        return new Date(millis);
    }

    @Override
    public int extract(int field, Integer optWeekStart, Integer optWoyPolicy) {
        return this.extract(field, SFInstant.GMT, this.date.getTime(), optWeekStart, optWoyPolicy);
    }

    public String toString() {
        return "SFDate(date='" + this.date + "')";
    }

    static {
        GregorianCalendar cal = new GregorianCalendar(SFInstant.GMT);
        cal.setGregorianChange(new Date(Long.MIN_VALUE));
        cal.setTimeInMillis(0L);
        cal.set(0, 0);
        cal.set(1000000, 0, 1);
        MIN_VALID_VALUE = new SFDate(cal.getTimeInMillis());
        cal.set(0, 1);
        cal.set(999999, 11, 31);
        MAX_VALID_VALUE = new SFDate(cal.getTimeInMillis());
    }
}

