/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec;

import javax.crypto.spec.PBEParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERNull;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.DigestAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.PrfUtils;

public class PBKDF2ParameterSpec
extends PBEParameterSpec {
    private static final AlgorithmIdentifier defaultPRF = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);
    private final int keySize;
    private final AlgorithmIdentifier prf;

    public PBKDF2ParameterSpec(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, defaultPRF);
    }

    public PBKDF2ParameterSpec(byte[] byArray, int n, int n2, DigestAlgorithm digestAlgorithm) {
        this(byArray, n, n2, PrfUtils.getAlgorithmIdentifier(digestAlgorithm));
    }

    public PBKDF2ParameterSpec(byte[] byArray, int n, int n2, AlgorithmIdentifier algorithmIdentifier) {
        super(byArray, n);
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("keySize must be a multiple of 8");
        }
        this.keySize = n2;
        this.prf = algorithmIdentifier;
    }

    public boolean isDefaultPrf() {
        return defaultPRF.equals(this.prf);
    }

    public int getKeySize() {
        return this.keySize;
    }

    public AlgorithmIdentifier getPrf() {
        return this.prf;
    }
}

