/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.spec.IvParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AuthenticationParametersWithIV;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.MACOperatorFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.ParametersWithIV;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.SymmetricKeyGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Serpent;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ASN1AlgorithmParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.AuthParametersCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseMac;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseSecretKeyFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseWrapCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.EngineCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.GcmSpecUtil;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.IVAlgorithmParameterGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.IvParametersCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ParametersCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.SymmetricAlgorithmProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.Utils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.WrapParameterSpec;

class ProvSerpent
extends SymmetricAlgorithmProvider {
    private static final String PREFIX = ProvSerpent.class.getName();
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(final Parameters parameters) {
            if (Utils.isAuthMode(parameters.getAlgorithm())) {
                return new AuthParametersCreator((AuthenticationParametersWithIV)parameters);
            }
            if (parameters.getAlgorithm().equals(Serpent.KW.getAlgorithm()) || parameters.getAlgorithm().equals(Serpent.KWP.getAlgorithm())) {
                return new ParametersCreator(){

                    public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        if (algorithmParameterSpec instanceof WrapParameterSpec) {
                            return ((Serpent.WrapParameters)parameters).withUsingInverseFunction(((WrapParameterSpec)algorithmParameterSpec).useInverseFunction());
                        }
                        return parameters;
                    }
                };
            }
            return new IvParametersCreator((ParametersWithIV)parameters);
        }
    };

    ProvSerpent() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        final Serpent.OperatorFactory operatorFactory = new Serpent.OperatorFactory();
        final Serpent.AEADOperatorFactory aEADOperatorFactory = new Serpent.AEADOperatorFactory();
        final Serpent.KeyWrapOperatorFactory keyWrapOperatorFactory = new Serpent.KeyWrapOperatorFactory();
        final Class[] classArray = GcmSpecUtil.getCipherSpecClasses();
        final Class[] classArray2 = new Class[]{IvParameterSpec.class};
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.SERPENT", PREFIX + "$ECB", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Serpent.ECBwithPKCS7, Serpent.ECB, Serpent.ECBwithISO10126_2, Serpent.ECBwithISO7816_4, Serpent.ECBwithTBC, Serpent.ECBwithX923, Serpent.CBC, Serpent.CBCwithPKCS7, Serpent.CBCwithISO10126_2, Serpent.CBCwithISO7816_4, Serpent.CBCwithTBC, Serpent.CBCwithX923, Serpent.CBCwithCS1, Serpent.CBCwithCS2, Serpent.CBCwithCS3, Serpent.CFB128, Serpent.CFB8, Serpent.OFB, Serpent.CTR, Serpent.GCM, Serpent.CCM, Serpent.OCB, Serpent.EAX).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, operatorFactory, aEADOperatorFactory).withParameters(classArray).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SERPENT", PREFIX + "$KeyGen", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "Serpent", 128, false, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new Serpent.KeyGenerator(n, secureRandom);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "SERPENT", GNUObjectIdentifiers.Serpent);
        GuardedEngineCreator guardedEngineCreator = new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "Serpent", 128, true, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new Serpent.KeyGenerator(128, secureRandom);
                    }
                });
            }
        });
        this.addKeyGeneratorForOIDs(bouncyCastleFipsProvider, PREFIX, guardedEngineCreator, GNUObjectIdentifiers.Serpent_128_CBC, GNUObjectIdentifiers.Serpent_128_CFB, GNUObjectIdentifiers.Serpent_128_ECB, GNUObjectIdentifiers.Serpent_128_OFB);
        GuardedEngineCreator guardedEngineCreator2 = new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "Serpent", 192, true, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new Serpent.KeyGenerator(192, secureRandom);
                    }
                });
            }
        });
        this.addKeyGeneratorForOIDs(bouncyCastleFipsProvider, PREFIX, guardedEngineCreator2, GNUObjectIdentifiers.Serpent_192_CBC, GNUObjectIdentifiers.Serpent_192_CFB, GNUObjectIdentifiers.Serpent_192_ECB, GNUObjectIdentifiers.Serpent_192_OFB);
        GuardedEngineCreator guardedEngineCreator3 = new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "Serpent", 256, true, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new Serpent.KeyGenerator(256, secureRandom);
                    }
                });
            }
        });
        this.addKeyGeneratorForOIDs(bouncyCastleFipsProvider, PREFIX, guardedEngineCreator3, GNUObjectIdentifiers.Serpent_256_CBC, GNUObjectIdentifiers.Serpent_256_CFB, GNUObjectIdentifiers.Serpent_256_ECB, GNUObjectIdentifiers.Serpent_256_OFB);
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.SERPENT", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new ASN1AlgorithmParameters("Serpent");
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "SERPENT", GNUObjectIdentifiers.Serpent_128_CBC, GNUObjectIdentifiers.Serpent_192_CBC, GNUObjectIdentifiers.Serpent_256_CBC, GNUObjectIdentifiers.Serpent_128_CFB, GNUObjectIdentifiers.Serpent_192_CFB, GNUObjectIdentifiers.Serpent_256_CFB, GNUObjectIdentifiers.Serpent_128_OFB, GNUObjectIdentifiers.Serpent_192_OFB, GNUObjectIdentifiers.Serpent_256_OFB);
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator", GNUObjectIdentifiers.Serpent_128_CBC, PREFIX + "$AlgParamGen", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new IVAlgorithmParameterGenerator(bouncyCastleFipsProvider, "Serpent", 16);
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameterGenerator", GNUObjectIdentifiers.Serpent_128_CBC.getId(), GNUObjectIdentifiers.Serpent_192_CBC, GNUObjectIdentifiers.Serpent_256_CBC, GNUObjectIdentifiers.Serpent_128_CFB, GNUObjectIdentifiers.Serpent_192_CFB, GNUObjectIdentifiers.Serpent_256_CFB, GNUObjectIdentifiers.Serpent_128_OFB, GNUObjectIdentifiers.Serpent_192_OFB, GNUObjectIdentifiers.Serpent_256_OFB);
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.SERPENTGMAC", PREFIX + "$GMAC", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(Serpent.GMAC, (MACOperatorFactory)new Serpent.MACOperatorFactory(), new AuthParametersCreator(Serpent.GMAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "SERPENTGMAC", "SERPENT-GMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.SERPENTCMAC", PREFIX + "$CMAC", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(Serpent.CMAC, (MACOperatorFactory)new Serpent.MACOperatorFactory(), new AuthParametersCreator(Serpent.CMAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "SERPENTCMAC", "SERPENT-CMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.SERPENTCCMMAC", PREFIX + "$SERPENTCCMMAC", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(Serpent.CCM, (MACOperatorFactory)new Serpent.MACOperatorFactory(), new AuthParametersCreator((AuthenticationParametersWithIV)Serpent.CCM.withMACSize(128)));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "SERPENTCCMMAC", "SERPENT-CCMMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.SERPENTKW", PREFIX + "$Wrap", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseWrapCipher.Builder(bouncyCastleFipsProvider, Serpent.KW).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, keyWrapOperatorFactory).withParameters(classArray2).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Cipher", "SERPENTKW", "SERPENTWRAP");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.SERPENTKWP", PREFIX + "$WrapWithPad", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseWrapCipher.Builder(bouncyCastleFipsProvider, Serpent.KWP).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, keyWrapOperatorFactory).withParameters(classArray2).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Cipher", "SERPENTKWP", "SERPENTWRAPPAD");
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.SERPENT", PREFIX + "$SERPENTKFACT", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSecretKeyFactory("Serpent", Serpent.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                        int n = byArray.length * 8;
                        if (n < 32 || n % 32 != 0 || n > 256) {
                            throw new InvalidKeySpecException("Serpent key must be a multiple of 32 bits");
                        }
                        return byArray;
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", GNUObjectIdentifiers.Serpent_128_ECB, PREFIX + "ECB128", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Serpent.ECBwithPKCS7).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, operatorFactory, null).withFixedKeySize(128).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", GNUObjectIdentifiers.Serpent_192_ECB, PREFIX + "ECB192", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Serpent.ECBwithPKCS7).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, operatorFactory, null).withFixedKeySize(192).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", GNUObjectIdentifiers.Serpent_256_ECB, PREFIX + "ECB256", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Serpent.ECBwithPKCS7).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, operatorFactory, null).withFixedKeySize(256).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", GNUObjectIdentifiers.Serpent_128_CBC, PREFIX + "CBC128", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Serpent.CBCwithPKCS7).withParameters(classArray2).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, operatorFactory, null).withFixedKeySize(128).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", GNUObjectIdentifiers.Serpent_192_CBC, PREFIX + "CBC192", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Serpent.CBCwithPKCS7).withParameters(classArray2).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, operatorFactory, null).withFixedKeySize(192).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", GNUObjectIdentifiers.Serpent_256_CBC, PREFIX + "CBC256", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Serpent.CBCwithPKCS7).withParameters(classArray2).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, operatorFactory, null).withFixedKeySize(256).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", GNUObjectIdentifiers.Serpent_128_CFB, PREFIX + "CFB128", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Serpent.CFB128).withParameters(classArray2).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, operatorFactory, null).withFixedKeySize(128).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", GNUObjectIdentifiers.Serpent_192_CFB, PREFIX + "CFB192", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Serpent.CFB128).withParameters(classArray2).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, operatorFactory, null).withFixedKeySize(192).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", GNUObjectIdentifiers.Serpent_256_CFB, PREFIX + "CFB256", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Serpent.CFB128).withParameters(classArray2).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, operatorFactory, null).withFixedKeySize(256).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", GNUObjectIdentifiers.Serpent_128_OFB, PREFIX + "OFB128", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Serpent.OFB).withParameters(classArray2).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, operatorFactory, null).withFixedKeySize(128).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", GNUObjectIdentifiers.Serpent_192_OFB, PREFIX + "OFB192", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Serpent.OFB).withParameters(classArray2).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, operatorFactory, null).withFixedKeySize(192).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", GNUObjectIdentifiers.Serpent_256_OFB, PREFIX + "OFB256", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Serpent.OFB).withParameters(classArray2).withGeneralOperators(ProvSerpent.this.generalParametersCreatorProvider, operatorFactory, null).withFixedKeySize(256).build();
            }
        }));
    }
}

