/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.iana.IANAObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AuthenticationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.SymmetricKeyGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsSHS;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseHMac;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseMessageDigest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseSecretKeyFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.DigestAlgorithmProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.EngineCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.MacParametersCreator;

class ProvSHS {
    private static final BaseSecretKeyFactory.Validator anythingGoesValidator = new BaseSecretKeyFactory.Validator(){

        public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
            return byArray;
        }
    };

    ProvSHS() {
    }

    private static class ParametersCreator
    implements MacParametersCreator {
        private final FipsSHS.AuthParameters algorithm;

        ParametersCreator(FipsSHS.AuthParameters authParameters) {
            this.algorithm = authParameters;
        }

        public AuthenticationParameters getBaseParameters() {
            return this.algorithm;
        }

        public AuthenticationParameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec != null) {
                throw new InvalidAlgorithmParameterException("Unknown AlgorithmParameterSpec found: " + algorithmParameterSpec.getClass().getName());
            }
            return this.getBaseParameters();
        }
    }

    static class SHA1
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA1.class.getName();

        SHA1() {
        }

        void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.SHA-1", PREFIX + "$Digest", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMessageDigest(FipsSHS.SHA1);
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA-1", "SHA1", "SHA");
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA-1", OIWObjectIdentifiers.idSHA1);
            this.addHMACAlgorithm(bouncyCastleFipsProvider, "SHA-1", PREFIX + "$HashMac", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(FipsSHS.Algorithm.SHA1_HMAC, (MacParametersCreator)new ParametersCreator(FipsSHS.SHA1_HMAC));
                }
            }, PREFIX + "$KeyGenerator", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacSHA1", 160, new KeyGeneratorCreator(){

                        public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                            return new FipsSHS.KeyGenerator(FipsSHS.Algorithm.SHA1_HMAC, n, secureRandom);
                        }
                    });
                }
            }, PREFIX + "$SecretKeyFactory", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSecretKeyFactory("HmacSHA1", FipsSHS.Algorithm.SHA1_HMAC, anythingGoesValidator);
                }
            });
            this.addHMACAlias(bouncyCastleFipsProvider, "SHA-1", "HMAC-SHA1", "HMACSHA1", "HMACSHA");
            this.addHMACAlias(bouncyCastleFipsProvider, "SHA-1", PKCSObjectIdentifiers.id_hmacWithSHA1, IANAObjectIdentifiers.hmacSHA1, OIWObjectIdentifiers.idSHA1);
            bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.HMAC128SHA1", PREFIX + "$Hmac128", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(FipsSHS.Algorithm.SHA1_HMAC, (MacParametersCreator)new TruncatedParametersCreator(FipsSHS.SHA1_HMAC, 128));
                }
            });
            bouncyCastleFipsProvider.addAlias("Mac", "HMAC128SHA1", "HMAC128SHA-1");
        }
    }

    static class SHA224
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA224.class.getName();

        SHA224() {
        }

        public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.SHA-224", PREFIX + "$Digest", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMessageDigest(FipsSHS.SHA224);
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA-224", "SHA224");
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA-224", NISTObjectIdentifiers.id_sha224);
            this.addHMACAlgorithm(bouncyCastleFipsProvider, "SHA-224", PREFIX + "$HashMac", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(FipsSHS.Algorithm.SHA224_HMAC, (MacParametersCreator)new ParametersCreator(FipsSHS.SHA224_HMAC));
                }
            }, PREFIX + "$KeyGenerator", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacSHA224", 224, new KeyGeneratorCreator(){

                        public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                            return new FipsSHS.KeyGenerator(FipsSHS.Algorithm.SHA224_HMAC, n, secureRandom);
                        }
                    });
                }
            }, PREFIX + "$SecretKeyFactory", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSecretKeyFactory("HmacSHA224", FipsSHS.Algorithm.SHA224_HMAC, anythingGoesValidator);
                }
            });
            this.addHMACAlias(bouncyCastleFipsProvider, "SHA-224", "HMAC-SHA224", "HMACSHA224");
            this.addHMACAlias(bouncyCastleFipsProvider, "SHA-224", PKCSObjectIdentifiers.id_hmacWithSHA224, NISTObjectIdentifiers.id_sha224);
            bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.HMAC128SHA224", PREFIX + "$Hmac128", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(FipsSHS.Algorithm.SHA224_HMAC, (MacParametersCreator)new TruncatedParametersCreator(FipsSHS.SHA224_HMAC, 128));
                }
            });
            bouncyCastleFipsProvider.addAlias("Mac", "HMAC128SHA224", "HMAC128SHA-224");
        }
    }

    static class SHA256
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA256.class.getName();

        SHA256() {
        }

        public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.SHA-256", PREFIX + "$Digest", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMessageDigest(FipsSHS.SHA256);
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA-256", "SHA256");
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA-256", NISTObjectIdentifiers.id_sha256);
            this.addHMACAlgorithm(bouncyCastleFipsProvider, "SHA-256", PREFIX + "$HashMac", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(FipsSHS.Algorithm.SHA256_HMAC, (MacParametersCreator)new ParametersCreator(FipsSHS.SHA256_HMAC));
                }
            }, PREFIX + "$KeyGenerator", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacSHA256", 256, new KeyGeneratorCreator(){

                        public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                            return new FipsSHS.KeyGenerator(FipsSHS.Algorithm.SHA256_HMAC, n, secureRandom);
                        }
                    });
                }
            }, PREFIX + "$SecretKeyFactory", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSecretKeyFactory("HmacSHA256", FipsSHS.Algorithm.SHA256_HMAC, anythingGoesValidator);
                }
            });
            this.addHMACAlias(bouncyCastleFipsProvider, "SHA-256", "HMAC-SHA256", "HMACSHA256");
            this.addHMACAlias(bouncyCastleFipsProvider, "SHA-256", PKCSObjectIdentifiers.id_hmacWithSHA256, NISTObjectIdentifiers.id_sha256);
            bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.HMAC128SHA256", PREFIX + "$Hmac128", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(FipsSHS.Algorithm.SHA256_HMAC, (MacParametersCreator)new TruncatedParametersCreator(FipsSHS.SHA256_HMAC, 128));
                }
            });
            bouncyCastleFipsProvider.addAlias("Mac", "HMAC128SHA256", "HMAC128SHA-256");
        }
    }

    static class SHA384
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA384.class.getName();

        SHA384() {
        }

        public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.SHA-384", PREFIX + "$Digest", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMessageDigest(FipsSHS.SHA384);
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA-384", "SHA384");
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA-384", NISTObjectIdentifiers.id_sha384);
            this.addHMACAlgorithm(bouncyCastleFipsProvider, "SHA-384", PREFIX + "$HashMac", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(FipsSHS.Algorithm.SHA384_HMAC, (MacParametersCreator)new ParametersCreator(FipsSHS.SHA384_HMAC));
                }
            }, PREFIX + "$KeyGenerator", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacSHA384", 384, new KeyGeneratorCreator(){

                        public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                            return new FipsSHS.KeyGenerator(FipsSHS.Algorithm.SHA384_HMAC, n, secureRandom);
                        }
                    });
                }
            }, PREFIX + "$SecretKeyFactory", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSecretKeyFactory("HmacSHA384", FipsSHS.Algorithm.SHA384_HMAC, anythingGoesValidator);
                }
            });
            this.addHMACAlias(bouncyCastleFipsProvider, "SHA-384", "HMAC-SHA384", "HMACSHA384");
            this.addHMACAlias(bouncyCastleFipsProvider, "SHA-384", PKCSObjectIdentifiers.id_hmacWithSHA384, NISTObjectIdentifiers.id_sha384);
            bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.HMAC256SHA384", PREFIX + "$Hmac256", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(FipsSHS.Algorithm.SHA384_HMAC, (MacParametersCreator)new TruncatedParametersCreator(FipsSHS.SHA384_HMAC, 256));
                }
            });
            bouncyCastleFipsProvider.addAlias("Mac", "HMAC256SHA384", "HMAC256SHA-384");
        }
    }

    static class SHA3_224
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA3_224.class.getName();

        SHA3_224() {
        }

        public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.SHA3-224", PREFIX + "$Digest", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMessageDigest(FipsSHS.SHA3_224);
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA3-224", NISTObjectIdentifiers.id_sha3_224);
        }
    }

    static class SHA3_256
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA3_256.class.getName();

        SHA3_256() {
        }

        public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.SHA3-256", PREFIX + "$Digest", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMessageDigest(FipsSHS.SHA3_256);
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA3-256", NISTObjectIdentifiers.id_sha3_256);
        }
    }

    static class SHA3_384
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA3_384.class.getName();

        SHA3_384() {
        }

        public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.SHA3-384", PREFIX + "$Digest", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMessageDigest(FipsSHS.SHA3_384);
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA3-384", NISTObjectIdentifiers.id_sha3_384);
        }
    }

    static class SHA3_512
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA3_512.class.getName();

        SHA3_512() {
        }

        public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.SHA3-512", PREFIX + "$Digest", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMessageDigest(FipsSHS.SHA3_512);
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA3-512", NISTObjectIdentifiers.id_sha3_512);
        }
    }

    public static class SHA512
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA512.class.getName();

        public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.SHA-512", PREFIX + "$Digest", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMessageDigest(FipsSHS.SHA512);
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA-512", "SHA512");
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA-512", NISTObjectIdentifiers.id_sha512);
            this.addHMACAlgorithm(bouncyCastleFipsProvider, "SHA-512", PREFIX + "$HashMac", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(FipsSHS.Algorithm.SHA512_HMAC, (MacParametersCreator)new ParametersCreator(FipsSHS.SHA512_HMAC));
                }
            }, PREFIX + "$KeyGenerator", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacSHA512", 512, new KeyGeneratorCreator(){

                        public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                            return new FipsSHS.KeyGenerator(FipsSHS.Algorithm.SHA512_HMAC, n, secureRandom);
                        }
                    });
                }
            }, PREFIX + "$SecretKeyFactory", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSecretKeyFactory("HmacSHA512", FipsSHS.Algorithm.SHA512_HMAC, anythingGoesValidator);
                }
            });
            this.addHMACAlias(bouncyCastleFipsProvider, "SHA-512", "HMAC-SHA512", "HMACSHA512");
            this.addHMACAlias(bouncyCastleFipsProvider, "SHA-512", PKCSObjectIdentifiers.id_hmacWithSHA512, NISTObjectIdentifiers.id_sha512);
            bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.HMAC256SHA512", PREFIX + "$HashMac256", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(FipsSHS.Algorithm.SHA512_HMAC, (MacParametersCreator)new TruncatedParametersCreator(FipsSHS.SHA512_HMAC, 256));
                }
            });
            bouncyCastleFipsProvider.addAlias("Mac", "HMAC256SHA512", "HMAC256SHA-512");
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.SHA-512(224)", PREFIX + "$DigestT224", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMessageDigest(FipsSHS.SHA512_224);
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA-512(224)", "SHA512(224)", "SHA-512/224", "SHA512/224");
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA-512(224)", NISTObjectIdentifiers.id_sha512_224);
            bouncyCastleFipsProvider.addAlgorithmImplementation("MessageDigest.SHA-512(256)", PREFIX + "$DigestT256", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseMessageDigest(FipsSHS.SHA512_256);
                }
            });
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA-512(256)", "SHA512(256)", "SHA-512/256", "SHA512/256");
            bouncyCastleFipsProvider.addAlias("MessageDigest", "SHA-512(256)", NISTObjectIdentifiers.id_sha512_256);
            this.addHMACAlgorithm(bouncyCastleFipsProvider, "SHA-512(224)", PREFIX + "$HashMacT224", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(FipsSHS.Algorithm.SHA512_224_HMAC, (MacParametersCreator)new ParametersCreator(FipsSHS.SHA512_224_HMAC));
                }
            }, PREFIX + "$KeyGeneratorT224", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacSHA512(224)", 224, new KeyGeneratorCreator(){

                        public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                            return new FipsSHS.KeyGenerator(FipsSHS.Algorithm.SHA512_224_HMAC, n, secureRandom);
                        }
                    });
                }
            }, PREFIX + "$SecretKeyFactoryT224", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSecretKeyFactory("HmacSHA512(224)", FipsSHS.Algorithm.SHA512_224_HMAC, anythingGoesValidator);
                }
            });
            this.addHMACAlias(bouncyCastleFipsProvider, "SHA-512(224)", "HMAC-SHA512(224)", "HMACSHA512(224)", "HMAC-SHA512/224", "HMACSHA512/224");
            bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.HMAC128SHA512(224)", PREFIX + "$Hmac128_224", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(FipsSHS.Algorithm.SHA512_224_HMAC, (MacParametersCreator)new TruncatedParametersCreator(FipsSHS.SHA512_224_HMAC, 128));
                }
            });
            bouncyCastleFipsProvider.addAlias("Mac", "HMAC128SHA512(224)", "HMAC128SHA-512(224)");
            this.addHMACAlgorithm(bouncyCastleFipsProvider, "SHA-512(256)", PREFIX + "$HashMacT256", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(FipsSHS.Algorithm.SHA512_256_HMAC, (MacParametersCreator)new ParametersCreator(FipsSHS.SHA512_256_HMAC));
                }
            }, PREFIX + "$KeyGeneratorT256", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseKeyGenerator(bouncyCastleFipsProvider, "HmacSHA512(256)", 256, new KeyGeneratorCreator(){

                        public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                            return new FipsSHS.KeyGenerator(FipsSHS.Algorithm.SHA512_256_HMAC, n, secureRandom);
                        }
                    });
                }
            }, PREFIX + "$SecretKeyFactoryT256", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseSecretKeyFactory("HmacSHA512(256)", FipsSHS.Algorithm.SHA512_256_HMAC, anythingGoesValidator);
                }
            });
            this.addHMACAlias(bouncyCastleFipsProvider, "SHA-512(256)", "HMAC-SHA512(256)", "HMACSHA512(256)", "HMAC-SHA512/256", "HMACSHA512/256");
            bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.HMAC128SHA512(256)", PREFIX + "$Hmac128_256", new EngineCreator(){

                public Object createInstance(Object object) {
                    return new BaseHMac(FipsSHS.Algorithm.SHA512_256_HMAC, (MacParametersCreator)new TruncatedParametersCreator(FipsSHS.SHA512_256_HMAC, 128));
                }
            });
            bouncyCastleFipsProvider.addAlias("Mac", "HMAC128SHA512(256)", "HMAC128SHA-512(256)");
        }
    }

    private static class TruncatedParametersCreator
    implements MacParametersCreator {
        private final FipsSHS.AuthParameters algorithm;
        private final int macSizeInBits;

        TruncatedParametersCreator(FipsSHS.AuthParameters authParameters, int n) {
            this.algorithm = authParameters;
            this.macSizeInBits = n;
        }

        public AuthenticationParameters getBaseParameters() {
            return this.algorithm.withMACSize(this.macSizeInBits);
        }

        public AuthenticationParameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            return this.getBaseParameters();
        }
    }
}

