/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.spec.ECPoint;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricECGOST3410PublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.interfaces.ECGOST3410PublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ECUtil;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.GOST3410Util;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ProvKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.ECDomainParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.ECGOST3410PublicKeySpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.GOST3410ParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvECGOST3410PublicKey
implements ECGOST3410PublicKey,
ProvKey<AsymmetricECGOST3410PublicKey> {
    private static final long serialVersionUID = 7026240464295649314L;
    private transient AsymmetricECGOST3410PublicKey baseKey;

    ProvECGOST3410PublicKey(Algorithm algorithm, ECGOST3410PublicKey eCGOST3410PublicKey) {
        GOST3410ParameterSpec<ECDomainParameterSpec> gOST3410ParameterSpec = eCGOST3410PublicKey.getParams();
        this.baseKey = new AsymmetricECGOST3410PublicKey(algorithm, GOST3410Util.convertToECParams(gOST3410ParameterSpec), ECUtil.convertPoint(gOST3410ParameterSpec.getDomainParametersSpec(), eCGOST3410PublicKey.getW()));
    }

    ProvECGOST3410PublicKey(Algorithm algorithm, ECGOST3410PublicKeySpec eCGOST3410PublicKeySpec) {
        GOST3410ParameterSpec<ECDomainParameterSpec> gOST3410ParameterSpec = eCGOST3410PublicKeySpec.getParams();
        this.baseKey = new AsymmetricECGOST3410PublicKey(algorithm, GOST3410Util.convertToECParams(gOST3410ParameterSpec), ECUtil.convertPoint(gOST3410ParameterSpec.getDomainParametersSpec(), eCGOST3410PublicKeySpec.getW()));
    }

    ProvECGOST3410PublicKey(AsymmetricECGOST3410PublicKey asymmetricECGOST3410PublicKey) {
        this.baseKey = asymmetricECGOST3410PublicKey;
    }

    @Override
    public AsymmetricECGOST3410PublicKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return this.baseKey.getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public GOST3410ParameterSpec<ECDomainParameterSpec> getParams() {
        return GOST3410Util.convertToECSpec(this.baseKey.getParameters());
    }

    @Override
    public ECPoint getW() {
        return new ECPoint(this.baseKey.getW().getAffineXCoord().toBigInteger(), this.baseKey.getW().getAffineYCoord().toBigInteger());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Strings.lineSeparator();
        stringBuilder.append("ECGOST3410 Public Key").append(string);
        stringBuilder.append("    X: ").append(this.baseKey.getW().getAffineXCoord().toBigInteger().toString(16)).append(string);
        stringBuilder.append("    Y: ").append(this.baseKey.getW().getAffineYCoord().toBigInteger().toString(16)).append(string);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvECGOST3410PublicKey)) {
            return false;
        }
        ProvECGOST3410PublicKey provECGOST3410PublicKey = (ProvECGOST3410PublicKey)object;
        return this.baseKey.equals(provECGOST3410PublicKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricECGOST3410PublicKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

