/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.util;

import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.EntropySource;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.EntropySourceProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsSecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GeneralSecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr;
    private final boolean _predictionResistant;

    public BasicEntropySourceProvider(SecureRandom secureRandom, boolean bl) {
        this._sr = secureRandom;
        this._predictionResistant = bl;
    }

    public EntropySource get(final int n) {
        return new EntropySource(){

            public boolean isPredictionResistant() {
                return BasicEntropySourceProvider.this._predictionResistant;
            }

            public byte[] getEntropy() {
                if (BasicEntropySourceProvider.this._sr instanceof FipsSecureRandom || BasicEntropySourceProvider.this._sr instanceof GeneralSecureRandom || BasicEntropySourceProvider.this._sr.getProvider() instanceof BouncyCastleFipsProvider) {
                    byte[] byArray = new byte[(n + 7) / 8];
                    BasicEntropySourceProvider.this._sr.nextBytes(byArray);
                    return byArray;
                }
                return BasicEntropySourceProvider.this._sr.generateSeed((n + 7) / 8);
            }

            public int entropySize() {
                return n;
            }
        };
    }
}

