/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params;

import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.CipherParameters;

public class DhParameters
implements CipherParameters {
    private static final int DEFAULT_MINIMUM_LENGTH = 160;
    private final BigInteger g;
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger j;
    private final int m;
    private final int l;

    private static int getDefaultMParam(int n) {
        if (n == 0) {
            return 160;
        }
        return n < 160 ? n : 160;
    }

    public DhParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this(bigInteger, bigInteger2, bigInteger3, DhParameters.getDefaultMParam(0), 0, null);
    }

    public DhParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this(bigInteger, bigInteger2, bigInteger3, 160, 0, bigInteger4);
    }

    public DhParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, int n2, BigInteger bigInteger4) {
        if (n2 != 0) {
            if (n2 > bigInteger.bitLength()) {
                throw new IllegalArgumentException("when l value specified, it must satisfy 2^(l-1) <= p");
            }
            if (n2 < n) {
                throw new IllegalArgumentException("when l value specified, it may not be less than m value");
            }
        }
        this.g = bigInteger2;
        this.p = bigInteger;
        this.q = bigInteger3;
        this.m = n;
        this.l = n2;
        this.j = bigInteger4;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getJ() {
        return this.j;
    }

    public int getM() {
        return this.m;
    }

    public int getL() {
        return this.l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DhParameters) {
            DhParameters dhParameters = (DhParameters)object;
            if (this.getQ() != null ? !this.getQ().equals(dhParameters.getQ()) : dhParameters.getQ() != null) {
                return false;
            }
            return dhParameters.getP().equals(this.p) && dhParameters.getG().equals(this.g);
        }
        return false;
    }

    public int hashCode() {
        int n = this.getP().hashCode();
        n += 37 * this.getG().hashCode();
        return n += 37 * (this.getQ() != null ? this.getQ().hashCode() : 0);
    }
}

