/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.DigestAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.IllegalKeyException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.InvalidCipherTextException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.InvalidSignatureException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.InvalidWrappingException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.KeyUnwrapperUsingSecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.KeyWrapperUsingSecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.OperatorUsingSecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.OutputSignerUsingSecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.OutputSignerWithMessageRecovery;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.OutputVerifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.OutputVerifierWithMessageRecovery;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.PlainInputProcessingException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.RecoveredMessage;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.SingleBlockDecryptor;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.SingleBlockDecryptorUsingSecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.UpdateOutputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricRSAKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricRSAPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricRSAPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsRSA;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsSHS;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsStatus;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.FipsRegister;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GeneralAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GeneralParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GuardedAsymmetricOperatorFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GuardedSignatureOperatorFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.GuardedSignatureWithMessageRecoveryOperatorFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.ISO9796d2PSSSigner;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.ISO9796d2Signer;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Register;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.RsaDigestSigner;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Utils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.X931Signer;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.CipherParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.CryptoException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.DataLengthException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Digest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.PrimeCertaintyCalculator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Signer;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.SignerWithRecovery;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.encodings.OAEPEncoding;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.encodings.PKCS1Encoding;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.io.SignerOutputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.RsaKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.RsaPrivateCrtKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.signers.BaseRsaDigestSigner;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;

public final class RSA {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("RSA", (Enum)Variations.RAW);
    private static final GeneralAlgorithm ALGORITHM_OAEP = new GeneralAlgorithm("RSA/OAEP", (Enum)Variations.OAEP);
    private static final GeneralAlgorithm ALGORITHM_PKCS1v1_5 = new GeneralAlgorithm("RSA/PKCS1V1.5", (Enum)Variations.PKCS1v1_5);
    private static final GeneralAlgorithm ALGORITHM_X931 = new GeneralAlgorithm("RSA/X9.31", (Enum)Variations.X931);
    private static final GeneralAlgorithm ALGORITHM_PSS = new GeneralAlgorithm("RSA/PSS", (Enum)Variations.PSS);
    private static final GeneralAlgorithm ALGORITHM_ISO9796d2 = new GeneralAlgorithm("RSA/ISO9796-2", (Enum)Variations.ISO9796d2);
    private static final GeneralAlgorithm ALGORITHM_ISO9796d2PSS = new GeneralAlgorithm("RSA/ISO9796-2PSS", (Enum)Variations.ISO9796d2PSS);
    public static final RawParameters RAW = new RawParameters();
    public static final ISO9796d2SignatureParameters ISO9796d2 = new ISO9796d2SignatureParameters();
    public static final ISO9796d2PSSSignatureParameters ISO9796d2PSS = new ISO9796d2PSSSignatureParameters();
    public static final OAEPParameters WRAP_OAEP = new OAEPParameters();
    public static final PKCS1v15SignatureParameters PKCS1v1_5 = new PKCS1v15SignatureParameters();
    public static final PKCS1v15Parameters WRAP_PKCS1v1_5 = new PKCS1v15Parameters();
    public static final X931SignatureParameters X931 = new X931SignatureParameters();

    private RSA() {
    }

    private static AsymmetricBlockCipher createCipher(boolean bl, AsymmetricRSAKey asymmetricRSAKey, Parameters parameters, SecureRandom secureRandom) {
        CipherParameters cipherParameters;
        Object object;
        AsymmetricBlockCipher asymmetricBlockCipher = (AsymmetricBlockCipher)FipsRegister.getProvider(FipsRSA.ALGORITHM).createEngine();
        if (!asymmetricRSAKey.canBeUsed(AsymmetricRSAKey.Usage.ENCRYPT_OR_DECRYPT)) {
            throw new IllegalKeyException("Attempt to encrypt/decrypt with RSA modulus already used for sign/verify.");
        }
        if (asymmetricRSAKey instanceof AsymmetricRSAPublicKey) {
            object = (AsymmetricRSAPublicKey)asymmetricRSAKey;
            cipherParameters = new RsaKeyParameters(false, ((AsymmetricRSAKey)object).getModulus(), ((AsymmetricRSAPublicKey)object).getPublicExponent());
        } else {
            object = (AsymmetricRSAPrivateKey)asymmetricRSAKey;
            cipherParameters = RSA.getPrivateKeyParameters((AsymmetricRSAPrivateKey)object);
        }
        if (((GeneralAlgorithm)parameters.getAlgorithm()).equals(ALGORITHM_OAEP)) {
            object = (OAEPParameters)parameters;
            asymmetricBlockCipher = new OAEPEncoding(asymmetricBlockCipher, Register.createDigest(((OAEPParameters)object).digestAlgorithm), Register.createDigest(((OAEPParameters)object).mgfDigestAlgorithm), ((OAEPParameters)object).encodingParams);
        } else if (((GeneralAlgorithm)parameters.getAlgorithm()).equals(ALGORITHM_PKCS1v1_5)) {
            asymmetricBlockCipher = new PKCS1Encoding(asymmetricBlockCipher);
        }
        if (secureRandom != null) {
            cipherParameters = new ParametersWithRandom(cipherParameters, secureRandom);
        }
        asymmetricBlockCipher.init(bl, cipherParameters);
        return asymmetricBlockCipher;
    }

    private static RsaKeyParameters getPrivateKeyParameters(final AsymmetricRSAPrivateKey asymmetricRSAPrivateKey) {
        return AccessController.doPrivileged(new PrivilegedAction<RsaKeyParameters>(){

            @Override
            public RsaKeyParameters run() {
                if (asymmetricRSAPrivateKey.getPublicExponent().equals(BigInteger.ZERO)) {
                    return new RsaKeyParameters(true, asymmetricRSAPrivateKey.getModulus(), asymmetricRSAPrivateKey.getPrivateExponent());
                }
                return new RsaPrivateCrtKeyParameters(asymmetricRSAPrivateKey.getModulus(), asymmetricRSAPrivateKey.getPublicExponent(), asymmetricRSAPrivateKey.getPrivateExponent(), asymmetricRSAPrivateKey.getP(), asymmetricRSAPrivateKey.getQ(), asymmetricRSAPrivateKey.getDP(), asymmetricRSAPrivateKey.getDQ(), asymmetricRSAPrivateKey.getQInv());
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ISO9796d2PSSSignatureParameters
    extends SignatureParameters<ISO9796d2PSSSignatureParameters> {
        private final int saltLength;
        private final byte[] salt;

        ISO9796d2PSSSignatureParameters() {
            this(FipsSHS.Algorithm.SHA1, 20, null);
        }

        private ISO9796d2PSSSignatureParameters(DigestAlgorithm digestAlgorithm) {
            this(digestAlgorithm, Register.createDigest(digestAlgorithm).getDigestSize(), null);
        }

        private ISO9796d2PSSSignatureParameters(DigestAlgorithm digestAlgorithm, int n, byte[] byArray) {
            super(ALGORITHM_ISO9796d2PSS, digestAlgorithm);
            this.saltLength = n;
            this.salt = byArray;
        }

        public ISO9796d2PSSSignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new ISO9796d2PSSSignatureParameters(digestAlgorithm);
        }

        public ISO9796d2PSSSignatureParameters withSaltLength(int n) {
            return new ISO9796d2PSSSignatureParameters(this.getDigestAlgorithm(), n, null);
        }

        public ISO9796d2PSSSignatureParameters withSalt(byte[] byArray) {
            return new ISO9796d2PSSSignatureParameters(this.getDigestAlgorithm(), byArray.length, Arrays.clone(byArray));
        }

        public byte[] getSalt() {
            return Arrays.clone(this.salt);
        }

        public int getSaltLength() {
            return this.saltLength;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ISO9796d2SignatureParameters
    extends SignatureParameters<ISO9796d2SignatureParameters> {
        ISO9796d2SignatureParameters() {
            super(ALGORITHM_ISO9796d2, FipsSHS.Algorithm.SHA1);
        }

        private ISO9796d2SignatureParameters(DigestAlgorithm digestAlgorithm) {
            super(ALGORITHM_ISO9796d2, digestAlgorithm);
        }

        public ISO9796d2SignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new ISO9796d2SignatureParameters(digestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyGenParameters
    extends GeneralParameters<GeneralAlgorithm> {
        private BigInteger publicExponent;
        private int keySize;
        private int certainty;

        public KeyGenParameters(BigInteger bigInteger, int n) {
            this(ALGORITHM, bigInteger, n, PrimeCertaintyCalculator.getDefaultCertainty(n));
        }

        public KeyGenParameters(BigInteger bigInteger, int n, int n2) {
            this(ALGORITHM, bigInteger, n, n2);
        }

        public KeyGenParameters(SignatureParameters signatureParameters, BigInteger bigInteger, int n) {
            this((Algorithm)signatureParameters.getAlgorithm(), bigInteger, n, PrimeCertaintyCalculator.getDefaultCertainty(n));
        }

        public KeyGenParameters(WrapParameters wrapParameters, BigInteger bigInteger, int n) {
            this((Algorithm)wrapParameters.getAlgorithm(), bigInteger, n, PrimeCertaintyCalculator.getDefaultCertainty(n));
        }

        private KeyGenParameters(Algorithm algorithm, BigInteger bigInteger, int n, int n2) {
            super((GeneralAlgorithm)algorithm);
            this.publicExponent = bigInteger;
            this.keySize = n;
            this.certainty = n2;
        }

        public BigInteger getPublicExponent() {
            return this.publicExponent;
        }

        public int getKeySize() {
            return this.keySize;
        }

        public int getCertainty() {
            return this.certainty;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey> {
        private final FipsRSA.KeyPairGenerator kpGen;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom secureRandom) {
            super(keyGenParameters);
            this.kpGen = new FipsRSA.KeyPairGenerator(new FipsRSA.KeyGenParameters(keyGenParameters.publicExponent, keyGenParameters.keySize, keyGenParameters.certainty), secureRandom);
        }

        @Override
        public AsymmetricKeyPair<AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey> doGenerateKeyPair() {
            AsymmetricKeyPair<AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey> asymmetricKeyPair = this.kpGen.generateKeyPair();
            final AsymmetricRSAPublicKey asymmetricRSAPublicKey = asymmetricKeyPair.getPublicKey();
            final AsymmetricRSAPrivateKey asymmetricRSAPrivateKey = asymmetricKeyPair.getPrivateKey();
            final Object t = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            return AccessController.doPrivileged(new PrivilegedAction<AsymmetricKeyPair<AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey>>(){

                @Override
                public AsymmetricKeyPair<AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey> run() {
                    return new AsymmetricKeyPair<AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey>(new AsymmetricRSAPublicKey(t, asymmetricRSAPublicKey.getModulus(), asymmetricRSAPublicKey.getPublicExponent()), new AsymmetricRSAPrivateKey(t, asymmetricRSAPrivateKey.getModulus(), asymmetricRSAPrivateKey.getPublicExponent(), asymmetricRSAPrivateKey.getPrivateExponent(), asymmetricRSAPrivateKey.getP(), asymmetricRSAPrivateKey.getQ(), asymmetricRSAPrivateKey.getDP(), asymmetricRSAPrivateKey.getDQ(), asymmetricRSAPrivateKey.getQInv()));
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyWrapOperatorFactory
    implements net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.KeyWrapOperatorFactory<WrapParameters, AsymmetricRSAKey> {
        public KeyWrapOperatorFactory() {
            FipsStatus.isReady();
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
            }
        }

        @Override
        public KeyWrapperUsingSecureRandom<WrapParameters> createKeyWrapper(AsymmetricRSAKey asymmetricRSAKey, WrapParameters wrapParameters) {
            return new KeyWrapper(asymmetricRSAKey, wrapParameters, null);
        }

        @Override
        public KeyUnwrapperUsingSecureRandom<WrapParameters> createKeyUnwrapper(AsymmetricRSAKey asymmetricRSAKey, WrapParameters wrapParameters) {
            return new KeyUnwrapper(asymmetricRSAKey, wrapParameters, null);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeyUnwrapper
        implements KeyUnwrapperUsingSecureRandom<WrapParameters> {
            private final AsymmetricBlockCipher keyWrapper;
            private final AsymmetricRSAKey key;
            private final WrapParameters parameters;

            public KeyUnwrapper(AsymmetricRSAKey asymmetricRSAKey, WrapParameters wrapParameters, SecureRandom secureRandom) {
                if (!asymmetricRSAKey.canBeUsed(AsymmetricRSAKey.Usage.ENCRYPT_OR_DECRYPT)) {
                    throw new IllegalKeyException("Attempt to encrypt/decrypt with RSA modulus already used for sign/verify.");
                }
                if (!(wrapParameters instanceof Parameters)) {
                    throw new IllegalArgumentException("Unknown parameters object: " + wrapParameters.getClass().getName());
                }
                this.key = asymmetricRSAKey;
                this.parameters = wrapParameters;
                this.keyWrapper = secureRandom != null ? RSA.createCipher(false, asymmetricRSAKey, wrapParameters, secureRandom) : null;
            }

            @Override
            public WrapParameters getParameters() {
                return this.parameters;
            }

            @Override
            public byte[] unwrap(byte[] byArray, int n, int n2) throws InvalidWrappingException {
                if (this.keyWrapper == null) {
                    throw new IllegalStateException("KeyUnwrapper requires a SecureRandom");
                }
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                try {
                    return this.keyWrapper.processBlock(byArray, n, n2);
                }
                catch (Exception exception) {
                    throw new InvalidWrappingException("Unable to unwrap key: " + exception.getMessage(), exception);
                }
            }

            @Override
            public KeyUnwrapperUsingSecureRandom<WrapParameters> withSecureRandom(SecureRandom secureRandom) {
                return new KeyUnwrapper(this.key, this.parameters, secureRandom);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeyWrapper
        implements KeyWrapperUsingSecureRandom<WrapParameters> {
            private final AsymmetricBlockCipher keyWrapper;
            private final AsymmetricRSAKey key;
            private final WrapParameters parameters;

            public KeyWrapper(AsymmetricRSAKey asymmetricRSAKey, WrapParameters wrapParameters, SecureRandom secureRandom) {
                if (!asymmetricRSAKey.canBeUsed(AsymmetricRSAKey.Usage.ENCRYPT_OR_DECRYPT)) {
                    throw new IllegalKeyException("Attempt to encrypt/decrypt with RSA modulus already used for sign/verify.");
                }
                if (wrapParameters == null) {
                    throw new NullPointerException("Null parameters object");
                }
                this.key = asymmetricRSAKey;
                this.parameters = wrapParameters;
                this.keyWrapper = secureRandom != null ? RSA.createCipher(true, asymmetricRSAKey, wrapParameters, secureRandom) : null;
            }

            @Override
            public WrapParameters getParameters() {
                return this.parameters;
            }

            @Override
            public byte[] wrap(byte[] byArray, int n, int n2) throws PlainInputProcessingException {
                if (this.keyWrapper == null) {
                    throw new IllegalStateException("KeyWrapper requires a SecureRandom");
                }
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                try {
                    return this.keyWrapper.processBlock(byArray, n, n2);
                }
                catch (Exception exception) {
                    throw new PlainInputProcessingException("Unable to wrap key: " + exception.getMessage(), exception);
                }
            }

            @Override
            public KeyWrapperUsingSecureRandom<WrapParameters> withSecureRandom(SecureRandom secureRandom) {
                return new KeyWrapper(this.key, this.parameters, secureRandom);
            }
        }
    }

    private static class NullSigner
    implements Signer {
        AsymmetricBlockCipher engine = new PKCS1Encoding((AsymmetricBlockCipher)FipsRegister.getProvider(FipsRSA.ALGORITHM).createEngine());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();

        private NullSigner() {
        }

        public void init(boolean bl, CipherParameters cipherParameters) {
            this.engine.init(bl, cipherParameters);
        }

        public void update(byte by) {
            this.bOut.write(by);
        }

        public void update(byte[] byArray, int n, int n2) {
            this.bOut.write(byArray, n, n2);
        }

        public byte[] generateSignature() throws CryptoException, DataLengthException {
            byte[] byArray = this.bOut.toByteArray();
            this.bOut.reset();
            return this.engine.processBlock(byArray, 0, byArray.length);
        }

        public boolean verifySignature(byte[] byArray) throws InvalidSignatureException {
            byte[] byArray2 = this.bOut.toByteArray();
            this.bOut.reset();
            try {
                byte[] byArray3 = this.engine.processBlock(byArray, 0, byArray.length);
                return BaseRsaDigestSigner.checkPKCS1Sig(byArray2, byArray3);
            }
            catch (net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.InvalidCipherTextException invalidCipherTextException) {
                throw new InvalidSignatureException("Unable to process signature: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
            }
        }

        public void reset() {
            this.bOut = new ByteArrayOutputStream();
        }
    }

    public static final class OAEPParameters
    extends WrapParameters {
        private final DigestAlgorithm digestAlgorithm;
        private final DigestAlgorithm mgfDigestAlgorithm;
        private final byte[] encodingParams;

        OAEPParameters() {
            this(FipsSHS.Algorithm.SHA1, FipsSHS.Algorithm.SHA1, null);
        }

        private OAEPParameters(DigestAlgorithm digestAlgorithm, DigestAlgorithm digestAlgorithm2, byte[] byArray) {
            super(ALGORITHM_OAEP);
            this.digestAlgorithm = digestAlgorithm;
            this.mgfDigestAlgorithm = digestAlgorithm2;
            this.encodingParams = Arrays.clone(byArray);
        }

        public OAEPParameters withDigest(DigestAlgorithm digestAlgorithm) {
            return new OAEPParameters(digestAlgorithm, digestAlgorithm, this.encodingParams);
        }

        public OAEPParameters withMGFDigest(DigestAlgorithm digestAlgorithm) {
            return new OAEPParameters(this.digestAlgorithm, digestAlgorithm, this.encodingParams);
        }

        public OAEPParameters withEncodingParams(byte[] byArray) {
            return new OAEPParameters(this.digestAlgorithm, this.mgfDigestAlgorithm, Arrays.clone(byArray));
        }

        public DigestAlgorithm getDigest() {
            return this.digestAlgorithm;
        }

        public DigestAlgorithm getMGFDigest() {
            return this.mgfDigestAlgorithm;
        }

        public byte[] getEncodingParams() {
            return Arrays.clone(this.encodingParams);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedAsymmetricOperatorFactory<Parameters> {
        @Override
        public SingleBlockDecryptor<Parameters> createBlockDecryptor(AsymmetricKey asymmetricKey, Parameters parameters) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", (Algorithm)parameters.getAlgorithm());
            }
            return new BlockDecryptor(asymmetricKey, parameters, null);
        }

        @Override
        protected AsymmetricBlockCipher createCipher(boolean bl, AsymmetricKey asymmetricKey, Parameters parameters, SecureRandom secureRandom) {
            return RSA.createCipher(bl, (AsymmetricRSAKey)asymmetricKey, parameters, secureRandom);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class BlockDecryptor
        implements SingleBlockDecryptorUsingSecureRandom<Parameters> {
            private final AsymmetricKey key;
            private final Parameters parameters;
            private AsymmetricBlockCipher engine;

            BlockDecryptor(AsymmetricKey asymmetricKey, Parameters parameters, SecureRandom secureRandom) {
                this.key = asymmetricKey;
                this.parameters = parameters;
                if (secureRandom != null) {
                    this.engine = OperatorFactory.this.createCipher(false, asymmetricKey, parameters, secureRandom);
                }
            }

            @Override
            public byte[] decryptBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
                if (this.engine == null) {
                    throw new IllegalStateException("RSA BlockDecryptor requires a SecureRandom");
                }
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                try {
                    Utils.approveModeCheck(this.parameters.getAlgorithm());
                    return this.engine.processBlock(byArray, n, n2);
                }
                catch (Exception exception) {
                    throw new InvalidCipherTextException("Unable to decrypt block: " + exception.getMessage(), exception);
                }
            }

            @Override
            public Parameters getParameters() {
                return this.parameters;
            }

            @Override
            public int getInputSize() {
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                if (this.engine == null) {
                    throw new IllegalStateException("RSA BlockDecryptor requires a SecureRandom");
                }
                if (GuardedAsymmetricOperatorFactory.isRawEngine(this.engine)) {
                    return this.engine.getInputBlockSize() + 1;
                }
                return this.engine.getInputBlockSize();
            }

            @Override
            public int getOutputSize() {
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                if (this.engine == null) {
                    throw new IllegalStateException("RSA BlockDecryptor requires a SecureRandom");
                }
                return this.engine.getOutputBlockSize();
            }

            @Override
            public SingleBlockDecryptorUsingSecureRandom<Parameters> withSecureRandom(SecureRandom secureRandom) {
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                return new BlockDecryptor(this.key, this.parameters, secureRandom);
            }
        }
    }

    public static final class PKCS1v15Parameters
    extends WrapParameters {
        PKCS1v15Parameters() {
            super(ALGORITHM_PKCS1v1_5);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PKCS1v15SignatureParameters
    extends SignatureParameters<PKCS1v15SignatureParameters> {
        PKCS1v15SignatureParameters() {
            super(ALGORITHM_PKCS1v1_5, FipsSHS.Algorithm.SHA1);
        }

        private PKCS1v15SignatureParameters(DigestAlgorithm digestAlgorithm) {
            super(ALGORITHM_PKCS1v1_5, digestAlgorithm);
        }

        public PKCS1v15SignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new PKCS1v15SignatureParameters(digestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Parameters
    extends GeneralParameters<GeneralAlgorithm> {
        Parameters(GeneralAlgorithm generalAlgorithm) {
            super(generalAlgorithm);
        }
    }

    public static final class RawParameters
    extends Parameters {
        RawParameters() {
            super(ALGORITHM);
        }
    }

    private static class RecoveredMessageImpl
    implements RecoveredMessage {
        private final boolean isFullMessage;
        private final byte[] content;

        public RecoveredMessageImpl(boolean bl, byte[] byArray) {
            this.isFullMessage = bl;
            this.content = byArray;
        }

        public byte[] getContent() {
            return Arrays.clone(this.content);
        }

        public boolean isFullMessage() {
            return this.isFullMessage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SignatureOperatorFactory<T extends SignatureParameters>
    extends GuardedSignatureOperatorFactory<T> {
        @Override
        protected OutputSignerUsingSecureRandom<T> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, T t) {
            AsymmetricRSAPrivateKey asymmetricRSAPrivateKey = (AsymmetricRSAPrivateKey)asymmetricPrivateKey;
            if (!asymmetricRSAPrivateKey.canBeUsed(AsymmetricRSAKey.Usage.SIGN_OR_VERIFY)) {
                throw new IllegalKeyException("Attempt to sign/verify with RSA modulus already used for encrypt/decrypt.");
            }
            return new RSASigner(this, t, (CipherParameters)RSA.getPrivateKeyParameters(asymmetricRSAPrivateKey), null);
        }

        private Signer getSigner(SignatureParameters signatureParameters) {
            if (signatureParameters.getAlgorithm() == ALGORITHM_PKCS1v1_5) {
                if (signatureParameters.getDigestAlgorithm() == null) {
                    return new NullSigner();
                }
                return new RsaDigestSigner(Register.createDigest(signatureParameters.digestAlgorithm));
            }
            if (signatureParameters.getAlgorithm() == ALGORITHM_X931) {
                return new X931Signer(Register.createDigest(signatureParameters.digestAlgorithm));
            }
            throw new IllegalArgumentException("Algorithm " + signatureParameters.getAlgorithm().getName() + " not recognized");
        }

        @Override
        public OutputVerifier<T> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, final SignatureParameters signatureParameters) {
            AsymmetricRSAPublicKey asymmetricRSAPublicKey = (AsymmetricRSAPublicKey)asymmetricPublicKey;
            if (!asymmetricRSAPublicKey.canBeUsed(AsymmetricRSAKey.Usage.SIGN_OR_VERIFY)) {
                throw new IllegalKeyException("Attempt to sign/verify with RSA modulus already used for encrypt/decrypt.");
            }
            RsaKeyParameters rsaKeyParameters = new RsaKeyParameters(false, asymmetricRSAPublicKey.getModulus(), asymmetricRSAPublicKey.getPublicExponent());
            final Signer signer = this.getSigner(signatureParameters);
            signer.init(false, rsaKeyParameters);
            return new OutputVerifier<T>(){

                @Override
                public T getParameters() {
                    return signatureParameters;
                }

                @Override
                public UpdateOutputStream getVerifyingStream() {
                    return new SignerOutputStream(signatureParameters.getAlgorithm().getName(), signer);
                }

                @Override
                public boolean isVerified(byte[] byArray) throws InvalidSignatureException {
                    return signer.verifySignature(byArray);
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class RSASigner<P extends SignatureParameters>
        implements OutputSignerUsingSecureRandom<P> {
            private final Signer signer;
            private final CipherParameters keyParameters;
            private final P parameters;
            private SecureRandom random;
            final /* synthetic */ SignatureOperatorFactory this$0;

            RSASigner(P p, CipherParameters cipherParameters, SecureRandom secureRandom) {
                this.this$0 = var1_1;
                this.parameters = p;
                this.keyParameters = cipherParameters;
                this.random = secureRandom;
                this.signer = ((SignatureOperatorFactory)var1_1).getSigner(p);
                if (secureRandom != null) {
                    this.signer.init(true, new ParametersWithRandom(cipherParameters, secureRandom));
                }
            }

            @Override
            public P getParameters() {
                return this.parameters;
            }

            @Override
            public UpdateOutputStream getSigningStream() {
                this.checkInit();
                return new SignerOutputStream(((GeneralParameters)this.parameters).getAlgorithm().getName(), this.signer);
            }

            @Override
            public byte[] getSignature() throws PlainInputProcessingException {
                try {
                    return this.signer.generateSignature();
                }
                catch (Exception exception) {
                    throw new PlainInputProcessingException("Unable to create signature: " + exception.getMessage(), exception);
                }
            }

            @Override
            public OutputSignerUsingSecureRandom<P> withSecureRandom(SecureRandom secureRandom) {
                return new RSASigner(this.this$0, this.parameters, this.keyParameters, secureRandom);
            }

            @Override
            public int getSignature(byte[] byArray, int n) throws PlainInputProcessingException {
                byte[] byArray2 = this.getSignature();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }

            private void checkInit() {
                if (this.random == null) {
                    this.random = CryptoServicesRegistrar.getSecureRandom();
                    this.signer.init(true, new ParametersWithRandom(this.keyParameters, this.random));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SignatureParameters<T extends SignatureParameters>
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        SignatureParameters(GeneralAlgorithm generalAlgorithm, DigestAlgorithm digestAlgorithm) {
            super(generalAlgorithm);
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SignatureWithMessageRecoveryOperatorFactory<T extends SignatureParameters>
    extends GuardedSignatureWithMessageRecoveryOperatorFactory<T> {
        @Override
        protected OutputSignerWithMessageRecovery<T> doCreateSigner(AsymmetricPrivateKey asymmetricPrivateKey, T t) {
            AsymmetricRSAPrivateKey asymmetricRSAPrivateKey = (AsymmetricRSAPrivateKey)asymmetricPrivateKey;
            if (!asymmetricRSAPrivateKey.canBeUsed(AsymmetricRSAKey.Usage.SIGN_OR_VERIFY)) {
                throw new IllegalKeyException("Attempt to sign/verify with RSA modulus already used for encrypt/decrypt.");
            }
            RsaKeyParameters rsaKeyParameters = RSA.getPrivateKeyParameters(asymmetricRSAPrivateKey);
            return new RSASigner(this, t, (CipherParameters)rsaKeyParameters, null);
        }

        @Override
        protected OutputVerifierWithMessageRecovery<T> doCreateVerifier(AsymmetricPublicKey asymmetricPublicKey, final SignatureParameters signatureParameters) {
            AsymmetricRSAPublicKey asymmetricRSAPublicKey = (AsymmetricRSAPublicKey)asymmetricPublicKey;
            if (!asymmetricRSAPublicKey.canBeUsed(AsymmetricRSAKey.Usage.SIGN_OR_VERIFY)) {
                throw new IllegalKeyException("Attempt to sign/verify with RSA modulus already used for encrypt/decrypt.");
            }
            RsaKeyParameters rsaKeyParameters = new RsaKeyParameters(false, asymmetricRSAPublicKey.getModulus(), asymmetricRSAPublicKey.getPublicExponent());
            final SignerWithRecovery signerWithRecovery = this.getSigner(signatureParameters);
            signerWithRecovery.init(false, rsaKeyParameters);
            return new OutputVerifierWithMessageRecovery<T>(){

                @Override
                public T getParameters() {
                    return signatureParameters;
                }

                @Override
                public UpdateOutputStream getVerifyingStream() {
                    return new SignerOutputStream(signatureParameters.getAlgorithm().getName(), signerWithRecovery);
                }

                @Override
                public boolean isVerified(byte[] byArray) throws InvalidSignatureException {
                    return signerWithRecovery.verifySignature(byArray);
                }

                @Override
                public RecoveredMessage getRecoveredMessage() {
                    return new RecoveredMessageImpl(signerWithRecovery.hasFullMessage(), signerWithRecovery.getRecoveredMessage());
                }

                @Override
                public void updateWithRecoveredMessage(byte[] byArray) throws InvalidSignatureException {
                    try {
                        signerWithRecovery.updateWithRecoveredMessage(byArray);
                    }
                    catch (Exception exception) {
                        throw new InvalidSignatureException("Unable to recover message: " + exception.getMessage(), exception);
                    }
                }
            };
        }

        private SignerWithRecovery getSigner(SignatureParameters signatureParameters) {
            if (signatureParameters.getAlgorithm() == ALGORITHM_ISO9796d2) {
                return new ISO9796d2Signer(Register.createDigest(signatureParameters.digestAlgorithm));
            }
            if (signatureParameters.getAlgorithm() == ALGORITHM_ISO9796d2PSS) {
                ISO9796d2PSSSignatureParameters iSO9796d2PSSSignatureParameters = (ISO9796d2PSSSignatureParameters)signatureParameters;
                Digest digest = Register.createDigest(signatureParameters.digestAlgorithm);
                byte[] byArray = iSO9796d2PSSSignatureParameters.getSalt();
                if (byArray != null) {
                    return new ISO9796d2PSSSigner(digest, byArray);
                }
                return new ISO9796d2PSSSigner(digest, iSO9796d2PSSSignatureParameters.getSaltLength());
            }
            throw new IllegalArgumentException("Algorithm " + signatureParameters.getAlgorithm().getName() + " not recognized");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class RSASigner<T extends SignatureParameters>
        implements OutputSignerWithMessageRecovery<T>,
        OperatorUsingSecureRandom<RSASigner<T>> {
            private final SignerWithRecovery signer;
            private final CipherParameters keyParameters;
            private final T parameters;
            private SecureRandom random;
            final /* synthetic */ SignatureWithMessageRecoveryOperatorFactory this$0;

            RSASigner(T t, CipherParameters cipherParameters, SecureRandom secureRandom) {
                this.this$0 = var1_1;
                this.parameters = t;
                this.keyParameters = cipherParameters;
                this.random = secureRandom;
                this.signer = ((SignatureWithMessageRecoveryOperatorFactory)var1_1).getSigner(t);
                if (secureRandom != null) {
                    this.signer.init(true, new ParametersWithRandom(cipherParameters, secureRandom));
                }
            }

            @Override
            public T getParameters() {
                return this.parameters;
            }

            @Override
            public UpdateOutputStream getSigningStream() {
                this.checkInit();
                return new SignerOutputStream(((GeneralParameters)this.parameters).getAlgorithm().getName(), this.signer);
            }

            @Override
            public byte[] getSignature() throws PlainInputProcessingException {
                try {
                    return this.signer.generateSignature();
                }
                catch (Exception exception) {
                    throw new PlainInputProcessingException("Unable to create signature: " + exception.getMessage(), exception);
                }
            }

            @Override
            public int getSignature(byte[] byArray, int n) throws PlainInputProcessingException {
                byte[] byArray2 = this.getSignature();
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                return byArray2.length;
            }

            @Override
            public RecoveredMessage getRecoveredMessage() {
                return new RecoveredMessageImpl(this.signer.hasFullMessage(), this.signer.getRecoveredMessage());
            }

            @Override
            public RSASigner<T> withSecureRandom(SecureRandom secureRandom) {
                return new RSASigner(this.this$0, this.parameters, this.keyParameters, secureRandom);
            }

            private void checkInit() {
                if (this.random == null) {
                    this.random = CryptoServicesRegistrar.getSecureRandom();
                    this.signer.init(true, new ParametersWithRandom(this.keyParameters, this.random));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        RAW,
        PKCS1v1_5,
        PSS,
        X931,
        ISO9796d2,
        ISO9796d2PSS,
        OAEP;

    }

    public static class WrapParameters
    extends Parameters {
        WrapParameters(GeneralAlgorithm generalAlgorithm) {
            super(generalAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class X931SignatureParameters
    extends SignatureParameters<X931SignatureParameters> {
        public X931SignatureParameters() {
            super(ALGORITHM_X931, FipsSHS.Algorithm.SHA1);
        }

        public X931SignatureParameters(DigestAlgorithm digestAlgorithm) {
            super(ALGORITHM_X931, digestAlgorithm);
        }

        public X931SignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new X931SignatureParameters(digestAlgorithm);
        }
    }
}

