/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.OutputSigner;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.OutputVerifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.SignatureOperatorFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsStatus;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GuardedSignatureOperatorFactory<T extends Parameters>
implements SignatureOperatorFactory<T> {
    GuardedSignatureOperatorFactory() {
        FipsStatus.isReady();
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
        }
    }

    @Override
    public final OutputSigner<T> createSigner(AsymmetricPrivateKey asymmetricPrivateKey, T t) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t.getAlgorithm());
        }
        return this.doCreateSigner(asymmetricPrivateKey, t);
    }

    @Override
    public final OutputVerifier<T> createVerifier(AsymmetricPublicKey asymmetricPublicKey, T t) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", t.getAlgorithm());
        }
        return this.doCreateVerifier(asymmetricPublicKey, t);
    }

    protected abstract OutputSigner<T> doCreateSigner(AsymmetricPrivateKey var1, T var2);

    protected abstract OutputVerifier<T> doCreateVerifier(AsymmetricPublicKey var1, T var2);
}

