/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Digest;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DsaParameterGenerationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DsaParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DsaValidationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.internal.Primes;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.BigIntegers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.encoders.Hex;

class DsaParametersGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private Digest digest;
    private int L;
    private int N;
    private int certainty;
    private int iterations;
    private SecureRandom random;
    private int usageIndex;

    public DsaParametersGenerator(Digest digest) {
        this.digest = digest;
    }

    public void init(DsaParameterGenerationParameters dsaParameterGenerationParameters) {
        int n = dsaParameterGenerationParameters.getL();
        int n2 = dsaParameterGenerationParameters.getN();
        if (n < 1024 || n > 3072 || n % 1024 != 0) {
            throw new IllegalArgumentException("L values must be between 1024 and 3072 and a multiple of 1024");
        }
        if (n == 1024 && n2 != 160) {
            throw new IllegalArgumentException("N must be 160 for L = 1024");
        }
        if (n == 2048 && n2 != 224 && n2 != 256) {
            throw new IllegalArgumentException("N must be 224 or 256 for L = 2048");
        }
        if (n == 3072 && n2 != 256) {
            throw new IllegalArgumentException("N must be 256 for L = 3072");
        }
        if (this.digest.getDigestSize() * 8 < n2) {
            throw new IllegalStateException("Digest output size too small for value of N");
        }
        this.L = n;
        this.N = n2;
        this.certainty = dsaParameterGenerationParameters.getCertainty();
        this.iterations = Math.max(DsaParametersGenerator.getMinimumIterations(n), (this.certainty + 1) / 2);
        this.random = dsaParameterGenerationParameters.getRandom();
        this.usageIndex = dsaParameterGenerationParameters.getUsageIndex();
    }

    public DsaParameters generateParameters() {
        return this.generateParameters_FIPS186_3();
    }

    private static BigInteger calculateGenerator_FIPS186_2(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5 = bigInteger.subtract(ONE).divide(bigInteger2);
        BigInteger bigInteger6 = bigInteger.subtract(TWO);
        while ((bigInteger4 = (bigInteger3 = BigIntegers.createRandomInRange(TWO, bigInteger6, secureRandom)).modPow(bigInteger5, bigInteger)).bitLength() <= 1) {
        }
        return bigInteger4;
    }

    /*
     * Unable to fully structure code
     */
    private DsaParameters generateParameters_FIPS186_3() {
        var1_1 = this.digest;
        var2_2 = var1_1.getDigestSize() * 8;
        var3_3 = this.N;
        var4_4 = new byte[var3_3 / 8];
        var5_5 = (this.L - 1) / var2_2;
        var6_6 = (this.L - 1) % var2_2;
        var7_7 = new byte[this.L / 8];
        var8_8 = new byte[var1_1.getDigestSize()];
        block0: while (true) {
            this.random.nextBytes(var4_4);
            DsaParametersGenerator.hash(var1_1, var4_4, var8_8, 0);
            var9_9 = new BigInteger(1, var8_8).mod(DsaParametersGenerator.ONE.shiftLeft(this.N - 1));
            var10_10 = var9_9.setBit(0).setBit(this.N - 1);
            if (!this.isProbablePrime(var10_10)) continue;
            var11_11 = Arrays.clone(var4_4);
            var12_12 = 4 * this.L;
            var13_13 = 0;
            while (true) {
                if (var13_13 < var12_12) ** break;
                continue block0;
                for (var14_15 = 1; var14_15 <= var5_5; ++var14_15) {
                    DsaParametersGenerator.inc(var11_11);
                    DsaParametersGenerator.hash(var1_1, var11_11, var7_7, var7_7.length - var14_15 * var8_8.length);
                }
                var14_15 = var7_7.length - var5_5 * var8_8.length;
                DsaParametersGenerator.inc(var11_11);
                DsaParametersGenerator.hash(var1_1, var11_11, var8_8, 0);
                System.arraycopy(var8_8, var8_8.length - var14_15, var7_7, 0, var14_15);
                var7_7[0] = (byte)(var7_7[0] | -128);
                var14_14 = new BigInteger(1, var7_7);
                var15_16 = var14_14.mod(var10_10.shiftLeft(1));
                var16_17 = var14_14.subtract(var15_16.subtract(DsaParametersGenerator.ONE));
                if (var16_17.bitLength() == this.L && this.isProbablePrime(var16_17)) {
                    if (this.usageIndex >= 0 && (var17_18 = DsaParametersGenerator.calculateGenerator_FIPS186_3_Verifiable(var1_1, var16_17, var10_10, var4_4, this.usageIndex)) != null) {
                        return new DsaParameters(var16_17, var10_10, var17_18, new DsaValidationParameters(var4_4, var13_13, this.usageIndex));
                    }
                    var17_18 = DsaParametersGenerator.calculateGenerator_FIPS186_3_Unverifiable(var16_17, var10_10, this.random);
                    return new DsaParameters(var16_17, var10_10, var17_18, new DsaValidationParameters(var4_4, var13_13));
                }
                ++var13_13;
            }
            break;
        }
    }

    private boolean isProbablePrime(BigInteger bigInteger) {
        return !Primes.hasAnySmallFactors(bigInteger) && Primes.isMRProbablePrime(bigInteger, this.random, this.iterations);
    }

    static BigInteger calculateGenerator_FIPS186_3_Unverifiable(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        return DsaParametersGenerator.calculateGenerator_FIPS186_2(bigInteger, bigInteger2, secureRandom);
    }

    static BigInteger calculateGenerator_FIPS186_3_Verifiable(Digest digest, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n) {
        if ((n & 0xFF) != n) {
            throw new IllegalArgumentException("Usage index must be in range 0 to 255");
        }
        BigInteger bigInteger3 = bigInteger.subtract(ONE).divide(bigInteger2);
        byte[] byArray2 = Hex.decode("6767656E");
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 1 + 2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        byArray3[byArray3.length - 3] = (byte)n;
        byte[] byArray4 = new byte[digest.getDigestSize()];
        for (int i = 1; i < 65536; ++i) {
            DsaParametersGenerator.inc(byArray3);
            DsaParametersGenerator.hash(digest, byArray3, byArray4, 0);
            BigInteger bigInteger4 = new BigInteger(1, byArray4);
            BigInteger bigInteger5 = bigInteger4.modPow(bigInteger3, bigInteger);
            if (bigInteger5.compareTo(TWO) < 0) continue;
            return bigInteger5;
        }
        return null;
    }

    private static void hash(Digest digest, byte[] byArray, byte[] byArray2, int n) {
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray2, n);
    }

    private static int getMinimumIterations(int n) {
        return n <= 1024 ? 40 : 48 + 8 * ((n - 1) / 1024);
    }

    private static void inc(byte[] byArray) {
        for (int i = byArray.length - 1; i >= 0; --i) {
            byte by;
            byArray[i] = by = (byte)(byArray[i] + 1 & 0xFF);
            if (by != 0) break;
        }
    }
}

