/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.AsymmetricCipherKeyPairGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.KeyGenerationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DsaKeyGenerationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DsaParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DsaPrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DsaPublicKeyParameters;

class DsaKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DsaKeyGenerationParameters param;

    DsaKeyPairGenerator() {
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DsaKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DsaParameters dsaParameters = this.param.getParameters();
        BigInteger bigInteger = DsaKeyPairGenerator.generatePrivateKey(dsaParameters.getQ(), this.param.getRandom());
        BigInteger bigInteger2 = DsaKeyPairGenerator.calculatePublicKey(dsaParameters.getP(), dsaParameters.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new DsaPublicKeyParameters(bigInteger2, dsaParameters), new DsaPrivateKeyParameters(bigInteger, dsaParameters));
    }

    private static BigInteger generatePrivateKey(BigInteger bigInteger, SecureRandom secureRandom) {
        BigInteger bigInteger2 = new BigInteger(bigInteger.bitLength() + 64, secureRandom);
        return bigInteger2.mod(bigInteger.subtract(ONE)).add(ONE);
    }

    private static BigInteger calculatePublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger2.modPow(bigInteger3, bigInteger);
    }
}

