/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Encodable;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1OctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERBitString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.sec.ECPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.X962Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.X9ECPoint;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricECKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.KeyUtils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.Permissions;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECPoint;

public final class AsymmetricECPrivateKey
extends AsymmetricECKey
implements AsymmetricPrivateKey {
    private final int hashCode;
    private final byte[] publicKey;
    private BigInteger d;

    public AsymmetricECPrivateKey(Algorithm algorithm, ECDomainParametersID eCDomainParametersID, BigInteger bigInteger) {
        this(algorithm, eCDomainParametersID, bigInteger, null);
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, ECDomainParameters eCDomainParameters, BigInteger bigInteger) {
        this(algorithm, eCDomainParameters, bigInteger, null);
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, ECDomainParameters eCDomainParameters, BigInteger bigInteger, ECPoint eCPoint) {
        super(algorithm, eCDomainParameters);
        this.d = bigInteger;
        this.publicKey = this.extractPublicKeyBytes(eCPoint);
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, ECDomainParametersID eCDomainParametersID, BigInteger bigInteger, ECPoint eCPoint) {
        super(algorithm, eCDomainParametersID);
        this.d = bigInteger;
        this.publicKey = this.extractPublicKeyBytes(eCPoint);
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        this(algorithm, privateKeyInfo.getPrivateKeyAlgorithm(), AsymmetricECPrivateKey.parsePrivateKey(privateKeyInfo));
    }

    private AsymmetricECPrivateKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier, ECPrivateKey eCPrivateKey) {
        super(algorithm, algorithmIdentifier);
        this.d = eCPrivateKey.getKey();
        DERBitString dERBitString = eCPrivateKey.getPublicKey();
        this.publicKey = dERBitString == null ? null : dERBitString.getBytes();
        this.hashCode = this.calculateHashCode();
    }

    private static ECPrivateKey parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            return ECPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to parse EC private key: " + iOException.getMessage(), iOException);
        }
    }

    private byte[] extractPublicKeyBytes(ECPoint eCPoint) {
        this.checkApprovedOnlyModeStatus();
        if (eCPoint == null) {
            return null;
        }
        return ASN1OctetString.getInstance(new X9ECPoint(eCPoint).toASN1Primitive()).getOctets();
    }

    public final byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        X962Parameters x962Parameters = KeyUtils.buildCurveParameters(this.getDomainParameters());
        int n = KeyUtils.getOrderBitLength(this.getDomainParameters());
        ECPrivateKey eCPrivateKey = this.publicKey != null ? new ECPrivateKey(n, this.getS(), new DERBitString(this.publicKey), x962Parameters) : new ECPrivateKey(n, this.getS(), (ASN1Encodable)x962Parameters);
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), eCPrivateKey);
    }

    public BigInteger getS() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        return this.d;
    }

    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricECPrivateKey)) {
            return false;
        }
        AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)object;
        if (!this.d.equals(asymmetricECPrivateKey.d)) {
            return false;
        }
        return this.getDomainParameters().equals(asymmetricECPrivateKey.getDomainParameters());
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n = this.d.hashCode();
        n = 31 * n + this.getDomainParameters().hashCode();
        return n;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.zeroize();
    }

    private void zeroize() {
        this.d = null;
    }
}

