/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric;

import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricECPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.ECDomainParametersIndex;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;

public abstract class AsymmetricECKey
implements AsymmetricKey {
    private final boolean approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
    private final Algorithm algorithm;
    private final ECDomainParameters domainParameters;

    AsymmetricECKey(Algorithm algorithm, ECDomainParameters eCDomainParameters) {
        this.algorithm = algorithm;
        this.domainParameters = eCDomainParameters;
    }

    AsymmetricECKey(Algorithm algorithm, ECDomainParametersID eCDomainParametersID) {
        this(algorithm, ECDomainParametersIndex.lookupDomainParameters(eCDomainParametersID));
    }

    AsymmetricECKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier) {
        this(algorithm, ECDomainParameters.decodeCurveParameters(algorithmIdentifier));
    }

    public final Algorithm getAlgorithm() {
        if (this instanceof AsymmetricECPrivateKey) {
            this.checkApprovedOnlyModeStatus();
        }
        return this.algorithm;
    }

    public final ECDomainParameters getDomainParameters() {
        if (this instanceof AsymmetricECPrivateKey) {
            this.checkApprovedOnlyModeStatus();
        }
        return this.domainParameters;
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (this.approvedModeOnly != CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }
}

