/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1OctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DEROctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410Key;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.KeyUtils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsymmetricECGOST3410PublicKey
extends AsymmetricGOST3410Key<ECDomainParameters>
implements AsymmetricPublicKey {
    private ECPoint w;

    public AsymmetricECGOST3410PublicKey(Algorithm algorithm, GOST3410Parameters<ECDomainParameters> gOST3410Parameters, ECPoint eCPoint) {
        super(algorithm, gOST3410Parameters);
        this.w = KeyUtils.validated(eCPoint);
    }

    public AsymmetricECGOST3410PublicKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, SubjectPublicKeyInfo.getInstance(byArray));
    }

    public AsymmetricECGOST3410PublicKey(Algorithm algorithm, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(algorithm, CryptoProObjectIdentifiers.gostR3410_2001, subjectPublicKeyInfo.getAlgorithm());
        this.w = KeyUtils.validated(this.parsePublicKey(subjectPublicKeyInfo));
    }

    private ECPoint parsePublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        int n;
        ASN1OctetString aSN1OctetString;
        try {
            aSN1OctetString = ASN1OctetString.getInstance(subjectPublicKeyInfo.parsePublicKey());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error recovering public key: " + iOException.getMessage(), iOException);
        }
        byte[] byArray = aSN1OctetString.getOctets();
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        for (n = 0; n != byArray2.length; ++n) {
            byArray2[n] = byArray[31 - n];
        }
        for (n = 0; n != byArray3.length; ++n) {
            byArray3[n] = byArray[63 - n];
        }
        return ((ECDomainParameters)this.getParameters().getDomainParameters()).getCurve().validatePoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    public ECPoint getW() {
        return this.w;
    }

    @Override
    public byte[] getEncoded() {
        BigInteger bigInteger = this.w.getAffineXCoord().toBigInteger();
        BigInteger bigInteger2 = this.w.getAffineYCoord().toBigInteger();
        byte[] byArray = new byte[64];
        this.extractBytes(byArray, 0, bigInteger);
        this.extractBytes(byArray, 32, bigInteger2);
        if (this.getParameters().getPublicKeyParamSet() != null) {
            GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters(this.getParameters().getPublicKeyParamSet(), this.getParameters().getDigestParamSet(), this.getParameters().getEncryptionParamSet());
            return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, gOST3410PublicKeyAlgParameters), new DEROctetString(byArray));
        }
        return KeyUtils.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001), new DEROctetString(byArray));
    }

    private void extractBytes(byte[] byArray, int n, BigInteger bigInteger) {
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length < 32) {
            byte[] byArray3 = new byte[32];
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
            byArray2 = byArray3;
        }
        for (int i = 0; i != 32; ++i) {
            byArray[n + i] = byArray2[byArray2.length - 1 - i];
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricECGOST3410PublicKey)) {
            return false;
        }
        AsymmetricECGOST3410PublicKey asymmetricECGOST3410PublicKey = (AsymmetricECGOST3410PublicKey)object;
        return this.w.equals(asymmetricECGOST3410PublicKey.w) && this.getParameters().equals(asymmetricECGOST3410PublicKey.getParameters());
    }

    @Override
    public int hashCode() {
        int n = this.w.hashCode();
        n = 31 * n + this.getParameters().hashCode();
        return n;
    }
}

