/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Encodable;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Sequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSTypedData;

public class PKCS7ProcessableObject
implements CMSTypedData {
    private final ASN1ObjectIdentifier type;
    private final ASN1Encodable structure;

    public PKCS7ProcessableObject(ASN1ObjectIdentifier type, ASN1Encodable structure) {
        this.type = type;
        this.structure = structure;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.type;
    }

    public void write(OutputStream cOut) throws IOException, CMSException {
        if (this.structure instanceof ASN1Sequence) {
            ASN1Sequence s = ASN1Sequence.getInstance(this.structure);
            for (ASN1Encodable enc : s) {
                cOut.write(enc.toASN1Primitive().getEncoded("DER"));
            }
        } else {
            byte[] encoded = this.structure.toASN1Primitive().getEncoded("DER");
            int index = 1;
            while ((encoded[index] & 0xFF) > 127) {
                ++index;
            }
            cOut.write(encoded, ++index, encoded.length - index);
        }
    }

    public Object getContent() {
        return this.structure;
    }
}

