/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.cms;

import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DEROctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.RecipientIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.RecipientInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.RecipientInfoGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.AsymmetricKeyWrapper;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.GenericKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.OperatorException;

public abstract class KeyTransRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final AsymmetricKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KeyTransRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerial, AsymmetricKeyWrapper wrapper) {
        this.issuerAndSerial = issuerAndSerial;
        this.wrapper = wrapper;
    }

    protected KeyTransRecipientInfoGenerator(byte[] subjectKeyIdentifier, AsymmetricKeyWrapper wrapper) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.wrapper = wrapper;
    }

    public final RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        byte[] encryptedKeyBytes;
        try {
            encryptedKeyBytes = this.wrapper.generateWrappedKey(contentEncryptionKey);
        }
        catch (OperatorException e) {
            throw new CMSException("exception wrapping content key: " + e.getMessage(), e);
        }
        RecipientIdentifier recipId = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        return new RecipientInfo(new KeyTransRecipientInfo(recipId, this.wrapper.getAlgorithmIdentifier(), new DEROctetString(encryptedKeyBytes)));
    }
}

