/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1OctetStringParser;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1SequenceParser;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.CompressedDataParser;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.cms.ContentInfoParser;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSContentInfoParser;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.cms.CMSTypedStream;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.InputExpander;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.InputExpanderProvider;

public class CMSCompressedDataParser
extends CMSContentInfoParser {
    public CMSCompressedDataParser(byte[] compressedData) throws CMSException {
        this(new ByteArrayInputStream(compressedData));
    }

    public CMSCompressedDataParser(InputStream compressedData) throws CMSException {
        super(compressedData);
    }

    public CMSTypedStream getContent(InputExpanderProvider expanderProvider) throws CMSException {
        try {
            CompressedDataParser comData = new CompressedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
            ContentInfoParser content = comData.getEncapContentInfo();
            InputExpander expander = expanderProvider.get(comData.getCompressionAlgorithmIdentifier());
            ASN1OctetStringParser bytes = (ASN1OctetStringParser)content.getContent(4);
            return new CMSTypedStream(content.getContentType().getId(), expander.getInputStream(bytes.getOctetStream()));
        }
        catch (IOException e) {
            throw new CMSException("IOException reading compressed content.", e);
        }
    }
}

