/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.FBSerializable;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.MessageSerializer;
import net.snowflake.client.jdbc.internal.google.flatbuffers.FlatBufferBuilder;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteChannel
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteChannel.class);
    private long currentPosition = 0L;
    private final WritableByteChannel out;

    public WriteChannel(WritableByteChannel out) {
        this.out = out;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public long getCurrentPosition() {
        return this.currentPosition;
    }

    public long write(byte[] buffer) throws IOException {
        return this.write(ByteBuffer.wrap(buffer));
    }

    public long writeZeros(int zeroCount) throws IOException {
        return this.write(new byte[zeroCount]);
    }

    public long align() throws IOException {
        if (this.currentPosition % 8L != 0L) {
            return this.writeZeros(8 - (int)(this.currentPosition % 8L));
        }
        return 0L;
    }

    public long write(ByteBuffer buffer) throws IOException {
        long length = buffer.remaining();
        LOGGER.debug("Writing buffer with size: {}", (Object)length);
        while (buffer.hasRemaining()) {
            this.out.write(buffer);
        }
        this.currentPosition += length;
        return length;
    }

    public long writeIntLittleEndian(int v) throws IOException {
        byte[] outBuffer = new byte[4];
        MessageSerializer.intToBytes(v, outBuffer);
        return this.write(outBuffer);
    }

    public void write(ArrowBuf buffer) throws IOException {
        ByteBuffer nioBuffer = buffer.nioBuffer(buffer.readerIndex(), buffer.readableBytes());
        this.write(nioBuffer);
    }

    public long write(FBSerializable writer, boolean withSizePrefix) throws IOException {
        ByteBuffer buffer = WriteChannel.serialize(writer);
        if (withSizePrefix) {
            this.writeIntLittleEndian(buffer.remaining());
        }
        return this.write(buffer);
    }

    public static ByteBuffer serialize(FBSerializable writer) {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        int root = writer.writeTo(builder);
        builder.finish(root);
        return builder.dataBuffer();
    }
}

