/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadChannel
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadChannel.class);
    private ReadableByteChannel in;
    private long bytesRead = 0L;

    public ReadChannel(ReadableByteChannel in) {
        this.in = in;
    }

    public long bytesRead() {
        return this.bytesRead;
    }

    public int readFully(ByteBuffer buffer) throws IOException {
        LOGGER.debug("Reading buffer with size: {}", (Object)buffer.remaining());
        int totalRead = 0;
        while (buffer.remaining() != 0) {
            int read = this.in.read(buffer);
            if (read < 0) {
                return totalRead;
            }
            totalRead += read;
            if (read != 0) continue;
            break;
        }
        this.bytesRead += (long)totalRead;
        return totalRead;
    }

    public int readFully(ArrowBuf buffer, int l) throws IOException {
        int n = this.readFully(buffer.nioBuffer(buffer.writerIndex(), l));
        buffer.writerIndex(n);
        return n;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }
}

