/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BaseAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.OutOfMemoryException;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Collections2;
import net.snowflake.client.jdbc.internal.apache.arrow.util.Preconditions;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BufferBacked;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DateDayVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.DateMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Float4Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.Float8Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntervalDayVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntervalYearVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.SmallIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeMicroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeNanoVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeSecVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMicroVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampMilliVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampNanoVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TimeStampSecVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.TinyIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt1Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt2Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt4Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.UInt8Vector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VarBinaryVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VarCharVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.ListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.NonNullableStructVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.StructVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.ComplexCopier;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UnionReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.UnionWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.FieldWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.ComplexHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableBigIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableBitHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableDateDayHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableDateMilliHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableFloat4Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableFloat8Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableIntervalDayHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableIntervalYearHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableSmallIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeMicroHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeMilliHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeNanoHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeSecHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampMicroHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampMilliHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampNanoHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTimeStampSecHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableTinyIntHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableUInt1Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableUInt2Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableUInt4Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableUInt8Holder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableVarBinaryHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableVarCharHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.UnionHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ipc.message.ArrowFieldNode;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.UnionMode;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.CallBack;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.OversizedAllocationException;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;
import net.snowflake.client.jdbc.internal.io.netty.buffer.ArrowBuf;

public class UnionVector
implements FieldVector {
    private String name;
    private BufferAllocator allocator;
    int valueCount;
    NonNullableStructVector internalStruct;
    protected ArrowBuf typeBuffer;
    private StructVector structVector;
    private ListVector listVector;
    private FieldReader reader;
    private int singleType = 0;
    private ValueVector singleVector;
    private static final byte TYPE_WIDTH = 1;
    private final CallBack callBack;
    private int typeBufferAllocationSizeInBytes;
    private TinyIntVector tinyIntVector;
    private UInt1Vector uInt1Vector;
    private UInt2Vector uInt2Vector;
    private SmallIntVector smallIntVector;
    private IntVector intVector;
    private UInt4Vector uInt4Vector;
    private Float4Vector float4Vector;
    private DateDayVector dateDayVector;
    private IntervalYearVector intervalYearVector;
    private TimeSecVector timeSecVector;
    private TimeMilliVector timeMilliVector;
    private BigIntVector bigIntVector;
    private UInt8Vector uInt8Vector;
    private Float8Vector float8Vector;
    private DateMilliVector dateMilliVector;
    private TimeStampSecVector timeStampSecVector;
    private TimeStampMilliVector timeStampMilliVector;
    private TimeStampMicroVector timeStampMicroVector;
    private TimeStampNanoVector timeStampNanoVector;
    private TimeMicroVector timeMicroVector;
    private TimeNanoVector timeNanoVector;
    private IntervalDayVector intervalDayVector;
    private VarBinaryVector varBinaryVector;
    private VarCharVector varCharVector;
    private BitVector bitVector;
    UnionWriter writer;

    public UnionVector(String name, BufferAllocator allocator, CallBack callBack) {
        this.name = name;
        this.allocator = allocator;
        this.internalStruct = new NonNullableStructVector("internal", allocator, new FieldType(false, ArrowType.Struct.INSTANCE, null, null), callBack);
        this.typeBuffer = allocator.getEmpty();
        this.callBack = callBack;
        this.typeBufferAllocationSizeInBytes = 3970;
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.UNION;
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        this.internalStruct.initializeChildrenFromFields(children);
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return this.internalStruct.getChildrenFromFields();
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        if (ownBuffers.size() != 1) {
            throw new IllegalArgumentException("Illegal buffer count, expected 1, got: " + ownBuffers.size());
        }
        ArrowBuf buffer = ownBuffers.get(0);
        this.typeBuffer.release();
        this.typeBuffer = buffer.retain(this.allocator);
        this.typeBufferAllocationSizeInBytes = this.typeBuffer.capacity();
        this.valueCount = fieldNode.getLength();
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        ArrayList<ArrowBuf> result = new ArrayList<ArrowBuf>(1);
        this.setReaderAndWriterIndex();
        result.add(this.typeBuffer);
        return result;
    }

    private void setReaderAndWriterIndex() {
        this.typeBuffer.readerIndex(0);
        this.typeBuffer.writerIndex(this.valueCount * 1);
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use geFieldBuffers");
    }

    private String fieldName(Types.MinorType type) {
        return type.name().toLowerCase();
    }

    private FieldType fieldType(Types.MinorType type) {
        return FieldType.nullable(type.getType());
    }

    private <T extends FieldVector> T addOrGet(Types.MinorType minorType, Class<T> c) {
        return this.internalStruct.addOrGet(this.fieldName(minorType), this.fieldType(minorType), c);
    }

    @Override
    public long getValidityBufferAddress() {
        return this.typeBuffer.memoryAddress();
    }

    @Override
    public long getDataBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getOffsetBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        return this.typeBuffer;
    }

    @Override
    public ArrowBuf getDataBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        throw new UnsupportedOperationException();
    }

    public StructVector getStruct() {
        if (this.structVector == null) {
            int vectorCount = this.internalStruct.size();
            this.structVector = this.addOrGet(Types.MinorType.STRUCT, StructVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.structVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.structVector;
    }

    public TinyIntVector getTinyIntVector() {
        if (this.tinyIntVector == null) {
            int vectorCount = this.internalStruct.size();
            this.tinyIntVector = this.addOrGet(Types.MinorType.TINYINT, TinyIntVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.tinyIntVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.tinyIntVector;
    }

    public UInt1Vector getUInt1Vector() {
        if (this.uInt1Vector == null) {
            int vectorCount = this.internalStruct.size();
            this.uInt1Vector = this.addOrGet(Types.MinorType.UINT1, UInt1Vector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.uInt1Vector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.uInt1Vector;
    }

    public UInt2Vector getUInt2Vector() {
        if (this.uInt2Vector == null) {
            int vectorCount = this.internalStruct.size();
            this.uInt2Vector = this.addOrGet(Types.MinorType.UINT2, UInt2Vector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.uInt2Vector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.uInt2Vector;
    }

    public SmallIntVector getSmallIntVector() {
        if (this.smallIntVector == null) {
            int vectorCount = this.internalStruct.size();
            this.smallIntVector = this.addOrGet(Types.MinorType.SMALLINT, SmallIntVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.smallIntVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.smallIntVector;
    }

    public IntVector getIntVector() {
        if (this.intVector == null) {
            int vectorCount = this.internalStruct.size();
            this.intVector = this.addOrGet(Types.MinorType.INT, IntVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.intVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.intVector;
    }

    public UInt4Vector getUInt4Vector() {
        if (this.uInt4Vector == null) {
            int vectorCount = this.internalStruct.size();
            this.uInt4Vector = this.addOrGet(Types.MinorType.UINT4, UInt4Vector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.uInt4Vector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.uInt4Vector;
    }

    public Float4Vector getFloat4Vector() {
        if (this.float4Vector == null) {
            int vectorCount = this.internalStruct.size();
            this.float4Vector = this.addOrGet(Types.MinorType.FLOAT4, Float4Vector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.float4Vector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.float4Vector;
    }

    public DateDayVector getDateDayVector() {
        if (this.dateDayVector == null) {
            int vectorCount = this.internalStruct.size();
            this.dateDayVector = this.addOrGet(Types.MinorType.DATEDAY, DateDayVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.dateDayVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.dateDayVector;
    }

    public IntervalYearVector getIntervalYearVector() {
        if (this.intervalYearVector == null) {
            int vectorCount = this.internalStruct.size();
            this.intervalYearVector = this.addOrGet(Types.MinorType.INTERVALYEAR, IntervalYearVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.intervalYearVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.intervalYearVector;
    }

    public TimeSecVector getTimeSecVector() {
        if (this.timeSecVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeSecVector = this.addOrGet(Types.MinorType.TIMESEC, TimeSecVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeSecVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeSecVector;
    }

    public TimeMilliVector getTimeMilliVector() {
        if (this.timeMilliVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeMilliVector = this.addOrGet(Types.MinorType.TIMEMILLI, TimeMilliVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeMilliVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeMilliVector;
    }

    public BigIntVector getBigIntVector() {
        if (this.bigIntVector == null) {
            int vectorCount = this.internalStruct.size();
            this.bigIntVector = this.addOrGet(Types.MinorType.BIGINT, BigIntVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.bigIntVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.bigIntVector;
    }

    public UInt8Vector getUInt8Vector() {
        if (this.uInt8Vector == null) {
            int vectorCount = this.internalStruct.size();
            this.uInt8Vector = this.addOrGet(Types.MinorType.UINT8, UInt8Vector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.uInt8Vector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.uInt8Vector;
    }

    public Float8Vector getFloat8Vector() {
        if (this.float8Vector == null) {
            int vectorCount = this.internalStruct.size();
            this.float8Vector = this.addOrGet(Types.MinorType.FLOAT8, Float8Vector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.float8Vector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.float8Vector;
    }

    public DateMilliVector getDateMilliVector() {
        if (this.dateMilliVector == null) {
            int vectorCount = this.internalStruct.size();
            this.dateMilliVector = this.addOrGet(Types.MinorType.DATEMILLI, DateMilliVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.dateMilliVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.dateMilliVector;
    }

    public TimeStampSecVector getTimeStampSecVector() {
        if (this.timeStampSecVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeStampSecVector = this.addOrGet(Types.MinorType.TIMESTAMPSEC, TimeStampSecVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeStampSecVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeStampSecVector;
    }

    public TimeStampMilliVector getTimeStampMilliVector() {
        if (this.timeStampMilliVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeStampMilliVector = this.addOrGet(Types.MinorType.TIMESTAMPMILLI, TimeStampMilliVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeStampMilliVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeStampMilliVector;
    }

    public TimeStampMicroVector getTimeStampMicroVector() {
        if (this.timeStampMicroVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeStampMicroVector = this.addOrGet(Types.MinorType.TIMESTAMPMICRO, TimeStampMicroVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeStampMicroVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeStampMicroVector;
    }

    public TimeStampNanoVector getTimeStampNanoVector() {
        if (this.timeStampNanoVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeStampNanoVector = this.addOrGet(Types.MinorType.TIMESTAMPNANO, TimeStampNanoVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeStampNanoVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeStampNanoVector;
    }

    public TimeMicroVector getTimeMicroVector() {
        if (this.timeMicroVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeMicroVector = this.addOrGet(Types.MinorType.TIMEMICRO, TimeMicroVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeMicroVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeMicroVector;
    }

    public TimeNanoVector getTimeNanoVector() {
        if (this.timeNanoVector == null) {
            int vectorCount = this.internalStruct.size();
            this.timeNanoVector = this.addOrGet(Types.MinorType.TIMENANO, TimeNanoVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.timeNanoVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.timeNanoVector;
    }

    public IntervalDayVector getIntervalDayVector() {
        if (this.intervalDayVector == null) {
            int vectorCount = this.internalStruct.size();
            this.intervalDayVector = this.addOrGet(Types.MinorType.INTERVALDAY, IntervalDayVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.intervalDayVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.intervalDayVector;
    }

    public VarBinaryVector getVarBinaryVector() {
        if (this.varBinaryVector == null) {
            int vectorCount = this.internalStruct.size();
            this.varBinaryVector = this.addOrGet(Types.MinorType.VARBINARY, VarBinaryVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.varBinaryVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.varBinaryVector;
    }

    public VarCharVector getVarCharVector() {
        if (this.varCharVector == null) {
            int vectorCount = this.internalStruct.size();
            this.varCharVector = this.addOrGet(Types.MinorType.VARCHAR, VarCharVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.varCharVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.varCharVector;
    }

    public BitVector getBitVector() {
        if (this.bitVector == null) {
            int vectorCount = this.internalStruct.size();
            this.bitVector = this.addOrGet(Types.MinorType.BIT, BitVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.bitVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.bitVector;
    }

    public ListVector getList() {
        if (this.listVector == null) {
            int vectorCount = this.internalStruct.size();
            this.listVector = this.addOrGet(Types.MinorType.LIST, ListVector.class);
            if (this.internalStruct.size() > vectorCount) {
                this.listVector.allocateNew();
                if (this.callBack != null) {
                    this.callBack.doWork();
                }
            }
        }
        return this.listVector;
    }

    public int getTypeValue(int index) {
        return this.typeBuffer.getByte(index * 1);
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        this.clear();
        this.internalStruct.allocateNew();
        try {
            this.allocateTypeBuffer();
        }
        catch (Exception e) {
            this.clear();
            throw e;
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.clear();
        boolean safe = this.internalStruct.allocateNewSafe();
        if (!safe) {
            return false;
        }
        try {
            this.allocateTypeBuffer();
        }
        catch (Exception e) {
            this.clear();
            return false;
        }
        return true;
    }

    private void allocateTypeBuffer() {
        this.typeBuffer = this.allocator.buffer(this.typeBufferAllocationSizeInBytes);
        this.typeBuffer.readerIndex(0);
        this.typeBuffer.setZero(0, this.typeBuffer.capacity());
    }

    @Override
    public void reAlloc() {
        this.internalStruct.reAlloc();
        this.reallocTypeBuffer();
    }

    private void reallocTypeBuffer() {
        long baseSize = this.typeBufferAllocationSizeInBytes;
        int currentBufferCapacity = this.typeBuffer.capacity();
        if (baseSize < (long)currentBufferCapacity) {
            baseSize = currentBufferCapacity;
        }
        long newAllocationSize = baseSize * 2L;
        newAllocationSize = BaseAllocator.nextPowerOfTwo(newAllocationSize);
        assert (newAllocationSize >= 1L);
        if (newAllocationSize > (long)BaseValueVector.MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Unable to expand the buffer");
        }
        ArrowBuf newBuf = this.allocator.buffer((int)newAllocationSize);
        newBuf.setBytes(0, this.typeBuffer, 0, currentBufferCapacity);
        newBuf.setZero(currentBufferCapacity, newBuf.capacity() - currentBufferCapacity);
        this.typeBuffer.release(1);
        this.typeBuffer = newBuf;
        this.typeBufferAllocationSizeInBytes = (int)newAllocationSize;
    }

    @Override
    public void setInitialCapacity(int numRecords) {
    }

    @Override
    public int getValueCapacity() {
        return Math.min(this.getTypeBufferValueCapacity(), this.internalStruct.getValueCapacity());
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        this.valueCount = 0;
        this.typeBuffer.release();
        this.typeBuffer = this.allocator.getEmpty();
        this.internalStruct.clear();
    }

    @Override
    public void reset() {
        this.valueCount = 0;
        this.typeBuffer.setZero(0, this.typeBuffer.capacity());
        this.internalStruct.reset();
    }

    @Override
    public Field getField() {
        ArrayList<Field> childFields = new ArrayList<Field>();
        List<FieldVector> children = this.internalStruct.getChildren();
        int[] typeIds = new int[children.size()];
        for (ValueVector valueVector : children) {
            typeIds[childFields.size()] = valueVector.getMinorType().ordinal();
            childFields.add(valueVector.getField());
        }
        return new Field(this.name, FieldType.nullable(new ArrowType.Union(UnionMode.Sparse, typeIds)), childFields);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return this.getTransferPair(this.name, allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return this.getTransferPair(ref, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return new TransferImpl(ref, allocator, callBack);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return new TransferImpl((UnionVector)target);
    }

    public void copyFrom(int inIndex, int outIndex, UnionVector from) {
        from.getReader().setPosition(inIndex);
        this.getWriter().setPosition(outIndex);
        ComplexCopier.copy(from.reader, this.writer);
    }

    public void copyFromSafe(int inIndex, int outIndex, UnionVector from) {
        this.copyFrom(inIndex, outIndex, from);
    }

    public FieldVector addVector(FieldVector v) {
        String name = v.getMinorType().name().toLowerCase();
        Preconditions.checkState(this.internalStruct.getChild(name) == null, String.format("%s vector already exists", name));
        Object newVector = this.internalStruct.addOrGet(name, v.getField().getFieldType(), v.getClass());
        v.makeTransferPair((ValueVector)newVector).transfer();
        this.internalStruct.putChild(name, (FieldVector)newVector);
        if (this.callBack != null) {
            this.callBack.doWork();
        }
        return newVector;
    }

    @Override
    public FieldReader getReader() {
        if (this.reader == null) {
            this.reader = new UnionReader(this);
        }
        return this.reader;
    }

    public FieldWriter getWriter() {
        if (this.writer == null) {
            this.writer = new UnionWriter(this);
        }
        return this.writer;
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.valueCount * 1 + this.internalStruct.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        long bufferSize = 0L;
        for (ValueVector v : this) {
            bufferSize += (long)v.getBufferSizeFor(valueCount);
        }
        return (int)bufferSize + valueCount * 1;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        ArrayList<ArrowBuf> list = new ArrayList<ArrowBuf>();
        this.setReaderAndWriterIndex();
        if (this.getBufferSize() != 0) {
            list.add(this.typeBuffer);
            list.addAll(Arrays.asList(this.internalStruct.getBuffers(clear)));
        }
        if (clear) {
            this.valueCount = 0;
            this.typeBuffer.retain();
            this.typeBuffer.release();
            this.typeBuffer = this.allocator.getEmpty();
        }
        return list.toArray(new ArrowBuf[list.size()]);
    }

    @Override
    public Iterator<ValueVector> iterator() {
        List<ValueVector> vectors = Collections2.toList(this.internalStruct.iterator());
        return vectors.iterator();
    }

    @Override
    public Object getObject(int index) {
        byte type = this.typeBuffer.getByte(index * 1);
        switch (Types.MinorType.values()[type]) {
            case NULL: {
                return null;
            }
            case TINYINT: {
                return this.getTinyIntVector().getObject(index);
            }
            case UINT1: {
                return this.getUInt1Vector().getObject(index);
            }
            case UINT2: {
                return this.getUInt2Vector().getObject(index);
            }
            case SMALLINT: {
                return this.getSmallIntVector().getObject(index);
            }
            case INT: {
                return this.getIntVector().getObject(index);
            }
            case UINT4: {
                return this.getUInt4Vector().getObject(index);
            }
            case FLOAT4: {
                return this.getFloat4Vector().getObject(index);
            }
            case DATEDAY: {
                return this.getDateDayVector().getObject(index);
            }
            case INTERVALYEAR: {
                return this.getIntervalYearVector().getObject(index);
            }
            case TIMESEC: {
                return this.getTimeSecVector().getObject(index);
            }
            case TIMEMILLI: {
                return this.getTimeMilliVector().getObject(index);
            }
            case BIGINT: {
                return this.getBigIntVector().getObject(index);
            }
            case UINT8: {
                return this.getUInt8Vector().getObject(index);
            }
            case FLOAT8: {
                return this.getFloat8Vector().getObject(index);
            }
            case DATEMILLI: {
                return this.getDateMilliVector().getObject(index);
            }
            case TIMESTAMPSEC: {
                return this.getTimeStampSecVector().getObject(index);
            }
            case TIMESTAMPMILLI: {
                return this.getTimeStampMilliVector().getObject(index);
            }
            case TIMESTAMPMICRO: {
                return this.getTimeStampMicroVector().getObject(index);
            }
            case TIMESTAMPNANO: {
                return this.getTimeStampNanoVector().getObject(index);
            }
            case TIMEMICRO: {
                return this.getTimeMicroVector().getObject(index);
            }
            case TIMENANO: {
                return this.getTimeNanoVector().getObject(index);
            }
            case INTERVALDAY: {
                return this.getIntervalDayVector().getObject(index);
            }
            case VARBINARY: {
                return this.getVarBinaryVector().getObject(index);
            }
            case VARCHAR: {
                return this.getVarCharVector().getObject(index);
            }
            case BIT: {
                return this.getBitVector().getObject(index);
            }
            case STRUCT: {
                return this.getStruct().getObject(index);
            }
            case LIST: {
                return this.getList().getObject(index);
            }
        }
        throw new UnsupportedOperationException("Cannot support type: " + (Object)((Object)Types.MinorType.values()[type]));
    }

    public byte[] get(int index) {
        return null;
    }

    public void get(int index, ComplexHolder holder) {
    }

    public void get(int index, UnionHolder holder) {
        UnionReader reader = new UnionReader(this);
        reader.setPosition(index);
        holder.reader = reader;
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public boolean isNull(int index) {
        return this.typeBuffer.getByte(index * 1) == 0;
    }

    @Override
    public int getNullCount() {
        int nullCount = 0;
        for (int i = 0; i < this.getValueCount(); ++i) {
            if (!this.isNull(i)) continue;
            ++nullCount;
        }
        return nullCount;
    }

    public int isSet(int index) {
        return this.isNull(index) ? 0 : 1;
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
        while (valueCount > this.getTypeBufferValueCapacity()) {
            this.reallocTypeBuffer();
        }
        this.internalStruct.setValueCount(valueCount);
    }

    public void setSafe(int index, UnionHolder holder) {
        FieldReader reader = holder.reader;
        if (this.writer == null) {
            this.writer = new UnionWriter(this);
        }
        this.writer.setPosition(index);
        Types.MinorType type = reader.getMinorType();
        switch (type) {
            case TINYINT: {
                NullableTinyIntHolder tinyIntHolder = new NullableTinyIntHolder();
                reader.read(tinyIntHolder);
                this.setSafe(index, tinyIntHolder);
                break;
            }
            case UINT1: {
                NullableUInt1Holder uInt1Holder = new NullableUInt1Holder();
                reader.read(uInt1Holder);
                this.setSafe(index, uInt1Holder);
                break;
            }
            case UINT2: {
                NullableUInt2Holder uInt2Holder = new NullableUInt2Holder();
                reader.read(uInt2Holder);
                this.setSafe(index, uInt2Holder);
                break;
            }
            case SMALLINT: {
                NullableSmallIntHolder smallIntHolder = new NullableSmallIntHolder();
                reader.read(smallIntHolder);
                this.setSafe(index, smallIntHolder);
                break;
            }
            case INT: {
                NullableIntHolder intHolder = new NullableIntHolder();
                reader.read(intHolder);
                this.setSafe(index, intHolder);
                break;
            }
            case UINT4: {
                NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
                reader.read(uInt4Holder);
                this.setSafe(index, uInt4Holder);
                break;
            }
            case FLOAT4: {
                NullableFloat4Holder float4Holder = new NullableFloat4Holder();
                reader.read(float4Holder);
                this.setSafe(index, float4Holder);
                break;
            }
            case DATEDAY: {
                NullableDateDayHolder dateDayHolder = new NullableDateDayHolder();
                reader.read(dateDayHolder);
                this.setSafe(index, dateDayHolder);
                break;
            }
            case INTERVALYEAR: {
                NullableIntervalYearHolder intervalYearHolder = new NullableIntervalYearHolder();
                reader.read(intervalYearHolder);
                this.setSafe(index, intervalYearHolder);
                break;
            }
            case TIMESEC: {
                NullableTimeSecHolder timeSecHolder = new NullableTimeSecHolder();
                reader.read(timeSecHolder);
                this.setSafe(index, timeSecHolder);
                break;
            }
            case TIMEMILLI: {
                NullableTimeMilliHolder timeMilliHolder = new NullableTimeMilliHolder();
                reader.read(timeMilliHolder);
                this.setSafe(index, timeMilliHolder);
                break;
            }
            case BIGINT: {
                NullableBigIntHolder bigIntHolder = new NullableBigIntHolder();
                reader.read(bigIntHolder);
                this.setSafe(index, bigIntHolder);
                break;
            }
            case UINT8: {
                NullableUInt8Holder uInt8Holder = new NullableUInt8Holder();
                reader.read(uInt8Holder);
                this.setSafe(index, uInt8Holder);
                break;
            }
            case FLOAT8: {
                NullableFloat8Holder float8Holder = new NullableFloat8Holder();
                reader.read(float8Holder);
                this.setSafe(index, float8Holder);
                break;
            }
            case DATEMILLI: {
                NullableDateMilliHolder dateMilliHolder = new NullableDateMilliHolder();
                reader.read(dateMilliHolder);
                this.setSafe(index, dateMilliHolder);
                break;
            }
            case TIMESTAMPSEC: {
                NullableTimeStampSecHolder timeStampSecHolder = new NullableTimeStampSecHolder();
                reader.read(timeStampSecHolder);
                this.setSafe(index, timeStampSecHolder);
                break;
            }
            case TIMESTAMPMILLI: {
                NullableTimeStampMilliHolder timeStampMilliHolder = new NullableTimeStampMilliHolder();
                reader.read(timeStampMilliHolder);
                this.setSafe(index, timeStampMilliHolder);
                break;
            }
            case TIMESTAMPMICRO: {
                NullableTimeStampMicroHolder timeStampMicroHolder = new NullableTimeStampMicroHolder();
                reader.read(timeStampMicroHolder);
                this.setSafe(index, timeStampMicroHolder);
                break;
            }
            case TIMESTAMPNANO: {
                NullableTimeStampNanoHolder timeStampNanoHolder = new NullableTimeStampNanoHolder();
                reader.read(timeStampNanoHolder);
                this.setSafe(index, timeStampNanoHolder);
                break;
            }
            case TIMEMICRO: {
                NullableTimeMicroHolder timeMicroHolder = new NullableTimeMicroHolder();
                reader.read(timeMicroHolder);
                this.setSafe(index, timeMicroHolder);
                break;
            }
            case TIMENANO: {
                NullableTimeNanoHolder timeNanoHolder = new NullableTimeNanoHolder();
                reader.read(timeNanoHolder);
                this.setSafe(index, timeNanoHolder);
                break;
            }
            case INTERVALDAY: {
                NullableIntervalDayHolder intervalDayHolder = new NullableIntervalDayHolder();
                reader.read(intervalDayHolder);
                this.setSafe(index, intervalDayHolder);
                break;
            }
            case VARBINARY: {
                NullableVarBinaryHolder varBinaryHolder = new NullableVarBinaryHolder();
                reader.read(varBinaryHolder);
                this.setSafe(index, varBinaryHolder);
                break;
            }
            case VARCHAR: {
                NullableVarCharHolder varCharHolder = new NullableVarCharHolder();
                reader.read(varCharHolder);
                this.setSafe(index, varCharHolder);
                break;
            }
            case BIT: {
                NullableBitHolder bitHolder = new NullableBitHolder();
                reader.read(bitHolder);
                this.setSafe(index, bitHolder);
                break;
            }
            case STRUCT: {
                ComplexCopier.copy(reader, this.writer);
                break;
            }
            case LIST: {
                ComplexCopier.copy(reader, this.writer);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void setSafe(int index, NullableTinyIntHolder holder) {
        this.setType(index, Types.MinorType.TINYINT);
        this.getTinyIntVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableUInt1Holder holder) {
        this.setType(index, Types.MinorType.UINT1);
        this.getUInt1Vector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableUInt2Holder holder) {
        this.setType(index, Types.MinorType.UINT2);
        this.getUInt2Vector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableSmallIntHolder holder) {
        this.setType(index, Types.MinorType.SMALLINT);
        this.getSmallIntVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableIntHolder holder) {
        this.setType(index, Types.MinorType.INT);
        this.getIntVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableUInt4Holder holder) {
        this.setType(index, Types.MinorType.UINT4);
        this.getUInt4Vector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableFloat4Holder holder) {
        this.setType(index, Types.MinorType.FLOAT4);
        this.getFloat4Vector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableDateDayHolder holder) {
        this.setType(index, Types.MinorType.DATEDAY);
        this.getDateDayVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableIntervalYearHolder holder) {
        this.setType(index, Types.MinorType.INTERVALYEAR);
        this.getIntervalYearVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeSecHolder holder) {
        this.setType(index, Types.MinorType.TIMESEC);
        this.getTimeSecVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeMilliHolder holder) {
        this.setType(index, Types.MinorType.TIMEMILLI);
        this.getTimeMilliVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableBigIntHolder holder) {
        this.setType(index, Types.MinorType.BIGINT);
        this.getBigIntVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableUInt8Holder holder) {
        this.setType(index, Types.MinorType.UINT8);
        this.getUInt8Vector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableFloat8Holder holder) {
        this.setType(index, Types.MinorType.FLOAT8);
        this.getFloat8Vector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableDateMilliHolder holder) {
        this.setType(index, Types.MinorType.DATEMILLI);
        this.getDateMilliVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeStampSecHolder holder) {
        this.setType(index, Types.MinorType.TIMESTAMPSEC);
        this.getTimeStampSecVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeStampMilliHolder holder) {
        this.setType(index, Types.MinorType.TIMESTAMPMILLI);
        this.getTimeStampMilliVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeStampMicroHolder holder) {
        this.setType(index, Types.MinorType.TIMESTAMPMICRO);
        this.getTimeStampMicroVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeStampNanoHolder holder) {
        this.setType(index, Types.MinorType.TIMESTAMPNANO);
        this.getTimeStampNanoVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeMicroHolder holder) {
        this.setType(index, Types.MinorType.TIMEMICRO);
        this.getTimeMicroVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableTimeNanoHolder holder) {
        this.setType(index, Types.MinorType.TIMENANO);
        this.getTimeNanoVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableIntervalDayHolder holder) {
        this.setType(index, Types.MinorType.INTERVALDAY);
        this.getIntervalDayVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableVarBinaryHolder holder) {
        this.setType(index, Types.MinorType.VARBINARY);
        this.getVarBinaryVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableVarCharHolder holder) {
        this.setType(index, Types.MinorType.VARCHAR);
        this.getVarCharVector().setSafe(index, holder);
    }

    public void setSafe(int index, NullableBitHolder holder) {
        this.setType(index, Types.MinorType.BIT);
        this.getBitVector().setSafe(index, holder);
    }

    public void setType(int index, Types.MinorType type) {
        while (index >= this.getTypeBufferValueCapacity()) {
            this.reallocTypeBuffer();
        }
        this.typeBuffer.setByte(index * 1, (byte)type.ordinal());
    }

    private int getTypeBufferValueCapacity() {
        return (int)((double)this.typeBuffer.capacity() * 1.0 / 1.0);
    }

    private class TransferImpl
    implements TransferPair {
        private final TransferPair internalStructVectorTransferPair;
        private final UnionVector to;

        public TransferImpl(String name, BufferAllocator allocator, CallBack callBack) {
            this.to = new UnionVector(name, allocator, callBack);
            this.internalStructVectorTransferPair = UnionVector.this.internalStruct.makeTransferPair(this.to.internalStruct);
        }

        public TransferImpl(UnionVector to) {
            this.to = to;
            this.internalStructVectorTransferPair = UnionVector.this.internalStruct.makeTransferPair(to.internalStruct);
        }

        @Override
        public void transfer() {
            this.to.clear();
            this.to.typeBuffer = UnionVector.this.typeBuffer.transferOwnership((BufferAllocator)((UnionVector)this.to).allocator).buffer;
            this.internalStructVectorTransferPair.transfer();
            this.to.valueCount = UnionVector.this.valueCount;
            UnionVector.this.clear();
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            this.to.clear();
            this.internalStructVectorTransferPair.splitAndTransfer(startIndex, length);
            int startPoint = startIndex * 1;
            int sliceLength = length * 1;
            this.to.typeBuffer = UnionVector.this.typeBuffer.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)((UnionVector)this.to).allocator).buffer;
            this.to.setValueCount(length);
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int from, int to) {
            this.to.copyFrom(from, to, UnionVector.this);
        }
    }
}

