/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.util.AutoCloseables;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Schema;

public class VectorSchemaRoot
implements AutoCloseable {
    private final Schema schema;
    private int rowCount;
    private final List<FieldVector> fieldVectors;
    private final Map<String, FieldVector> fieldVectorsMap = new HashMap<String, FieldVector>();

    public VectorSchemaRoot(Iterable<FieldVector> vectors) {
        this(StreamSupport.stream(vectors.spliterator(), false).map(t -> t.getField()).collect(Collectors.toList()), StreamSupport.stream(vectors.spliterator(), false).collect(Collectors.toList()), 0);
    }

    public VectorSchemaRoot(FieldVector parent) {
        this(parent.getField().getChildren(), parent.getChildrenFromFields(), parent.getValueCount());
    }

    public VectorSchemaRoot(List<Field> fields, List<FieldVector> fieldVectors, int rowCount) {
        this(new Schema(fields), fieldVectors, rowCount);
    }

    public VectorSchemaRoot(Schema schema, List<FieldVector> fieldVectors, int rowCount) {
        if (schema.getFields().size() != fieldVectors.size()) {
            throw new IllegalArgumentException("Fields must match field vectors. Found " + fieldVectors.size() + " vectors and " + schema.getFields().size() + " fields");
        }
        this.schema = schema;
        this.rowCount = rowCount;
        this.fieldVectors = fieldVectors;
        for (int i = 0; i < schema.getFields().size(); ++i) {
            Field field = schema.getFields().get(i);
            FieldVector vector = fieldVectors.get(i);
            this.fieldVectorsMap.put(field.getName(), vector);
        }
    }

    public static VectorSchemaRoot create(Schema schema, BufferAllocator allocator) {
        ArrayList<FieldVector> fieldVectors = new ArrayList<FieldVector>();
        for (Field field : schema.getFields()) {
            FieldVector vector = field.createVector(allocator);
            fieldVectors.add(vector);
        }
        if (fieldVectors.size() != schema.getFields().size()) {
            throw new IllegalArgumentException("The root vector did not create the right number of children. found " + fieldVectors.size() + " expected " + schema.getFields().size());
        }
        return new VectorSchemaRoot(schema, fieldVectors, 0);
    }

    public static VectorSchemaRoot of(FieldVector ... vectors) {
        return new VectorSchemaRoot(Arrays.stream(vectors).collect(Collectors.toList()));
    }

    public void allocateNew() {
        for (FieldVector v : this.fieldVectors) {
            v.allocateNew();
        }
    }

    public void clear() {
        for (FieldVector v : this.fieldVectors) {
            v.clear();
        }
    }

    public List<FieldVector> getFieldVectors() {
        return this.fieldVectors.stream().collect(Collectors.toList());
    }

    public FieldVector getVector(String name) {
        return this.fieldVectorsMap.get(name);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
        for (FieldVector v : this.getFieldVectors()) {
            v.setValueCount(rowCount);
        }
    }

    @Override
    public void close() {
        try {
            AutoCloseables.close(this.fieldVectors);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void printRow(StringBuilder sb, List<Object> row) {
        boolean first = true;
        for (Object v : row) {
            if (first) {
                first = false;
            } else {
                sb.append("\t");
            }
            sb.append(v);
        }
        sb.append("\n");
    }

    public String contentToTSVString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> row = new ArrayList<Object>(this.schema.getFields().size());
        for (Field field : this.schema.getFields()) {
            row.add(field.getName());
        }
        this.printRow(sb, row);
        for (int i = 0; i < this.rowCount; ++i) {
            row.clear();
            for (FieldVector v : this.fieldVectors) {
                row.add(v.getObject(i));
            }
            this.printRow(sb, row);
        }
        return sb.toString();
    }
}

