/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import java.time.Period;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseFixedWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.IntervalYearReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.IntervalYearHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableIntervalYearHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;

public class IntervalYearVector
extends BaseFixedWidthVector {
    private static final byte TYPE_WIDTH = 4;
    private final FieldReader reader = new IntervalYearReaderImpl(this);

    public IntervalYearVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.INTERVALYEAR.getType()), allocator);
    }

    public IntervalYearVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, allocator, fieldType, 4);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.INTERVALYEAR;
    }

    public int get(int index) throws IllegalStateException {
        if (this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getInt(index * 4);
    }

    public void get(int index, NullableIntervalYearHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getInt(index * 4);
    }

    @Override
    public Period getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        int interval = this.valueBuffer.getInt(index * 4);
        return Period.ofMonths(interval);
    }

    public StringBuilder getAsStringBuilder(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.getAsStringBuilderHelper(index);
    }

    private StringBuilder getAsStringBuilderHelper(int index) {
        int value = this.valueBuffer.getInt(index * 4);
        int years = value / 12;
        int months = value % 12;
        String yearString = Math.abs(years) == 1 ? " year " : " years ";
        String monthString = Math.abs(months) == 1 ? " month " : " months ";
        return new StringBuilder().append(years).append(yearString).append(months).append(monthString);
    }

    public void copyFrom(int fromIndex, int thisIndex, IntervalYearVector from) {
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        int value = from.valueBuffer.getInt(fromIndex * 4);
        this.valueBuffer.setInt(thisIndex * 4, value);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, IntervalYearVector from) {
        this.handleSafe(thisIndex);
        this.copyFrom(fromIndex, thisIndex, from);
    }

    private void setValue(int index, int value) {
        this.valueBuffer.setInt(index * 4, value);
    }

    public void set(int index, int value) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableIntervalYearHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void set(int index, IntervalYearHolder holder) {
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, int value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableIntervalYearHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, IntervalYearHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setNull(int index) {
        this.handleSafe(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
    }

    public void set(int index, int isSet, int value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.setValidityBit(this.validityBuffer, index, 0);
        }
    }

    public void setSafe(int index, int isSet, int value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((IntervalYearVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        IntervalYearVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new IntervalYearVector(ref, IntervalYearVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(IntervalYearVector to) {
            this.to = to;
        }

        @Override
        public IntervalYearVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            IntervalYearVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            IntervalYearVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, IntervalYearVector.this);
        }
    }
}

