/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;

public class BigIntToTimeConverter
extends AbstractArrowVectorConverter {
    private BigIntVector bigIntVector;

    public BigIntToTimeConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.TIME.name(), fieldVector, columnIndex, context);
        this.bigIntVector = (BigIntVector)fieldVector;
    }

    private SFTime toSFTime(int index) {
        long val = this.bigIntVector.getDataBuffer().getLong(index * 8);
        return SFTime.fromFractionalSeconds(val, this.context.getScale(this.columnIndex));
    }

    @Override
    public Time toTime(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        SFTime sfTime = this.toSFTime(index);
        if (sfTime == null) {
            return null;
        }
        return new Time(sfTime.getFractionalSeconds(3));
    }

    @Override
    public String toString(int index) throws SFException {
        if (this.context.getTimeFormatter() == null) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(this.context.getSession(), new SFException(ErrorCode.INTERNAL_ERROR, "missing time formatter"), null, null);
        }
        return this.isNull(index) ? null : ResultUtil.getSFTimeAsString(this.toSFTime(index), this.context.getScale(this.columnIndex), this.context.getTimeFormatter());
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.isNull(index) ? null : this.toTime(index);
    }

    @Override
    public Timestamp toTimestamp(int index, TimeZone tz) throws SFException {
        return this.isNull(index) ? null : new Timestamp(this.toTime(index).getTime());
    }
}

