/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.snowflake.common.core;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import net.snowflake.client.jdbc.internal.snowflake.common.core.CalendarCache;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;
import net.snowflake.client.jdbc.internal.snowflake.common.util.TimeUtil;

public class SnowflakeDateTimeFormat {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private final String sqlFormat;
    private boolean automaticParsing;
    public boolean epochAutoScale = true;
    private List<Fragment> fragments;
    private SimpleDateFormat simpleDateFormat;
    private int fractionsLen = -1;
    private int fractionsPos = -1;
    private boolean fractionsWithDot = false;
    private SimpleDateFormat fractionsPreFormatter;
    private SimpleDateFormat timezonePreFormatter;
    private ElementType timezoneElementType;
    private boolean has2digitYear = false;
    private final int type;
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int TIMESTAMP = 3;
    private static final SnowflakeDateTimeFormat[] acceptedFormats = new SnowflakeDateTimeFormat[]{new SnowflakeDateTimeFormat("YYYY-MM-DD\"T\"HH24:MI:SS.FFTZH:TZM", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD HH24:MI:SS.FFTZH:TZM", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD HH24:MI:SS.FFTZH", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD HH24:MI:SS.FF TZH:TZM", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD HH24:MI:SS.FF TZHTZM", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD HH24:MI:SS TZH:TZM", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD HH24:MI:SS TZHTZM", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD\"T\"HH24:MI:SS.FF", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD HH24:MI:SS.FF", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD\"T\"HH24:MI:SS", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD HH24:MI:SS", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD\"T\"HH24:MI", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD HH24:MI", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD\"T\"HH24", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD HH24", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD", 3), new SnowflakeDateTimeFormat("DD-MON-YYYY", 3), new SnowflakeDateTimeFormat("MM/DD/YYYY", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD\"T\"HH24:MI:SSTZH:TZM", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD HH24:MI:SSTZH:TZM", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD HH24:MI:SSTZH", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD\"T\"HH24:MITZH:TZM", 3), new SnowflakeDateTimeFormat("YYYY-MM-DD HH24:MITZH:TZM", 3), new SnowflakeDateTimeFormat("DY, DD MON YYYY HH24:MI:SS TZHTZM", 3), new SnowflakeDateTimeFormat("DY, DD MON YYYY HH24:MI:SS.FF TZHTZM", 3), new SnowflakeDateTimeFormat("DY, DD MON YYYY HH12:MI:SS AM TZHTZM", 3), new SnowflakeDateTimeFormat("DY, DD MON YYYY HH12:MI:SS.FF AM TZHTZM", 3), new SnowflakeDateTimeFormat("DY, DD MON YYYY HH24:MI:SS", 3), new SnowflakeDateTimeFormat("DY, DD MON YYYY HH24:MI:SS.FF", 3), new SnowflakeDateTimeFormat("DY, DD MON YYYY HH12:MI:SS AM", 3), new SnowflakeDateTimeFormat("DY, DD MON YYYY HH12:MI:SS.FF AM", 3), new SnowflakeDateTimeFormat("DY MON DD HH24:MI:SS TZHTZM YYYY", 3), new SnowflakeDateTimeFormat("MM/DD/YYYY HH24:MI:SS", 3), new SnowflakeDateTimeFormat("HH24:MI:SS.FFTZH:TZM", 2), new SnowflakeDateTimeFormat("HH24:MI:SS.FF", 2), new SnowflakeDateTimeFormat("HH12:MI:SS.FF AM", 2), new SnowflakeDateTimeFormat("HH24:MI:SS", 2), new SnowflakeDateTimeFormat("HH12:MI:SS AM", 2), new SnowflakeDateTimeFormat("HH24:MI", 2), new SnowflakeDateTimeFormat("HH12:MI AM", 2)};

    public SnowflakeDateTimeFormat(String sqlFormat) {
        this(sqlFormat, 3);
    }

    public SnowflakeDateTimeFormat(String sqlFormat, int type) {
        if (sqlFormat != null && sqlFormat.length() > 1024) {
            throw new IllegalArgumentException("timestamp format too long");
        }
        this.type = type;
        this.sqlFormat = sqlFormat;
        this.fragments = new ArrayList<Fragment>();
        if (sqlFormat.compareToIgnoreCase("auto") == 0) {
            this.automaticParsing = true;
        } else {
            this.automaticParsing = false;
            this.compile(sqlFormat);
            if (this.fragments.size() == 0) {
                this.simpleDateFormat = new SimpleDateFormat("");
            } else {
                assert (this.fragments.size() == 1);
                this.simpleDateFormat = new SimpleDateFormat(this.toSimpleDateTimePattern());
            }
        }
    }

    public String getSqlFormat() {
        return this.sqlFormat;
    }

    private void createNewFragment(String javaTimestampFormat, List<ElementType> elementTypes) {
        this.fragments.add(new Fragment(javaTimestampFormat, elementTypes));
    }

    private int addElement(ElementType element, StringBuilder javaTimestampFormat, List<ElementType> elementTypes) {
        javaTimestampFormat.append(element.getJavaFormat());
        elementTypes.add(element);
        return element.getSqlFormat().length();
    }

    private void addRawChar(StringBuilder stringFormat, char charToAdd) {
        int curSize = stringFormat.length();
        if (charToAdd == '\'') {
            stringFormat.append("''");
        } else if (curSize > 2 && stringFormat.charAt(curSize - 1) == '\'' && stringFormat.charAt(curSize - 2) != '\'') {
            if (this.fractionsPos == curSize) {
                --this.fractionsPos;
            }
            stringFormat.deleteCharAt(curSize - 1);
            stringFormat.append(charToAdd).append('\'');
        } else {
            stringFormat.append('\'').append(charToAdd).append('\'');
        }
    }

    private void compile(String sqlTimestampFormat) {
        StringBuilder javaTimestampFormat = new StringBuilder();
        ArrayList<ElementType> elementTypes = new ArrayList<ElementType>();
        int idx = 0;
        String formatUpperCase = sqlTimestampFormat.toUpperCase();
        block13: while (idx < formatUpperCase.length()) {
            switch (formatUpperCase.charAt(idx)) {
                case 'A': {
                    if (formatUpperCase.substring(idx).startsWith(ElementType.Ante_Meridiem_ElementType.getSqlFormat())) {
                        idx += this.addElement(ElementType.Ante_Meridiem_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    this.addRawChar(javaTimestampFormat, sqlTimestampFormat.charAt(idx++));
                    continue block13;
                }
                case 'D': {
                    if (formatUpperCase.substring(idx).startsWith(ElementType.DayOfMonth_ElementType.getSqlFormat())) {
                        idx += this.addElement(ElementType.DayOfMonth_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    if (formatUpperCase.substring(idx).startsWith(ElementType.DayOfWeekAbbrev_ElementType.getSqlFormat())) {
                        idx += this.addElement(ElementType.DayOfWeekAbbrev_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    this.addRawChar(javaTimestampFormat, sqlTimestampFormat.charAt(idx++));
                    continue block13;
                }
                case 'H': {
                    if (formatUpperCase.substring(idx).startsWith(ElementType.Hour24_ElementType.getSqlFormat())) {
                        idx += this.addElement(ElementType.Hour24_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    if (formatUpperCase.substring(idx).startsWith(ElementType.Hour12_ElementType.getSqlFormat())) {
                        idx += this.addElement(ElementType.Hour12_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    if (formatUpperCase.substring(idx).startsWith(ElementType.Hour_ElementType.getSqlFormat())) {
                        idx += this.addElement(ElementType.Hour_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    this.addRawChar(javaTimestampFormat, sqlTimestampFormat.charAt(idx++));
                    continue block13;
                }
                case 'M': {
                    if (formatUpperCase.substring(idx).startsWith(ElementType.Month_ElementType.getSqlFormat())) {
                        idx += this.addElement(ElementType.Month_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    if (formatUpperCase.substring(idx).startsWith(ElementType.Minute_ElementType.getSqlFormat())) {
                        idx += this.addElement(ElementType.Minute_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    if (formatUpperCase.substring(idx).startsWith(ElementType.MonthAbbrev_ElementType.getSqlFormat())) {
                        idx += this.addElement(ElementType.MonthAbbrev_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    this.addRawChar(javaTimestampFormat, sqlTimestampFormat.charAt(idx++));
                    continue block13;
                }
                case 'P': {
                    if (formatUpperCase.substring(idx).startsWith(ElementType.Post_Meridiem_ElementType.getSqlFormat())) {
                        idx += this.addElement(ElementType.Post_Meridiem_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    this.addRawChar(javaTimestampFormat, sqlTimestampFormat.charAt(idx++));
                    continue block13;
                }
                case 'S': {
                    if (formatUpperCase.substring(idx).startsWith(ElementType.Second_ElementType.getSqlFormat())) {
                        idx += this.addElement(ElementType.Second_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    this.addRawChar(javaTimestampFormat, sqlTimestampFormat.charAt(idx++));
                    continue block13;
                }
                case 'T': {
                    if (formatUpperCase.substring(idx).startsWith(ElementType.TZOffsetHourColonMin_ElementType.getSqlFormat())) {
                        this.timezonePreFormatter = new SimpleDateFormat(javaTimestampFormat.toString());
                        this.timezoneElementType = ElementType.TZOffsetHourColonMin_ElementType;
                        idx += this.addElement(ElementType.TZOffsetHourColonMin_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    if (formatUpperCase.substring(idx).startsWith(ElementType.TZOffsetHourMin_ElementType.getSqlFormat())) {
                        this.timezonePreFormatter = new SimpleDateFormat(javaTimestampFormat.toString());
                        this.timezoneElementType = ElementType.TZOffsetHourMin_ElementType;
                        idx += this.addElement(ElementType.TZOffsetHourMin_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    if (formatUpperCase.substring(idx).startsWith(ElementType.TZOffsetHourOnly_ElementType.getSqlFormat())) {
                        this.timezonePreFormatter = new SimpleDateFormat(javaTimestampFormat.toString());
                        this.timezoneElementType = ElementType.TZOffsetHourOnly_ElementType;
                        idx += this.addElement(ElementType.TZOffsetHourOnly_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    if (formatUpperCase.substring(idx).startsWith(ElementType.TZAbbr_ElementType.getSqlFormat())) {
                        this.timezonePreFormatter = new SimpleDateFormat(javaTimestampFormat.toString());
                        this.timezoneElementType = ElementType.TZAbbr_ElementType;
                        idx += this.addElement(ElementType.TZAbbr_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    this.addRawChar(javaTimestampFormat, sqlTimestampFormat.charAt(idx++));
                    continue block13;
                }
                case 'Y': {
                    if (formatUpperCase.substring(idx).startsWith(ElementType.Year_ElementType.getSqlFormat())) {
                        idx += this.addElement(ElementType.Year_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    if (formatUpperCase.substring(idx).startsWith(ElementType.Year2digit_ElementType.getSqlFormat())) {
                        this.has2digitYear = true;
                        idx += this.addElement(ElementType.Year2digit_ElementType, javaTimestampFormat, elementTypes);
                        continue block13;
                    }
                    this.addRawChar(javaTimestampFormat, sqlTimestampFormat.charAt(idx++));
                    continue block13;
                }
                case '.': {
                    if (idx + 1 < formatUpperCase.length() && formatUpperCase.substring(idx + 1).startsWith(ElementType.MilliSecond_ElementType.getSqlFormat())) {
                        this.fractionsWithDot = true;
                        ++idx;
                        continue block13;
                    }
                    this.addRawChar(javaTimestampFormat, sqlTimestampFormat.charAt(idx++));
                    continue block13;
                }
                case 'F': {
                    if (formatUpperCase.substring(idx).startsWith(ElementType.MilliSecond_ElementType.getSqlFormat())) {
                        this.fractionsPreFormatter = new SimpleDateFormat(javaTimestampFormat.toString());
                        this.fractionsPos = javaTimestampFormat.toString().length();
                        this.fractionsLen = -1;
                        if ((idx += ElementType.MilliSecond_ElementType.getSqlFormat().length()) >= formatUpperCase.length() || !Character.isDigit(formatUpperCase.charAt(idx))) continue block13;
                        this.fractionsLen = Character.digit(formatUpperCase.charAt(idx), 10);
                        ++idx;
                        continue block13;
                    }
                    this.addRawChar(javaTimestampFormat, sqlTimestampFormat.charAt(idx++));
                    continue block13;
                }
                case '\"': {
                    int endIdx;
                    for (endIdx = idx + 1; endIdx < sqlTimestampFormat.length() && sqlTimestampFormat.charAt(endIdx) != '\"'; ++endIdx) {
                    }
                    if (endIdx == sqlTimestampFormat.length()) {
                        throw new IllegalArgumentException("Unterminated '\"'");
                    }
                    if (endIdx == idx + 1) {
                        javaTimestampFormat.append("\"");
                    } else {
                        javaTimestampFormat.append("'");
                        javaTimestampFormat.append(sqlTimestampFormat.substring(idx + 1, endIdx));
                        javaTimestampFormat.append("'");
                    }
                    idx = endIdx + 1;
                    continue block13;
                }
            }
            this.addRawChar(javaTimestampFormat, sqlTimestampFormat.charAt(idx++));
        }
        if (!elementTypes.isEmpty() || javaTimestampFormat.length() > 0 || this.fractionsLen > 0) {
            this.createNewFragment(javaTimestampFormat.toString(), elementTypes);
        }
    }

    public final String toSimpleDateTimePattern() {
        if (this.automaticParsing) {
            return null;
        }
        if (this.fragments.size() == 0) {
            return "";
        }
        if (this.fragments.size() == 1) {
            return this.fragments.get(0).javaFormat;
        }
        return this.fragments.get(0).javaFormat + "FFF" + this.fragments.get(1).javaFormat;
    }

    public String format(Timestamp timestamp, String timeZoneId, int scale) {
        return this.format(timestamp, timeZoneId == null ? GMT : TimeZone.getTimeZone(timeZoneId), scale);
    }

    public String format(Timestamp timestamp, TimeZone timeZone, int scale) {
        return this.format(timestamp, timeZone, timestamp.getNanos(), scale);
    }

    public String format(Date date, String timeZoneId) {
        return this.format(date, timeZoneId == null ? GMT : TimeZone.getTimeZone(timeZoneId));
    }

    public String format(Date date, TimeZone timeZone) {
        return this.format(date, timeZone, 0, 0);
    }

    public String format(SFTime sfTime, int scale) {
        return this.format(new Time(sfTime.getFractionalSeconds(3)), GMT, sfTime.getNanosecondsWithinSecond(), scale);
    }

    private String format(Date timestampOrDate, TimeZone timeZone, int nanos, int scale) {
        SimpleDateFormat formatter;
        if (this.fractionsPos >= 0) {
            assert (this.fragments.size() == 1);
            if (this.fractionsLen >= 0) {
                scale = this.fractionsLen;
            }
            String nanoStr = String.format("%1$09d", nanos).substring(0, scale);
            String oldFormat = this.fragments.get(0).javaFormat;
            if (this.fractionsWithDot) {
                nanoStr = "." + nanoStr;
            }
            String newDateFormat = oldFormat.substring(0, this.fractionsPos) + nanoStr + oldFormat.substring(this.fractionsPos);
            formatter = new SimpleDateFormat(newDateFormat);
        } else {
            if (this.simpleDateFormat == null) {
                throw new IllegalArgumentException("formatter is null. automaticParsing: " + this.automaticParsing);
            }
            formatter = this.simpleDateFormat;
        }
        formatter.setCalendar(CalendarCache.get(timeZone));
        return formatter.format(timestampOrDate);
    }

    private SFTimestamp tryParsing(String stringToParse, TimeZone timeZone, int centuryBoundary, boolean ignoreTimezone, boolean isStrict, boolean cCompatibility) {
        Date date;
        int idx;
        ParsePosition pp;
        int nanos = 0;
        if (this.fractionsPos >= 0) {
            assert (this.fractionsPreFormatter != null);
            pp = new ParsePosition(0);
            Date firstDate = this.fractionsPreFormatter.parse(stringToParse, pp);
            if (firstDate == null || pp.getIndex() == 0) {
                return null;
            }
            int fracIdx = idx = pp.getIndex();
            boolean dotOK = true;
            if (this.fractionsWithDot) {
                if (stringToParse.length() <= idx || stringToParse.charAt(idx) != '.') {
                    dotOK = false;
                } else {
                    ++idx;
                }
            }
            int mul = 100000000;
            boolean hadDigits = false;
            while (idx < stringToParse.length() && Character.isDigit(stringToParse.charAt(idx))) {
                if (mul > 0) {
                    nanos += mul * Character.digit(stringToParse.charAt(idx), 10);
                    mul /= 10;
                }
                ++idx;
                hadDigits = true;
            }
            if (hadDigits && !dotOK) {
                return null;
            }
            stringToParse = stringToParse.substring(0, fracIdx) + stringToParse.substring(idx);
        }
        if (this.simpleDateFormat == null) {
            throw new IllegalArgumentException("formatter is null. automaticParsing: " + this.automaticParsing);
        }
        this.simpleDateFormat.setCalendar(CalendarCache.get(timeZone));
        this.simpleDateFormat.setLenient(!isStrict);
        if (centuryBoundary > 0 && this.has2digitYear) {
            this.simpleDateFormat.set2DigitYearStart(new Date(centuryBoundary - 1900, 0, 1));
        }
        if ((date = this.simpleDateFormat.parse(stringToParse, pp = new ParsePosition(0))) == null || pp.getIndex() != stringToParse.length()) {
            return null;
        }
        if (this.timezonePreFormatter != null) {
            pp = new ParsePosition(0);
            this.timezonePreFormatter.parse(stringToParse, pp);
            idx = pp.getIndex();
            String inputString = stringToParse.substring(idx);
            String formatString = this.timezoneElementType.javaFormat;
            SimpleDateFormat tzFormatter = new SimpleDateFormat(formatString);
            pp = new ParsePosition(0);
            Date tzDate = tzFormatter.parse(inputString, pp);
            int timeZoneOffset = -((int)tzDate.getTime());
            if (ignoreTimezone) {
                long ms = date.getTime();
                date = new Date(ms += (long)timeZoneOffset);
            } else {
                timeZone = new SimpleTimeZone(timeZoneOffset, "GENERATED" + timeZoneOffset);
            }
        }
        if (cCompatibility && !(timeZone instanceof TimeUtil.CCompatibleTimeZone) && TimeUtil.isDSTAmbiguous(date.getTime(), timeZone)) {
            date = new Date(date.getTime() - (long)timeZone.getDSTSavings());
        }
        return SFTimestamp.fromDate(date, nanos, timeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SFTimestamp parse(String stringToParse, TimeZone timeZone, int centuryBoundary, boolean ignoreTimezone, boolean isStrict, boolean cCompatibility) {
        timeZone = timeZone == null ? GMT : timeZone;
        SFTimestamp result = null;
        if (this.automaticParsing) {
            try {
                long SECONDS_LIMIT_FOR_EPOCH = 31536000000L;
                long MILLISECONDS_LIMIT_FOR_EPOCH = SECONDS_LIMIT_FOR_EPOCH * 1000L;
                long MICROSECONDS_LIMIT_FOR_EPOCH = SECONDS_LIMIT_FOR_EPOCH * 1000000L;
                long val = Long.parseLong(stringToParse);
                if (!this.epochAutoScale) {
                    return SFTimestamp.fromMilliseconds(val * 1000L, GMT);
                }
                if (val > -SECONDS_LIMIT_FOR_EPOCH && val < SECONDS_LIMIT_FOR_EPOCH) {
                    return SFTimestamp.fromMilliseconds(val * 1000L, GMT);
                }
                if (val > -MILLISECONDS_LIMIT_FOR_EPOCH && val < MILLISECONDS_LIMIT_FOR_EPOCH) {
                    return SFTimestamp.fromMilliseconds(val, GMT);
                }
                if (val > -MICROSECONDS_LIMIT_FOR_EPOCH && val < MICROSECONDS_LIMIT_FOR_EPOCH) {
                    return SFTimestamp.fromNanoseconds(val * 1000L, GMT);
                }
                return SFTimestamp.fromNanoseconds(val, GMT);
            }
            catch (NumberFormatException numberFormatException) {
                SnowflakeDateTimeFormat[] snowflakeDateTimeFormatArray = acceptedFormats;
                int n = snowflakeDateTimeFormatArray.length;
                for (int i = 0; i < n; ++i) {
                    SnowflakeDateTimeFormat format;
                    SnowflakeDateTimeFormat snowflakeDateTimeFormat = format = snowflakeDateTimeFormatArray[i];
                    synchronized (snowflakeDateTimeFormat) {
                        result = format.tryParsing(stringToParse, timeZone, centuryBoundary, ignoreTimezone, isStrict, cCompatibility);
                    }
                    if (result != null) break;
                }
            }
        } else {
            result = this.tryParsing(stringToParse, timeZone, centuryBoundary, ignoreTimezone, isStrict, cCompatibility);
        }
        return result;
    }

    public SFTimestamp parse(String stringToParse, String timeZoneId, int centuryBoundary, boolean ignoreTimezone, boolean isStrict) {
        return this.parse(stringToParse, timeZoneId == null ? GMT : TimeZone.getTimeZone(timeZoneId), centuryBoundary, ignoreTimezone, isStrict, false);
    }

    public SFTimestamp parse(String stringToParse) {
        return this.parse(stringToParse, GMT, 0, false, false, false);
    }

    public static String effectiveSpecializedTimestampFormat(String specialized, String generic) {
        if (specialized == null || specialized.length() == 0) {
            return generic;
        }
        return specialized;
    }

    public class Fragment {
        private String javaFormat;
        private List<ElementType> elements;

        public Fragment(String javaFormat, List<ElementType> elements) {
            this.javaFormat = javaFormat;
            this.elements = elements;
        }
    }

    public static enum ElementType {
        Year2digit_ElementType("YY", "yy"),
        Year_ElementType("YYYY", "yyyy"),
        Month_ElementType("MM", "MM"),
        MonthAbbrev_ElementType("MON", "MMM"),
        DayOfMonth_ElementType("DD", "dd"),
        DayOfWeekAbbrev_ElementType("DY", "EEE"),
        Hour24_ElementType("HH24", "HH"),
        Hour12_ElementType("HH12", "hh"),
        Hour_ElementType("HH", "HH"),
        Ante_Meridiem_ElementType("AM", "a"),
        Post_Meridiem_ElementType("PM", "a"),
        Minute_ElementType("MI", "mm"),
        Second_ElementType("SS", "ss"),
        MilliSecond_ElementType("FF", ""),
        TZOffsetHourColonMin_ElementType("TZH:TZM", "XXX"),
        TZOffsetHourMin_ElementType("TZHTZM", "XX"),
        TZOffsetHourOnly_ElementType("TZH", "X"),
        TZAbbr_ElementType("TZD", "z");

        private String sqlFormat;
        private String javaFormat;

        private ElementType(String sqlFormat, String javaFormat) {
            this.sqlFormat = sqlFormat;
            this.javaFormat = javaFormat;
        }

        public String getSqlFormat() {
            return this.sqlFormat;
        }

        public String getJavaFormat() {
            return this.javaFormat;
        }
    }
}

