/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.carrotsearch.hppc;

import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.BitMixer;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.HashOrderMixing;
import net.snowflake.client.jdbc.internal.com.carrotsearch.hppc.ObjectCharHashMap;

public class ObjectCharScatterMap<KType>
extends ObjectCharHashMap<KType> {
    public ObjectCharScatterMap() {
        this(4);
    }

    public ObjectCharScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectCharScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(KType key) {
        return BitMixer.mixPhi(key);
    }

    public static <KType> ObjectCharScatterMap<KType> from(KType[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectCharScatterMap<KType> map = new ObjectCharScatterMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

