/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector;

import net.snowflake.client.jdbc.internal.apache.arrow.memory.BufferAllocator;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BaseVariableWidthVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BitVectorHelper;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.VarBinaryReaderImpl;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.reader.FieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableVarBinaryHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.VarBinaryHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.FieldType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.util.TransferPair;

public class VarBinaryVector
extends BaseVariableWidthVector {
    private final FieldReader reader = new VarBinaryReaderImpl(this);

    public VarBinaryVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.VARBINARY.getType()), allocator);
    }

    public VarBinaryVector(String name, FieldType fieldType, BufferAllocator allocator) {
        super(name, allocator, fieldType);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.VARBINARY;
    }

    public byte[] get(int index) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        int startOffset = this.getstartOffset(index);
        int dataLength = this.offsetBuffer.getInt((index + 1) * 4) - startOffset;
        byte[] result = new byte[dataLength];
        this.valueBuffer.getBytes(startOffset, result, 0, dataLength);
        return result;
    }

    public byte[] getObject(int index) {
        byte[] b;
        try {
            b = this.get(index);
        }
        catch (IllegalStateException e) {
            return null;
        }
        return b;
    }

    public void get(int index, NullableVarBinaryHolder holder) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.start = this.getstartOffset(index);
        holder.end = this.offsetBuffer.getInt((index + 1) * 4);
        holder.buffer = this.valueBuffer;
    }

    public void copyFrom(int fromIndex, int thisIndex, VarBinaryVector from) {
        int start = from.offsetBuffer.getInt(fromIndex * 4);
        int end = from.offsetBuffer.getInt((fromIndex + 1) * 4);
        int length = end - start;
        this.fillHoles(thisIndex);
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        int copyStart = this.offsetBuffer.getInt(thisIndex * 4);
        from.valueBuffer.getBytes(start, this.valueBuffer, copyStart, length);
        this.offsetBuffer.setInt((thisIndex + 1) * 4, copyStart + length);
        this.lastSet = thisIndex;
    }

    public void copyFromSafe(int fromIndex, int thisIndex, VarBinaryVector from) {
        int start = from.offsetBuffer.getInt(fromIndex * 4);
        int end = from.offsetBuffer.getInt((fromIndex + 1) * 4);
        int length = end - start;
        this.handleSafe(thisIndex, length);
        this.fillHoles(thisIndex);
        BitVectorHelper.setValidityBit(this.validityBuffer, thisIndex, from.isSet(fromIndex));
        int copyStart = this.offsetBuffer.getInt(thisIndex * 4);
        from.valueBuffer.getBytes(start, this.valueBuffer, copyStart, length);
        this.offsetBuffer.setInt((thisIndex + 1) * 4, copyStart + length);
        this.lastSet = thisIndex;
    }

    public void set(int index, VarBinaryHolder holder) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        int dataLength = holder.end - holder.start;
        int startOffset = this.getstartOffset(index);
        this.offsetBuffer.setInt((index + 1) * 4, startOffset + dataLength);
        this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, dataLength);
        this.lastSet = index;
    }

    public void setSafe(int index, VarBinaryHolder holder) {
        assert (index >= 0);
        int dataLength = holder.end - holder.start;
        this.fillEmpties(index);
        this.handleSafe(index, dataLength);
        BitVectorHelper.setValidityBitToOne(this.validityBuffer, index);
        int startOffset = this.getstartOffset(index);
        this.offsetBuffer.setInt((index + 1) * 4, startOffset + dataLength);
        this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, dataLength);
        this.lastSet = index;
    }

    public void set(int index, NullableVarBinaryHolder holder) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, holder.isSet);
        int dataLength = holder.end - holder.start;
        int startOffset = this.getstartOffset(index);
        this.offsetBuffer.setInt((index + 1) * 4, startOffset + dataLength);
        this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, dataLength);
        this.lastSet = index;
    }

    public void setSafe(int index, NullableVarBinaryHolder holder) {
        assert (index >= 0);
        int dataLength = holder.end - holder.start;
        this.fillEmpties(index);
        this.handleSafe(index, dataLength);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, holder.isSet);
        int startOffset = this.getstartOffset(index);
        this.offsetBuffer.setInt((index + 1) * 4, startOffset + dataLength);
        this.valueBuffer.setBytes(startOffset, holder.buffer, holder.start, dataLength);
        this.lastSet = index;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((VarBinaryVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        VarBinaryVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new VarBinaryVector(ref, VarBinaryVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(VarBinaryVector to) {
            this.to = to;
        }

        @Override
        public VarBinaryVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            VarBinaryVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            VarBinaryVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, VarBinaryVector.this);
        }
    }
}

